/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * @example: can_dma_if2
 * @Language:English
 * @encode:
 * @brief:
 * This example demonstrates can_dma_if2. The DMA is triggered to transfer the data packets after the secondary priority transmission.
 * The process is in normal mode. It directly uses the secondary priority to actively send packets, then triggers the DMA for transmission. After sending 16 packets, it stops the DMA in the interrupt service function.
 * The CANFD protocol is used. The baud rate is set to 1M for the arbitration segment and 4M for the data segment. The sampling point is 80%.
 */

/*
 * @example: can_dma_if2
 * @Language:Chinese
 * @encode:GBK
 * @brief:
 *	ʾcan_dma_if2dmaڴμȼͺʱ򴥷dma˱
 *	̿ģʽֱʹôμȼͱ Ȼ󴥷dma˷ͣ16ĺжϷֹͣdmaһ17ģ
 *	ʹCANFDЭ Ϊٲö1M ݶ4M 80%
 */

#include "device.h"
#include "can_dma_if2.h"
CAN_TxMessage_t TxMsgBuf0 = {0};
#define Delay_value  10000000
volatile int status4;
int main(void)
{
	uint32_t i;
	uint32_t Delay = Delay_value;

	Device_init();
	DisableDCache();
	__disable_irq();

	UartPrint_init(LOG_SCI_BASE, 115200);

	GPIO_setPinConfig(CAN_RX_PIN);
	GPIO_setPinConfig(CAN_TX_PIN);


	can_ctrl_init();

	__enable_irq();
	dma_ex_can2m();
	TxMsgBuf0.dlc = CAN_DATA_LENGTH_8;
	TxMsgBuf0.id = 0x10;
	TxMsgBuf0.ide = 0;
	TxMsgBuf0.fdf = 1;

	for (i = 0; i < CAN_getMessageLength(TxMsgBuf0.dlc); i++)
	{
		TxMsgBuf0.data[i] = i;
	}
	while(!CAN_transmitMsg(CAN_BASE, &TxMsgBuf0));

	while (1) {

	}
}
