/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <string.h>
#include "device.h"
#include "can_scheduled.h"

CAN_TxMessage_t TxMsgBuf = {0};
CAN_RxMessage_t RxMsgBuf = {0};

void can_config(void)
{
	CAN_InitParams_t initParams = {0};
	CAN_FilterElement_t stdFiltelem = {0};

	initParams.fdMode = false;
	initParams.txbmode = CAN_TS_MODE_PRIORITY;
	initParams.timestamp = CAN_TIMESTAMP_EOF;

	/* accept all CAN ID frames. */
	stdFiltelem.acode = 0xc0;
	stdFiltelem.amsk = 0x1fffffff;
	stdFiltelem.filerFrameType = CAN_IDTYPE_BOTH_STD_EXT;

	/* Initial CAN module. */
	if (!CAN_initModule(CAN_BASE))
		while (1);

	/* Configuration CAN basic function. */
	if (!CAN_initConfig(CAN_BASE, &initParams))
		while (1);

	/* Set the arbitration segment bit rate based on sampling points. */
	if (!CAN_setBitRateSamplePoint(CAN_BASE, 40000000, 1U * 1000 * 1000, 0.8))
		while (1);

	/* Set CAN ID acceptance filter 0. */
	if (!CAN_configMsgFilter(CAN_BASE, 0, &stdFiltelem))
		while (1);

	/* Enable CAN ID acceptance filter 0. */
	if (!CAN_configMsgFilterEnable(CAN_BASE, 0))
		while (1);

	/* Start running CAN module. */
	if (!CAN_startModule(CAN_BASE))
		while (1);

	/* disable internal loopback mode. */
	if (!CAN_lpbkModeEnable(CAN_BASE, CAN_LPBK_MODE_INTERNAL, false))
		while (1);
}

void can_ctrl_init(void)
{
	/*CANʱԴѡ*/
	SysCtl_setCanClkSrcSel(CAN_CLK_TYPE_PLL);

	/* CAN clock source = 40MHz, PLL_CLK = 2* SYS_CLK */
	SysCtl_setCanClkDiv((DEVICE_SYSCLK_FREQ * 2 / 40000000));

	can_config();
}

void scheduledreception()
{

	TxMsgBuf.dlc = CAN_DATA_LENGTH_8;
	TxMsgBuf.id = 0xc0;

	uint32_t status;
	while (!(CAN_getRxBufState(CAN_BASE) == CAN_RXBUFFER_EMPTY))
	{
		CAN_receiveMsg(CAN_BASE, &RxMsgBuf);
		TxMsgBuf.dlc = RxMsgBuf.dlc;
		TxMsgBuf.id = RxMsgBuf.id + 1;
		TxMsgBuf.ide = RxMsgBuf.ide;
		TxMsgBuf.rtr = RxMsgBuf.rtr;
		memcpy(TxMsgBuf.data, RxMsgBuf.data, CAN_getMessageLength(RxMsgBuf.dlc));
		while (!CAN_transmitMsg(CAN_BASE, &TxMsgBuf));
	}
}
void scheduledsend(void)
{
	uint32_t i = 0;
	TxMsgBuf.dlc = CAN_DATA_LENGTH_8;
	TxMsgBuf.id = 0x111cc;
	TxMsgBuf.ide = 1;
	TxMsgBuf.rtr = 0;
	for (i = 0; i < CAN_getMessageLength(TxMsgBuf.dlc); i++)
	{
		TxMsgBuf.data[i] = i;
	}
	while (!CAN_transmitMsg(CAN_BASE, &TxMsgBuf));
}
