/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "device.h"
#include "hal_can_ex1_single_mb.h"

uint8_t tx_buff[8] = {0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88};
uint8_t rx_buff[8] = {0};

#define CAN_TX_MSG_CANID	0x4c0

#define CAN_RX_MSG_CANID	0xc0

#define CAN_TX_MSG_ID		1

#define CAN_RX_MSG_ID		2

void hal_can_init(void)
{
	/* initialize HAL_CAN structure variables */
	HAL_CAN_initCfg(CAN_BASE);

	/* put CAN into reset mode, and disable all CAN interrupt sources. */
	CAN_initModule(CAN_BASE);

	/* Configure CAN speed to 500Kbps based on 40MHz clock source, with each bit time 40Tq */
	CAN_setBitRate(CAN_BASE, 40000000, 500000, 20);

	/* Configure the Virtual mailbox when CAN in RESET mode */
	HAL_CAN_setupMessageObject(CAN_BASE, CAN_TX_MSG_ID, CAN_TX_MSG_CANID, HAL_CAN_MSG_ID_STD,
			HAL_CAN_MSG_OBJ_TYPE_TX, 0x0, HAL_CAN_MSG_OBJ_NO_FLAGS, 8);
	HAL_CAN_setupMessageObject(CAN_BASE, CAN_RX_MSG_ID, CAN_RX_MSG_CANID, HAL_CAN_MSG_ID_STD,
				HAL_CAN_MSG_OBJ_TYPE_RX, 0x0, HAL_CAN_MSG_OBJ_NO_FLAGS, 8);

	/* put CAN into normal mode.
	 * The virtual mailbox can be changed during CAN normal mode,
	 * but the message filter/mask need be configured during CAN RESET mode. */
	CAN_startModule(CAN_BASE);

	CAN_enableInterrupt(CAN_BASE, CAN_RTIE_RIE_M);
}

void hal_can_run(void)
{
	HAL_CAN_MAIL_BOX *txpMB;
	HAL_CAN_MAIL_BOX *rxpMB;

	/* Update the configuration to HW register. */
	HAL_CAN_updateRegsAndMB(CAN_BASE);

	/* Send a message. */
	txpMB = HAL_CAN_getMBbyObjID(CAN_BASE, CAN_TX_MSG_ID);
	HAL_CAN_loadMailBoxDataOnly_8bit(CAN_BASE, CAN_TX_MSG_ID, tx_buff, 8);
	HAL_CAN_sendMailBox(CAN_BASE, CAN_TX_MSG_ID);

	/* Receive a message */
	rxpMB = HAL_CAN_getMBbyObjID(CAN_BASE, CAN_RX_MSG_ID);
	if(rxpMB->Ctrl.bit.NewDat == 1) {
		rx_buff[0] = rxpMB->Data[0].bit.Data_0;
		rx_buff[1] = rxpMB->Data[0].bit.Data_1;
		rx_buff[2] = rxpMB->Data[0].bit.Data_2;
		rx_buff[3] = rxpMB->Data[0].bit.Data_3;

		rx_buff[4] = rxpMB->Data[1].bit.Data_0;
		rx_buff[5] = rxpMB->Data[1].bit.Data_1;
		rx_buff[6] = rxpMB->Data[1].bit.Data_2;
		rx_buff[7] = rxpMB->Data[1].bit.Data_3;

		HAL_CAN_releaseMB(CAN_BASE, CAN_RX_MSG_ID);
	}
}
