/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    clb_ex06_plusegen.c
*   @brief
*   @details
*

//! See LICENSE for license details.
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"
#include "board.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define EDA_CSIM                  0             //set to 1 when make target for simulation

#if EDA_CSIM != 0
#define LOG_LEVEL                 LOG_ERROR
void _putchar(char character)
{
    //do nothing
}
#else
#define LOG_LEVEL                 LOG_INFO
#endif

#define LED_STA_PIN     GPIO_PIN_LED2
#define GPREG_0_EVENT_DATA_SHIFT  0U
#define GPREG_1_MODE0_EN_SHIFT    1U
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


int main(void)
{
	uint32_t oldTicks,remVal;

	__disable_irq();

	Device_init();
	SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_CLB);

	UartPrint_init(LOG_SCI_BASE, 115200);


    __enable_irq();


   Board_init();
   pto_pulsegen_startOperation();
   //
   // Run pulsegen with specified respective values for low pulse width,
   // high pulse width, Active Period, Full Period, Interrupt Time,
   // ptoDirection output, and run status (1-run and 0-stop)
   //
   remVal = pto_pulsegen_runPulseGen(50, 50, 1000, 1000, 500, 1, 1);

   XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT1,XBAR_OUT_MUX04_CLB1_OUT5);
   XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT1, XBAR_MUX04);
   XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT2,XBAR_OUT_MUX05_CLB1_OUT6);
   XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT2, XBAR_MUX05);


   while(1)
       {

       }



    return 0;
}

