/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
// EPWM1 -> myEPWM1 Pinmux
//
//
// EPWM1_A - GPIO Settings
//
#define GPIO_PIN_EPWM1_A 0
#define myEPWM1_EPWMA_GPIO 0
#define myEPWM1_EPWMA_PIN_CONFIG GPIO_0_EPWM1_A
//
// EPWM1_B - GPIO Settings
//
#define GPIO_PIN_EPWM1_B 1
#define myEPWM1_EPWMB_GPIO 1
#define myEPWM1_EPWMB_PIN_CONFIG GPIO_1_EPWM1_B

//
// EPWM2 -> myEPWM2 Pinmux
//
//
// EPWM2_A - GPIO Settings
//
#define GPIO_PIN_EPWM2_A 2
#define myEPWM2_EPWMA_GPIO 2
#define myEPWM2_EPWMA_PIN_CONFIG GPIO_2_EPWM2_A
//
// EPWM2_B - GPIO Settings
//
#define GPIO_PIN_EPWM2_B 3
#define myEPWM2_EPWMB_GPIO 3
#define myEPWM2_EPWMB_PIN_CONFIG GPIO_3_EPWM2_B


#include "board.h"
#include "driverlib.h"

//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules. 
// Call this function in your application if you wish to do all module 
// initialization.
// If you wish to not use some of the initializations, instead of the 
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
	EALLOW;

	PinMux_init();
	CLB_init();

	EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
	//
		// PinMux for modules assigned to CPU1
		//

		//
		// EPWM1 -> myEPWM1 Pinmux
		//
		GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
		GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

		GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
		GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

		//
		// EPWM2 -> myEPWM2 Pinmux
		//
		GPIO_setPinConfig(myEPWM2_EPWMA_PIN_CONFIG);
		GPIO_setPadConfig(myEPWM2_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(myEPWM2_EPWMA_GPIO, GPIO_QUAL_SYNC);

		GPIO_setPinConfig(myEPWM2_EPWMB_PIN_CONFIG);
		GPIO_setPadConfig(myEPWM2_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(myEPWM2_EPWMB_GPIO, GPIO_QUAL_SYNC);

		GPIO_setPinConfig(GPIO_22_CLB_OUTPUTXBAR1);
		GPIO_setPadConfig(22, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(22, GPIO_QUAL_SYNC);

		GPIO_setPinConfig(GPIO_7_CLB_OUTPUTXBAR2);
		GPIO_setPadConfig(7, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(7, GPIO_QUAL_SYNC);

		GPIO_setPinConfig(GPIO_24_OUTPUTXBAR1);
		GPIO_setPadConfig(24, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(24, GPIO_QUAL_SYNC);

		GPIO_setPinConfig(GPIO_25_OUTPUTXBAR2);
		GPIO_setPadConfig(25, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(25, GPIO_QUAL_SYNC);

}

//*****************************************************************************
//
// CLB Configurations
//
//*****************************************************************************
void CLB_init(){
	myCLB0_init();
	myCLB1_init();
	initEPWM();
}

void myCLB0_init(){

	//
	// myCLB0 CLB_IN0 initialization
	//
	// The following functions configure the CLB input mux and whether the inputs
	// have synchronization or pipeline enabled; check the device manual for more
	// information on when a signal needs to be synchronized or go through a
	// pipeline filter
	//

	CLB_configGlobalInputMux(myCLB0_BASE, CLB_IN0, CLB_GLOBAL_IN_MUX_EPWM1A);
	CLB_configGPInputMux(myCLB0_BASE, CLB_IN0, CLB_GP_IN_MUX_GP_REG);
	CLB_selectInputFilter(myCLB0_BASE, CLB_IN0, CLB_FILTER_NONE);
	//
	// myCLB0 CLB_IN1 initialization
	//
	// The following functions configure the CLB input mux and whether the inputs
	// have synchronization or pipeline enabled; check the device manual for more
	// information on when a signal needs to be synchronized or go through a
	// pipeline filter
	//

	CLB_configGlobalInputMux(myCLB0_BASE, CLB_IN1, CLB_GLOBAL_IN_MUX_EPWM1A );
	CLB_configGPInputMux(myCLB0_BASE, CLB_IN1, CLB_GP_IN_MUX_EXTERNAL);

	CLB_selectInputFilter(myCLB0_BASE, CLB_IN1, CLB_FILTER_NONE);
	//
	// myCLB0 CLB_IN2 initialization
	//
	// The following functions configure the CLB input mux and whether the inputs
	// have synchronization or pipeline enabled; check the device manual for more
	// information on when a signal needs to be synchronized or go through a
	// pipeline filter
	//

	CLB_configGlobalInputMux(myCLB0_BASE, CLB_IN2, CLB_GLOBAL_IN_MUX_EPWM1A);
	CLB_configGPInputMux(myCLB0_BASE, CLB_IN2, CLB_GP_IN_MUX_EXTERNAL);

	CLB_selectInputFilter(myCLB0_BASE, CLB_IN2, CLB_FILTER_ANY_EDGE);
	//
	// myCLB0 CLB_IN4 initialization
	//
	// The following functions configure the CLB input mux and whether the inputs
	// have synchronization or pipeline enabled; check the device manual for more
	// information on when a signal needs to be synchronized or go through a
	// pipeline filter
	//

	CLB_configGlobalInputMux(myCLB0_BASE, CLB_IN4, CLB_GLOBAL_IN_MUX_EPWM1B);
	CLB_configGPInputMux(myCLB0_BASE, CLB_IN4, CLB_GP_IN_MUX_EXTERNAL);

	CLB_selectInputFilter(myCLB0_BASE, CLB_IN4, CLB_FILTER_NONE);
	//
	// myCLB0 CLB_IN5 initialization
	//
	// The following functions configure the CLB input mux and whether the inputs
	// have synchronization or pipeline enabled; check the device manual for more
	// information on when a signal needs to be synchronized or go through a
	// pipeline filter
	//

	CLB_configGlobalInputMux(myCLB0_BASE, CLB_IN5, CLB_GLOBAL_IN_MUX_EPWM1B);
	CLB_configGPInputMux(myCLB0_BASE, CLB_IN5, CLB_GP_IN_MUX_EXTERNAL);

	CLB_selectInputFilter(myCLB0_BASE, CLB_IN5, CLB_FILTER_ANY_EDGE);
	//
	// myCLB0 CLB_IN7 initialization
	//
	// The following functions configure the CLB input mux and whether the inputs
	// have synchronization or pipeline enabled; check the device manual for more
	// information on when a signal needs to be synchronized or go through a
	// pipeline filter
	//

	CLB_configGlobalInputMux(myCLB0_BASE, CLB_IN7, CLB_GLOBAL_IN_MUX_EPWM2A );
	CLB_configGPInputMux(myCLB0_BASE, CLB_IN7, CLB_GP_IN_MUX_EXTERNAL);

	CLB_selectInputFilter(myCLB0_BASE, CLB_IN7, CLB_FILTER_RISING_EDGE);
	CLB_setGPREG(myCLB0_BASE,1);


}
void myCLB1_init(){

	//
	// myCLB1 CLB_IN0 initialization
	//
	// The following functions configure the CLB input mux and whether the inputs
	// have synchronization or pipeline enabled; check the device manual for more
	// information on when a signal needs to be synchronized or go through a
	// pipeline filter
	//

	CLB_configGlobalInputMux(myCLB1_BASE, CLB_IN0, CLB_GLOBAL_IN_MUX_EPWM1A );
	CLB_configGPInputMux(myCLB1_BASE, CLB_IN0, CLB_GP_IN_MUX_GP_REG);
	CLB_selectInputFilter(myCLB1_BASE, CLB_IN0, CLB_FILTER_NONE);
	//
	// myCLB1 CLB_IN1 initialization
	//
	// The following functions configure the CLB input mux and whether the inputs
	// have synchronization or pipeline enabled; check the device manual for more
	// information on when a signal needs to be synchronized or go through a
	// pipeline filter
	//

	CLB_configGlobalInputMux(myCLB1_BASE, CLB_IN1, CLB_GLOBAL_IN_MUX_EPWM1A);
	CLB_configGPInputMux(myCLB1_BASE, CLB_IN1, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputFilter(myCLB1_BASE, CLB_IN1, CLB_FILTER_NONE);
	//
	// myCLB1 CLB_IN2 initialization
	//
	// The following functions configure the CLB input mux and whether the inputs
	// have synchronization or pipeline enabled; check the device manual for more
	// information on when a signal needs to be synchronized or go through a
	// pipeline filter
	//

	CLB_configGlobalInputMux(myCLB1_BASE, CLB_IN2, CLB_GLOBAL_IN_MUX_EPWM1A);
	CLB_configGPInputMux(myCLB1_BASE, CLB_IN2, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputFilter(myCLB1_BASE, CLB_IN2, CLB_FILTER_ANY_EDGE);
	//
	// myCLB1 CLB_IN4 initialization
	//
	// The following functions configure the CLB input mux and whether the inputs
	// have synchronization or pipeline enabled; check the device manual for more
	// information on when a signal needs to be synchronized or go through a
	// pipeline filter
	//

	CLB_configGlobalInputMux(myCLB1_BASE, CLB_IN4, CLB_GLOBAL_IN_MUX_EPWM1B );
	CLB_configGPInputMux(myCLB1_BASE, CLB_IN4, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputFilter(myCLB1_BASE, CLB_IN4, CLB_FILTER_ANY_EDGE);
	//
	// myCLB1 CLB_IN7 initialization
	//
	// The following functions configure the CLB input mux and whether the inputs
	// have synchronization or pipeline enabled; check the device manual for more
	// information on when a signal needs to be synchronized or go through a
	// pipeline filter
	//

	CLB_configGlobalInputMux(myCLB1_BASE, CLB_IN7, CLB_GLOBAL_IN_MUX_CLB1_OUT4);
	CLB_configGPInputMux(myCLB1_BASE, CLB_IN7, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputFilter(myCLB1_BASE, CLB_IN7, CLB_FILTER_NONE);


//	CLB_disableCLB(myCLB1_BASE);
}
void initEPWM(void)
{
	EPWM_setClockPrescaler(EPWM1_BASE, EPWM_CLOCK_DIVIDER_1,
	    						   EPWM_HSCLOCK_DIVIDER_1);

	EPWM_setTimeBaseCounter(EPWM1_BASE, 0);
	EPWM_setTimeBasePeriod(EPWM1_BASE, 12500);

	EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, 10000);
	EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
	EPWM_setCounterCompareValue(EPWM1_BASE, EPWM_COUNTER_COMPARE_B, 5000);
	EPWM_setCounterCompareShadowLoadMode(EPWM1_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);

	EPWM_setActionQualifierAction(EPWM1_BASE,EPWM_AQ_OUTPUT_B,EPWM_AQ_OUTPUT_HIGH,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	EPWM_setActionQualifierAction(EPWM1_BASE,EPWM_AQ_OUTPUT_B,EPWM_AQ_OUTPUT_LOW,EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
	EPWM_setActionQualifierAction(EPWM1_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_HIGH,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	EPWM_setActionQualifierAction(EPWM1_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_LOW,EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);

	EPWM_setTimeBaseCounterMode(EPWM1_BASE, EPWM_COUNTER_MODE_UP_DOWN );
	EPWM_setClockPrescaler(EPWM2_BASE, EPWM_CLOCK_DIVIDER_1,
							   EPWM_HSCLOCK_DIVIDER_1);

	EPWM_setTimeBaseCounter(EPWM2_BASE, 0);
	EPWM_setTimeBasePeriod(EPWM2_BASE, 0xffff);

	EPWM_setCounterCompareValue(EPWM2_BASE, EPWM_COUNTER_COMPARE_A, 0x250);
	EPWM_setCounterCompareShadowLoadMode(EPWM2_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
	EPWM_setCounterCompareValue(EPWM2_BASE, EPWM_COUNTER_COMPARE_B, 0x750);
	EPWM_setCounterCompareShadowLoadMode(EPWM2_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);

	EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_B,EPWM_AQ_OUTPUT_HIGH,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_B,EPWM_AQ_OUTPUT_LOW,EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_LOW,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_HIGH,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);

	EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_LOW,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);

	EPWM_setTimeBaseCounterMode(EPWM2_BASE, EPWM_COUNTER_MODE_UP);
    SysCtl_enablePeripheral_TBCLKSYNC();
	EPWM_setHrpwmDllCfg0(PREEPWM_BASE,0x1);
	HWREG(0x4003F000 + EPWM_O_TZEINT_CON) = 0x10000;


}
