/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void CLB_init(){
	PinMux_init();
	myTILE1_init();
	  // out6 aoc3 set
	  // out7 aoc3 delay
	  //
	  //
	initTILE1(myTILE1_BASE);
	CLB_configOutputLUT(myTILE2_BASE, CLB_OUT0, TILE1_CFG_OUTLUT_0);
	pwm_set();

}

void PinMux_init()
{
	//
	// PinMux for modules assigned to CPU1
	//

	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	// GPI0 0 loop
	GPIO_setLoopBack(myEPWM1_EPWMA_GPIO, 1);

	GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

	//
	// EPWM2 -> myEPWM2 Pinmux
	//
	GPIO_setPinConfig(myEPWM2_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM2_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM2_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM2_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM2_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM2_EPWMB_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_32_CLB_OUTPUTXBAR1);
	GPIO_setPadConfig(32, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(32, GPIO_QUAL_SYNC);


	GPIO_setPinConfig(GPIO_33_CLB_OUTPUTXBAR2);
	GPIO_setPadConfig(33, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(33, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_24_OUTPUTXBAR1);
	GPIO_setPadConfig(24, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(24, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(GPIO_25_OUTPUTXBAR2);
	GPIO_setPadConfig(25, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(25, GPIO_QUAL_SYNC);

}

void myTILE1_init(){


	//
	// myTILE1 CLB_IN0 initialization
	//
	CLB_configGlobalInputMux(myTILE1_BASE, CLB_IN0, CLB_GLOBAL_IN_MUX_XBAE_CLB_INPUT_SEL1_OUT);
	CLB_configGPInputMux(myTILE1_BASE, CLB_IN0,  CLB_GP_IN_MUX_EXTERNAL);

	CLB_selectInputFilter(myTILE1_BASE, CLB_IN0, CLB_FILTER_NONE);
	//
	// myTILE1 CLB_IN2 initialization
	//
	CLB_configGlobalInputMux(myTILE1_BASE, CLB_IN2, CLB_GLOBAL_IN_MUX_EPWM1A);
	CLB_configGPInputMux(myTILE1_BASE, CLB_IN2, CLB_GP_IN_MUX_EXTERNAL);
	CLB_selectInputDelay(myTILE1_BASE,CLB_IN2,100);
	CLB_selectInputFilter(myTILE1_BASE, CLB_IN2, CLB_FILTER_NONE);


	CLB_configGlobalInputMux(myTILE1_BASE, CLB_IN6, CLB_GLOBAL_IN_MUX_EPWM1A);
	CLB_configGPInputMux(myTILE1_BASE, CLB_IN6, CLB_GP_IN_MUX_GP_REG);
	CLB_selectInputFilter(myTILE1_BASE, CLB_IN6, CLB_FILTER_NONE);


	CLB_configGlobalInputMux(myTILE1_BASE, CLB_IN7, CLB_GLOBAL_IN_MUX_EPWM1A);
	CLB_configGPInputMux(myTILE1_BASE, CLB_IN7, CLB_GP_IN_MUX_GP_REG);
	CLB_selectInputDelay(myTILE1_BASE,CLB_IN7,100);
	CLB_selectInputFilter(myTILE1_BASE, CLB_IN7, CLB_FILTER_NONE);
	CLB_LEVEL_RLS_TZ_SEL(myTILE1_BASE,CLB_OUT7);
	// core1
	CLB_LEVEL_RLS_TZ_TYPE(myTILE1_BASE,CLB_OUT7,0x2);

	CLB_LEVEL_RLS_TZ_SEL(myTILE1_BASE,CLB_OUT1);
	CLB_LEVEL_RLS_TZ_TYPE(myTILE1_BASE,CLB_OUT1,0x1);


	CLB_configGlobalInputMux(myTILE2_BASE, CLB_IN0, CLB_GLOBAL_IN_MUX_CLB1_OUT0);
	CLB_configGPInputMux(myTILE2_BASE, CLB_IN0,  CLB_GP_IN_MUX_EXTERNAL);

	CLB_selectInputFilter(myTILE2_BASE, CLB_IN0, CLB_FILTER_NONE);

	CLB_setGPREG(myTILE1_BASE,0);
}

void pwm_set()
{
	EPWM_setClockPrescaler(EPWM1_BASE, EPWM_CLOCK_DIVIDER_1,
							EPWM_HSCLOCK_DIVIDER_1);

	EPWM_setTimeBasePeriod(myEPWM1_BASE, 12000U);
	EPWM_setPhaseShift(myEPWM1_BASE, 0U);
	EPWM_setTimeBaseCounter(myEPWM1_BASE, 0U);

	EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, 10000);
	EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, 8000);


	EPWM_setTripZoneAction(myEPWM1_BASE, EPWM_TZ_ACTION_EVENT_TZB,EPWM_TZ_ACTION_HIGH);
	// Configure ePWM2A to output high on TZA TRIP
	EPWM_setTripZoneAction(myEPWM1_BASE, EPWM_TZ_ACTION_EVENT_TZA,EPWM_TZ_ACTION_HIGH);
		// Trigger event when DCBH is high
	EPWM_setTripZoneDigitalCompareEventCondition(myEPWM1_BASE,EPWM_TZ_DC_OUTPUT_B1,EPWM_TZ_EVENT_DCXH_HIGH);
	EPWM_enableDigitalCompareTripCombinationInput(myEPWM1_BASE,EPWM_DC_COMBINATIONAL_TRIPIN4,EPWM_DC_TYPE_DCBH);
			// Enable DCB as OST
	EPWM_enableTripZoneSignals(myEPWM1_BASE, EPWM_TZ_SIGNAL_DCBEVT1);

		// Configure the DCB path to be unfiltered and asynchronous
	EPWM_setDigitalCompareEventSource(myEPWM1_BASE,EPWM_DC_MODULE_B,EPWM_DC_EVENT_1,EPWM_DC_EVENT_SOURCE_ORIG_SIGNAL);

		// Clear trip flags
	EPWM_clearTripZoneFlag(myEPWM1_BASE, EPWM_TZ_INTERRUPT|EPWM_TZ_FLAG_OST);

	EPWM_setCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
	EPWM_setCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);

	EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
	EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
	EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_NO_CHANGE, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
	EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);

	EPWM_setInterruptSource(myEPWM1_BASE, EPWM_INT_TBCTR_ZERO);
	EPWM_enableInterrupt(myEPWM1_BASE);
	EPWM_setInterruptEventCount(myEPWM1_BASE, 1U);
	EPWM_setTimeBaseCounterMode(myEPWM1_BASE, EPWM_COUNTER_MODE_UP_DOWN);

	EPWM_setTimeBaseCounter(EPWM2_BASE, 0);
	EPWM_setTimeBasePeriod(EPWM2_BASE, 2000);

	EPWM_setCounterCompareValue(EPWM2_BASE,EPWM_COUNTER_COMPARE_A,4000/3);
	EPWM_setCounterCompareValue(EPWM2_BASE,EPWM_COUNTER_COMPARE_B,4000/3);

	//
	// Set up counter mode
	//
	EPWM_setTimeBaseCounterMode(EPWM2_BASE, EPWM_COUNTER_MODE_UP);
	EPWM_disablePhaseShiftLoad(EPWM2_BASE);
	EPWM_setClockPrescaler(EPWM2_BASE,EPWM_CLOCK_DIVIDER_1,EPWM_HSCLOCK_DIVIDER_1);

		    //
		    // Set actions
		    //
	EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_HIGH,EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);


	EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);

	EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_LOW,  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_B,  EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
	EPWM_setActionQualifierAction(EPWM2_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_NO_CHANGE,EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
	//  EPWM_setDigitalCompareEventSource(EPWM2_BASE,EPWM_DC_MODULE_B,EPWM_AQ_OUTPUT_NO_CHANGE,EPWM_DC_EVENT_SOURCE_ORIG_SIGNAL);
	EPWM_selectPeriodLoadEvent(EPWM3_BASE, EPWM_SHADOW_LOAD_MODE_SYNC);
	EPWM_setTimeBasePeriod(EPWM3_BASE, 2000);
	EPWM_setPhaseShift(EPWM3_BASE, 2000/2);
	EPWM_setTimeBaseCounter(EPWM3_BASE, 2000/2);

	//
	// Set Compare values
	//
	EPWM_setCounterCompareValue(EPWM3_BASE, EPWM_COUNTER_COMPARE_A, 4000/3);
	EPWM_setCounterCompareValue(EPWM3_BASE, EPWM_COUNTER_COMPARE_B,  4000/3);

	//
	// Set up counter mode
	//
	EPWM_setTimeBaseCounterMode(EPWM3_BASE, EPWM_COUNTER_MODE_UP);
	EPWM_disablePhaseShiftLoad(EPWM3_BASE);
	EPWM_setClockPrescaler(EPWM3_BASE, EPWM_CLOCK_DIVIDER_8, EPWM_HSCLOCK_DIVIDER_1);

	//
	// Set up shadowing
	//
	EPWM_setCounterCompareShadowLoadMode(EPWM3_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
	EPWM_setCounterCompareShadowLoadMode(EPWM3_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);

	//
	// Set actions
	//
	EPWM_setActionQualifierAction(EPWM3_BASE, EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_HIGH,EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	EPWM_setActionQualifierAction(EPWM3_BASE, EPWM_AQ_OUTPUT_B,EPWM_AQ_OUTPUT_HIGH,EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
	EPWM_setActionQualifierAction(EPWM3_BASE,EPWM_AQ_OUTPUT_A,EPWM_AQ_OUTPUT_LOW,EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
	EPWM_setActionQualifierAction(EPWM3_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);

	SysCtl_enablePeripheral_TBCLKSYNC();
	EPWM_setHrpwmDllCfg0(PREEPWM_BASE,0x1);
}



/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

