/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    ecap_ex04_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "ecap_ex04_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

// Board Configurations
void Board_init()
{
	PinMux_init();
	INPUTXBAR_init();
    ECAP_init();
	GPIO_init();
	INTERRUPT_init();
}

// PINMUX Configurations
void PinMux_init()
{

}

// ECAP Configurations
void ECAP_init()
{
    myECAP1_init();
	myECAP2_init();
	myECAP3_init();
}

// ECAP Configurations for ECAP1
void myECAP1_init()
{
	// Disables time stamp capture.
	
	ECAP_disableTimeStampCapture(myECAP1_BASE);
	
	// Stops Time stamp counter.
	
	ECAP_stopCounter(myECAP1_BASE);
	
	// Sets eCAP in Capture mode.
	
	ECAP_enableCaptureMode(myECAP1_BASE);
	
	// Sets the capture mode.
	
	ECAP_setCaptureMode(myECAP1_BASE,ECAP_ONE_SHOT_CAPTURE_MODE,ECAP_EVENT_4);
	
	// Sets the Capture event prescaler.
	
	ECAP_setEventPrescaler(myECAP1_BASE, 0U);
	
	// Sets the Capture event polarity.
	
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_1,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_2,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_3,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP1_BASE,ECAP_EVENT_4,ECAP_EVENT_RISING_EDGE);
	
	// Configure counter reset on events
	
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_1);	
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_2);	
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_3);	
	ECAP_enableCounterResetOnEvent(myECAP1_BASE,ECAP_EVENT_4);	
	
	// Select eCAP input.
	
	ECAP_selectECAPInput(myECAP1_BASE,ECAP_INPUT_GPIO8);
	
	// Sets a phase shift value count.
	
	ECAP_setPhaseShiftCount(myECAP1_BASE,0U);
	
	// Enable counter loading with phase shift value.
	
	ECAP_enableLoadCounter(myECAP1_BASE);
	
	// Load time stamp counter.
	
	ECAP_loadCounter(myECAP1_BASE);
	
	// Configures Sync out signal mode.
	
	ECAP_setSyncOutMode(myECAP1_BASE,ECAP_SYNC_OUT_SYNCI);
	
	// Configures emulation mode.
	
	ECAP_setEmulationMode(myECAP1_BASE,ECAP_EMULATION_STOP);
	
	// Set up the source for sync-in pulse..
	
	//SysCtl_setECAPSyncInPulseSource(myECAP1_SYNC_IN_OFFSET,ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1);
	ECAP_setSyncInPulseSource(myECAP1_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1);
	
	// Starts Time stamp counter for myECAP1.
	
	ECAP_startCounter(myECAP1_BASE);
	
	// Enables time stamp capture for myECAP1.
	
	ECAP_enableTimeStampCapture(myECAP1_BASE);
	
	// Re-arms the eCAP module for myECAP1.
	
	ECAP_reArm(myECAP1_BASE);
}

// ECAP Configurations for ECAP2
void myECAP2_init()
{
    // Disables time stamp capture.
	
	ECAP_disableTimeStampCapture(myECAP2_BASE);
	
	// Stops Time stamp counter.
	
	ECAP_stopCounter(myECAP2_BASE);
	
	// Sets eCAP in Capture mode.
	
	ECAP_enableCaptureMode(myECAP2_BASE);
	
	// Sets the capture mode.
	
	ECAP_setCaptureMode(myECAP2_BASE,ECAP_ONE_SHOT_CAPTURE_MODE,ECAP_EVENT_4);
	
	// Sets the Capture event prescaler.
	
	ECAP_setEventPrescaler(myECAP2_BASE, 0U);
	
	// Sets the Capture event polarity.
	
	ECAP_setEventPolarity(myECAP2_BASE,ECAP_EVENT_1,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP2_BASE,ECAP_EVENT_2,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP2_BASE,ECAP_EVENT_3,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP2_BASE,ECAP_EVENT_4,ECAP_EVENT_RISING_EDGE);
	
	// Configure counter reset on events
	
	ECAP_enableCounterResetOnEvent(myECAP2_BASE,ECAP_EVENT_1);	
	ECAP_enableCounterResetOnEvent(myECAP2_BASE,ECAP_EVENT_2);	
	ECAP_enableCounterResetOnEvent(myECAP2_BASE,ECAP_EVENT_3);	
	ECAP_enableCounterResetOnEvent(myECAP2_BASE,ECAP_EVENT_4);	
	
	// Select eCAP input.
	
	ECAP_selectECAPInput(myECAP2_BASE,ECAP_INPUT_GPIO8);
	
	// Sets a phase shift value count.
	
	ECAP_setPhaseShiftCount(myECAP2_BASE,0U);
	
	// Enable counter loading with phase shift value.
	
	ECAP_enableLoadCounter(myECAP2_BASE);
	
	// Configures Sync out signal mode.
	
	ECAP_setSyncOutMode(myECAP2_BASE,ECAP_SYNC_OUT_SYNCI);
	
	// Configures emulation mode.
	
	ECAP_setEmulationMode(myECAP2_BASE,ECAP_EMULATION_STOP);
	
	// Set up the source for sync-in pulse..
	
	//SysCtl_setECAPSyncInPulseSource(myECAP2_SYNC_IN_OFFSET,ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1);
	ECAP_setSyncInPulseSource(myECAP1_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1);
	
	// Starts Time stamp counter for myECAP2.
	
	ECAP_startCounter(myECAP2_BASE);
	
	// Enables time stamp capture for myECAP2.
	
	ECAP_enableTimeStampCapture(myECAP2_BASE);
	
	// Re-arms the eCAP module for myECAP2.
	
	ECAP_reArm(myECAP2_BASE);
}

// ECAP Configurations for ECAP3
void myECAP3_init()
{
    // Disable ,clear all capture flags and interrupts
	
	ECAP_disableInterrupt(myECAP3_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
	ECAP_clearInterrupt(myECAP3_BASE,
		(ECAP_ISR_SOURCE_CAPTURE_EVENT_1  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_2  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_3  |
		ECAP_ISR_SOURCE_CAPTURE_EVENT_4  |
		ECAP_ISR_SOURCE_COUNTER_OVERFLOW |
		ECAP_ISR_SOURCE_COUNTER_PERIOD   |
		ECAP_ISR_SOURCE_COUNTER_COMPARE));
	
	// Disables time stamp capture.
	
	ECAP_disableTimeStampCapture(myECAP3_BASE);
	
	// Stops Time stamp counter.
	
	ECAP_stopCounter(myECAP3_BASE);
	
	// Sets eCAP in Capture mode.
	
	ECAP_enableCaptureMode(myECAP3_BASE);

	// Sets the capture mode.
	
	ECAP_setCaptureMode(myECAP3_BASE,ECAP_ONE_SHOT_CAPTURE_MODE,ECAP_EVENT_4);
	
	// Sets the Capture event prescaler.
	
	ECAP_setEventPrescaler(myECAP3_BASE, 0U);
	
	// Sets the Capture event polarity.
	
	ECAP_setEventPolarity(myECAP3_BASE,ECAP_EVENT_1,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP3_BASE,ECAP_EVENT_2,ECAP_EVENT_RISING_EDGE);
	ECAP_setEventPolarity(myECAP3_BASE,ECAP_EVENT_3,ECAP_EVENT_FALLING_EDGE);
	ECAP_setEventPolarity(myECAP3_BASE,ECAP_EVENT_4,ECAP_EVENT_RISING_EDGE);
	
	// Configure counter reset on events
	
	ECAP_enableCounterResetOnEvent(myECAP3_BASE,ECAP_EVENT_1);	
	ECAP_enableCounterResetOnEvent(myECAP3_BASE,ECAP_EVENT_2);	
	ECAP_enableCounterResetOnEvent(myECAP3_BASE,ECAP_EVENT_3);	
	ECAP_enableCounterResetOnEvent(myECAP3_BASE,ECAP_EVENT_4);	
	
	// Select eCAP input.
	
	ECAP_selectECAPInput(myECAP3_BASE,ECAP_INPUT_GPIO8);
	
	// Sets a phase shift value count.
	
	ECAP_setPhaseShiftCount(myECAP3_BASE,0U);
	
	// Enable counter loading with phase shift value.
	
	ECAP_enableLoadCounter(myECAP3_BASE);
	
	// Configures Sync out signal mode.
	
	ECAP_setSyncOutMode(myECAP3_BASE,ECAP_SYNC_OUT_SYNCI);
	
	// Configures emulation mode.
	
	ECAP_setEmulationMode(myECAP3_BASE,ECAP_EMULATION_STOP);
	
	// Set up the source for sync-in pulse..
	
	//SysCtl_setECAPSyncInPulseSource(myECAP3_SYNC_IN_OFFSET,ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1);
	ECAP_setSyncInPulseSource(myECAP1_BASE,ECAP_SYNC_IN_PULSE_SRC_SYNCIN_EXT1);
	
	// Starts Time stamp counter for myECAP3.
	
	ECAP_startCounter(myECAP3_BASE);
	
	// Enables time stamp capture for myECAP3.
	
	ECAP_enableTimeStampCapture(myECAP3_BASE);
	
	// Re-arms the eCAP module for myECAP3.
	
	ECAP_reArm(myECAP3_BASE);
	
	// Enables interrupt source for myECAP3.
	
	ECAP_enableInterrupt(myECAP3_BASE,(ECAP_ISR_SOURCE_CAPTURE_EVENT_4));
}

// GPIO Configurations
void GPIO_init()
{
	myGPIO0_init();
}

// GPIO Configurations for ECAPs
void myGPIO0_init()
{

}

// INPUTXBAR Configurations
void INPUTXBAR_init()
{
	myINPUTXBARINPUT0_init();
}

// OUTPUTXBAR Configurations for ECAP1 output
void myINPUTXBARINPUT0_init()
{
	XBAR_setInputPin(INPUTXBAR_BASE,myINPUTXBARINPUT0_INPUT, myINPUTXBARINPUT0_SOURCE);
}

// INTERRUPT Configurations
void INTERRUPT_init()
{
	Interrupt_SetPriorityGrouping(0);
  	Interrupt_SetPriority(INT_myECAP3,0,0);
	Interrupt_register(INT_myECAP3,Ecap_ex04_IrqHandler);
  	Interrupt_enable(INT_myECAP3);
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

/* None */

/**
 * \brief   "add brief description of this function" 
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif

