#include "epg_ex8_generate_two_offset_clocks_with_siggen_board.h"
#include "epg.h"
#include "xbar.h"

#define TEN_BIT         0
#define TWENTY_BIT      1
#define BIT_LENGTH_MODE TWENTY_BIT

#if BIT_LENGTH_MODE == TEN_BIT

#define CLK_GEN_PERIOD      10U-1U
#define SIG_GEN_DATA_LENGTH 10U
#define SIG_GEN_DATA0_0_10  0b0000011111U
#define SIG_GEN_DATA0_16_27 (SIG_GEN_DATA0_0_10 << 2)

#else

#define CLK_GEN_PERIOD      5U-1U
#define SIG_GEN_DATA_LENGTH 20U
#define SIG_GEN_DATA0_0_20  0b00000000001111111111U			
#define SIG_GEN_DATA1_0_20 (SIG_GEN_DATA0_0_20 << 5)		

#endif

void PinMux_init(void)
{
	// OUTPUTXBAR Pin Mux
	// OUTPUTXBAR1_PIN GPIO_2
    GPIO_setPinConfig(OUTPUTXBAR1_PIN_CONFIG);
    GPIO_setDirectionMode(OUTPUTXBAR1_GPIO, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(OUTPUTXBAR1_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(OUTPUTXBAR1_GPIO, GPIO_QUAL_SYNC);

    // OUTPUTXBAR2_PIN GPIO_3
    GPIO_setPinConfig(OUTPUTXBAR2_PIN_CONFIG);
    GPIO_setDirectionMode(OUTPUTXBAR2_GPIO, GPIO_DIR_MODE_OUT);
    GPIO_setPadConfig(OUTPUTXBAR2_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(OUTPUTXBAR2_GPIO, GPIO_QUAL_SYNC);
}


void XBAR_Init(void)
{
    //
    // Connect EPG Output to GPIO through xbar
    //
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT1,
							XBAR_OUT_MUX30_EPGOUT0);
	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT2,
							XBAR_OUT_MUX31_EPGOUT1);

	XBAR_enableOutputMux(OUTPUTXBAR_BASE, XBAR_OUTPUT1, XBAR_MUX30);
	XBAR_enableOutputMux(OUTPUTXBAR_BASE, XBAR_OUTPUT2, XBAR_MUX31);
}

void EPG_Init(void)
{
	uint32_t sigGenData = 0;

    //
    // Select Signal Generator output for EPG output of 0,1
    //
	EPG_selectEPGOutput(EPG_BASE, EPG_OUT0, EPG_OUT_SEL_SIG);
	EPG_selectEPGOutput(EPG_BASE, EPG_OUT1, EPG_OUT_SEL_SIG);


	EPG_selectSignalOutput(EPG_BASE, EPG_OUT0, EPG_SIGGEN0_DATATRANOUT0);

#if BIT_LENGTH_MODE == TEN_BIT
	EPG_selectSignalOutput(EPG_BASE, EPG_OUT1, EPG_SIGGEN0_DATATRANOUT2);	
#elif BIT_LENGTH_MODE == TWENTY_BIT
	EPG_selectSignalOutput(EPG_BASE, EPG_OUT1, EPG_SIGGEN0_DATATRANOUT4);		
#endif

    //
    // Set Clock Generator 0 period
    //
    EPG_setClkGenPeriod(EPG_BASE, EPG_CLKGEN0, CLK_GEN_PERIOD);

    //
    // Set the source of signal generator 0 to clk generator output 0
    //
    EPG_selectSigGenClkSource(EPG_BASE, EPG_SIGGEN0, EPG_CLKGEN0_CLKOUT0_GCLK);

    //
    // Set offset of clock generator output 0 to 0
    //
    EPG_setClkGenOffset(EPG_BASE, EPG_CLKGEN0, 0, 0);

    //
    // Set signal generator bit length
    //
    EPG_setDataBitLen(EPG_BASE, EPG_SIGGEN0, SIG_GEN_DATA_LENGTH);

    //
    // Set signal generator mode to right shift and repeat.
    //
    EPG_setSignalGenMode(EPG_BASE, EPG_SIGGEN0,
                         EPG_SIGGEN_MODE_ROTATE_RIGHT_REPEAT);

#if BIT_LENGTH_MODE == TEN_BIT
    EPG_setData0Word(EPG_BASE, EPG_SIGGEN0, (SIG_GEN_DATA0_0_10 | (uint32_t)SIG_GEN_DATA0_16_27 << 16));		// 01дEPGźŷ0Data0[0:31]
#else
    EPG_setData0Word(EPG_BASE, EPG_SIGGEN0, SIG_GEN_DATA0_0_20);		// 0дEPGźŷ0Data0[0:31]
    EPG_setData1Word(EPG_BASE, EPG_SIGGEN0, SIG_GEN_DATA1_0_20);		// 1дEPGźŷ0Data1[0:31]
#endif

    //
    // Enable EPG
    //
    EPG_enableGlobal(EPG_BASE);

    //
    // Enable signal generator
    //
    EPG_enableSignalGen(EPG_BASE, EPG_SIGGEN0);
}


void Board_init(void)
{
	PinMux_init();		// ųʼ
	XBAR_Init();		// XBARʼ
	EPG_Init();			// EPGʼ
}
