/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "epwm_ex02_board_bit.h"





//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
    EALLOW;

    PinMux_init();
    EPWM_init();

    EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{

    //
    // EPWM1 -> myEPWM1 Pinmux
    //
    GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

    //
    // EPWM2 -> myEPWM2 Pinmux
    //
    GPIO_setPinConfig(myEPWM2_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM2_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM2_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM2_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM2_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM2_EPWMB_GPIO, GPIO_QUAL_SYNC);

    //
    // EPWM3 -> myEPWM3 Pinmux
    //
    GPIO_setPinConfig(myEPWM3_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM3_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM3_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM3_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM3_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM3_EPWMB_GPIO, GPIO_QUAL_SYNC);


}

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM_init()
{

    //	ePWM1 Configurations
    //TB
    //	Set 1(1*1) frequency division
    EPwm1Regs.TBCTL.bit.CLKDIV 	  = 0;
    EPwm1Regs.TBCTL.bit.HSPCLKDIV = 0;
    //	Set TBPRD = 2000
    EPwm1Regs.TBPRD = 2000;
    //	Set TBCTR = 0
    EPwm1Regs.TBCTR = 0;
    //	Counting mode: UP_DOWN
    EPwm1Regs.TBCTL.bit.CTRMODE = 2;
    //	Disable phase shift load
    EPwm1Regs.TBCTL.bit.PHSEN = 0;
    //	Set TBPHS = 0
    EPwm1Regs.TBPHS.bit.TBPHS = 0;


    //CC
    //	Set CMPA = 50
    EPwm1Regs.CMPA.bit.CMPA = 50;
    //	Load the new CMPA when TBCTR = 0
    EPwm1Regs.CMPCTL.bit.LOADAMODE = 0;
    //	Set CMPB = 1950
    EPwm1Regs.CMPB.bit.CMPB = 1950;
    //	Load the new CMPB when TBCTR = 0
    EPwm1Regs.CMPCTL.bit.LOADBMODE = 0;


    //AQ
    //	TBCTR = UP_CMPA -> ePWM1A:HIGH
    EPwm1Regs.AQCTLA.bit.CAU = 2;
    //	TBCTR = DOWN_CMPA -> ePWM1A:LOW
    EPwm1Regs.AQCTLA.bit.CAD = 1;
    //	TBCTR = UP_CMPB -> ePWM1B:HIGH
    EPwm1Regs.AQCTLB.bit.CBU = 2;
    //	TBCTR = DOWN_CMPB -> ePWM1B:LOW
    EPwm1Regs.AQCTLB.bit.CBD = 1;


    //ET
    //Enable ePWM1 interrupt
    EPwm1Regs.ETSEL.bit.INTEN = 1;
    //ePWM1 interrupt Source is TBCTR = ZERO
    EPwm1Regs.ETSEL.bit.INTSEL = 1;
    //Sets the ePWM1 interrupt event counts to 3
    EPwm1Regs.ETPS.bit.INTPSSEL = 1;
    EPwm1Regs.ETINTPS.bit.INTPRD2 = 3;




    //	ePWM2 Configurations
    //TB
    //	Set 1(1*1) frequency division
    EPwm2Regs.TBCTL.bit.CLKDIV 	  = 0;
    EPwm2Regs.TBCTL.bit.HSPCLKDIV = 0;
    //	Set TBPRD = 2000
    EPwm2Regs.TBPRD = 2000;
    //	Set TBCTR = 0
    EPwm2Regs.TBCTR = 0;
    //	Counting mode: UP_DOWN
    EPwm2Regs.TBCTL.bit.CTRMODE = 2;
    //	Disable phase shift load
    EPwm2Regs.TBCTL.bit.PHSEN = 0;
    //	Set TBPHS = 0
    EPwm2Regs.TBPHS.bit.TBPHS = 0;


    //CC
    //	Set CMPA = 50
    EPwm2Regs.CMPA.bit.CMPA = 50;
    //	Load the new CMPA when TBCTR = 0
    EPwm2Regs.CMPCTL.bit.LOADAMODE = 0;
    //	Set CMPB = 50
    EPwm2Regs.CMPB.bit.CMPB = 50;
    //	Load the new CMPB when TBCTR = 0
    EPwm2Regs.CMPCTL.bit.LOADBMODE = 0;


    //AQ
    //	TBCTR = UP_CMPA -> ePWM2A:HIGH
    EPwm2Regs.AQCTLA.bit.CAU = 2;
    //	TBCTR = DOWN_CMPA -> ePWM2A:LOW
    EPwm2Regs.AQCTLA.bit.CAD = 1;
    //	TBCTR = 0 -> ePWM2B:LOW
    EPwm2Regs.AQCTLB.bit.ZRO = 1;
    //	TBCTR = TBPRD -> ePWM2B:HIGH
    EPwm2Regs.AQCTLB.bit.PRD = 2;


    //ET
    //Enable ePWM2 interrupt
    EPwm2Regs.ETSEL.bit.INTEN = 1;
    //ePWM2 interrupt Source is TBCTR = ZERO
    EPwm2Regs.ETSEL.bit.INTSEL = 1;
    //Sets the ePWM2 interrupt event counts to 3
    EPwm2Regs.ETPS.bit.INTPSSEL = 1;
    EPwm2Regs.ETINTPS.bit.INTPRD2 = 3;



    //	ePWM3 Configurations
    //TB
    //	Set 1(1*1) frequency division
    EPwm3Regs.TBCTL.bit.CLKDIV 	  = 0;
    EPwm3Regs.TBCTL.bit.HSPCLKDIV = 0;
    //	Set TBPRD = 2000
    EPwm3Regs.TBPRD = 2000;
    //	Set TBCTR = 0
    EPwm3Regs.TBCTR = 0;
    //	Counting mode: UP_DOWN
    EPwm3Regs.TBCTL.bit.CTRMODE = 2;
    //	Disable phase shift load
    EPwm3Regs.TBCTL.bit.PHSEN = 0;
    //	Set TBPHS = 0
    EPwm3Regs.TBPHS.bit.TBPHS = 0;


    //CC
    //	Set CMPA = 50
    EPwm3Regs.CMPA.bit.CMPA = 50;
    //	Load the new CMPA when TBCTR = 0
    EPwm3Regs.CMPCTL.bit.LOADAMODE = 0;
    //	Set CMPB = 1950
    EPwm3Regs.CMPB.bit.CMPB = 1950;
    //	Load the new CMPB when TBCTR = 0
    EPwm3Regs.CMPCTL.bit.LOADBMODE = 0;


    //AQ
    //	TBCTR = TBPRD -> ePWM3A:HIGH
    EPwm3Regs.AQCTLA.bit.PRD = 2;
    //	TBCTR = DOWN_CMPB -> ePWM3A:LOW
    EPwm3Regs.AQCTLA.bit.CBD = 1;
    //	TBCTR = TBPRD -> ePWM3B:LOW
    EPwm3Regs.AQCTLB.bit.PRD = 1;
    //	TBCTR = UP_CMPA -> ePWM3B:HIGH
    EPwm3Regs.AQCTLB.bit.CAU = 2;


    //ET
    //Enable ePWM3 interrupt
    EPwm3Regs.ETSEL.bit.INTEN = 1;
    //ePWM3 interrupt Source is TBCTR = ZERO
    EPwm3Regs.ETSEL.bit.INTSEL = 1;
    //Sets the ePWM3 interrupt event counts to 3
    EPwm3Regs.ETPS.bit.INTPSSEL   = 1;
    EPwm3Regs.ETINTPS.bit.INTPRD2 = 3;


}





