/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "epwm_ex03_board_bit.h"


//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
    EALLOW;

    PinMux_init();
    EPWM_init();

    EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
    //
    // PinMux for modules assigned to CPU1
    //

    //
    // EPWM1 -> myEPWM1 Pinmux
    //
    GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

    //
    // EPWM2 -> myEPWM2 Pinmux
    //
    GPIO_setPinConfig(myEPWM2_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM2_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM2_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM2_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM2_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM2_EPWMB_GPIO, GPIO_QUAL_SYNC);

    //
    // EPWM3 -> myEPWM3 Pinmux
    //
    GPIO_setPinConfig(myEPWM3_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM3_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM3_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM3_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM3_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM3_EPWMB_GPIO, GPIO_QUAL_SYNC);

    //
    // EPWM4 -> myEPWM4 Pinmux
    //
    GPIO_setPinConfig(myEPWM4_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM4_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM4_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM4_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM4_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM4_EPWMB_GPIO, GPIO_QUAL_SYNC);


}

//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM_init(){

    //	ePWM1 Configurations
    //TB
    //	Set 8(8*1) frequency division
    EPwm1Regs.TBCTL.bit.CLKDIV 	  = 3;
    EPwm1Regs.TBCTL.bit.HSPCLKDIV = 0;
    //	Set TBPRD = 2000
    EPwm1Regs.TBPRD = 2000;
    //	Set TBCTR = 0
    EPwm1Regs.TBCTR = 0;
    //	Counting mode: UP
    EPwm1Regs.TBCTL.bit.CTRMODE = 0;
    //	Disable phase shift load
    EPwm1Regs.TBCTL.bit.PHSEN = 0;
    //	Set TBPHS = 0
    EPwm1Regs.TBPHS.bit.TBPHS = 0;
    //	The synchronization signal SYNC is generated when TBCTR = 0
    EPwm1Regs.EPWMSYNCOUTEN.bit.ZEROEN = 1;

    //CC
    //	Set CMPA = 1000
    EPwm1Regs.CMPA.bit.CMPA = 1000;
    //	Load the new CMPA when TBCTR = 0
    EPwm1Regs.CMPCTL.bit.LOADAMODE = 0;
    //	Set CMPB = 500
    EPwm1Regs.CMPB.bit.CMPB = 500;
    //	Load the new CMPB when TBCTR = 0
    EPwm1Regs.CMPCTL.bit.LOADBMODE = 0;


    //AQ
    //	TBCTR = 0 -> ePWM1A:HIGH
    EPwm1Regs.AQCTLA.bit.ZRO = 2;
    //	TBCTR = UP_CMPA -> ePWM1A:LOW
    EPwm1Regs.AQCTLA.bit.CAU = 1;
    //	TBCTR = 0 -> ePWM1B:HIGH
    EPwm1Regs.AQCTLB.bit.ZRO = 2;
    //	TBCTR = UP_CMPB -> ePWM1B:LOW
    EPwm1Regs.AQCTLB.bit.CBU = 1;



    //ePWN2 Configurations
    //TB
    //	Set 8(8*1) frequency division
    EPwm2Regs.TBCTL.bit.CLKDIV 	  = 3;
    EPwm2Regs.TBCTL.bit.HSPCLKDIV = 0;
    //	Load a new TBPRD when SYNC is received
    EPwm2Regs.TBCTL2.bit.PRDLDSYNC = 2;
    //	Set TBPRD = 2000
    EPwm2Regs.TBPRD = 2000;
    //	Set TBCTR = 0
    EPwm2Regs.TBCTR = 0;
    //	Counting mode: UP
    EPwm2Regs.TBCTL.bit.CTRMODE = 0;
    //	Enable phase shift load
    EPwm2Regs.TBCTL.bit.PHSEN = 1;
    //	Set TBPHS = 300
    EPwm2Regs.TBPHS.bit.TBPHS = 300;


    //CC
    //	Set CMPA = 1000
    EPwm2Regs.CMPA.bit.CMPA = 1000;
    //	Load the new CMPA when TBCTR = 0
    EPwm2Regs.CMPCTL.bit.LOADAMODE = 0;
    //	Set CMPB = 500
    EPwm2Regs.CMPB.bit.CMPB = 500;
    //	Load the new CMPB when TBCTR = 0
    EPwm2Regs.CMPCTL.bit.LOADBMODE = 0;


    //AQ
    //	TBCTR = 0 -> ePWM2A:HIGH
    EPwm2Regs.AQCTLA.bit.ZRO = 2;
    //	TBCTR = UP_CMPA -> ePWM2A:LOW
    EPwm2Regs.AQCTLA.bit.CAU = 1;
    //	TBCTR = 0 -> ePWM2B:HIGH
    EPwm2Regs.AQCTLB.bit.ZRO = 2;
    //	TBCTR = UP_CMPB -> ePWM2B:LOW
    EPwm2Regs.AQCTLB.bit.CBU = 1;


    //ePWM3 Configurations
    //TB
    //	Set 8(8*1) frequency division
    EPwm3Regs.TBCTL.bit.CLKDIV 	  = 3;
    EPwm3Regs.TBCTL.bit.HSPCLKDIV = 0;
    //	Load a new TBPRD when SYNC is received
    EPwm3Regs.TBCTL2.bit.PRDLDSYNC = 2;
    //	Set TBPRD = 2000
    EPwm3Regs.TBPRD = 2000;
    //	Set TBCTR = 0
    EPwm3Regs.TBCTR = 0;
    //	Counting mode: UP
    EPwm3Regs.TBCTL.bit.CTRMODE = 0;
    //	Enable phase shift load
    EPwm3Regs.TBCTL.bit.PHSEN = 1;
    //	Set TBPHS = 600
    EPwm3Regs.TBPHS.bit.TBPHS = 600;


    //CC
    //	Set CMPA = 1000
    EPwm3Regs.CMPA.bit.CMPA = 1000;
    //	Load the new CMPA when TBCTR = 0
    EPwm3Regs.CMPCTL.bit.LOADAMODE = 0;
    //	Set CMPB = 500
    EPwm3Regs.CMPB.bit.CMPB = 500;
    //	Load the new CMPB when TBCTR = 0
    EPwm3Regs.CMPCTL.bit.LOADBMODE = 0;


    //AQ
    //	TBCTR = 0 -> ePWM3A:HIGH
    EPwm3Regs.AQCTLA.bit.ZRO = 2;
    //	TBCTR = UP_CMPA -> ePWM3A:LOW
    EPwm3Regs.AQCTLA.bit.CAU = 1;
    //	TBCTR = 0 -> ePWM3B:HIGH
    EPwm3Regs.AQCTLB.bit.ZRO = 2;
    //	TBCTR = UP_CMPB -> ePWM3B:LOW
    EPwm3Regs.AQCTLB.bit.CBU = 1;



    //ePWM4 Configurations
    //TB
    //	Set 8(8*1) frequency division
    EPwm4Regs.TBCTL.bit.CLKDIV 	  = 3;
    EPwm4Regs.TBCTL.bit.HSPCLKDIV = 0;
    //	Load a new TBPRD when SYNC is received
    EPwm4Regs.TBCTL2.bit.PRDLDSYNC = 2;
    //	Set TBPRD = 2000
    EPwm4Regs.TBPRD = 2000;
    //	Set TBCTR = 0
    EPwm4Regs.TBCTR = 0;
    //	Set TBCTR = 0
    EPwm4Regs.TBCTL.bit.CTRMODE = 0;
    //	Enable phase shift load
    EPwm4Regs.TBCTL.bit.PHSEN = 1;
    //	Set TBPHS = 900
    EPwm4Regs.TBPHS.bit.TBPHS = 900;


    //CC
    //	Set CMPA = 1000
    EPwm4Regs.CMPA.bit.CMPA = 1000;
    //	Load the new CMPA when TBCTR = 0
    EPwm4Regs.CMPCTL.bit.LOADAMODE = 0;
    //	Set CMPB = 500
    EPwm4Regs.CMPB.bit.CMPB = 500;
    //	Load the new CMPB when TBCTR = 0
    EPwm4Regs.CMPCTL.bit.LOADBMODE = 0;


    //AQ
    //	TBCTR = 0 -> ePWM4A:HIGH
    EPwm4Regs.AQCTLA.bit.ZRO = 2;
    //	TBCTR = UP_CMPA -> ePWM4A:LOW
    EPwm4Regs.AQCTLA.bit.CAU = 1;
    //	TBCTR = 0 -> ePWM4B:HIGH
    EPwm4Regs.AQCTLB.bit.ZRO = 2;
    //	TBCTR = UP_CMPB -> ePWM4B:LOW
    EPwm4Regs.AQCTLB.bit.CBU = 1;


}



#ifdef __cplusplus
}
#endif

