//#############################################################################
//
// FILE:   main.c
//
// TITLE:  ePWM Using DMA.
//
//! \addtogroup driver_example_list
//! <h1>ePWM DMA</h1>
//!
//! This example configures ePWM1 and DMA as follows:
//!  - ePWM1 is set up to generate PWM waveforms
//!  - DMA5 is set up to update the CMPAHR, CMPA, CMPBHR and CMPB every period
//!    with the next value in the configuration array. This allows the user to
//!    create a DMA enabled fifo for all the CMPx and CMPxHR registers to
//!    generate unconventional PWM waveforms.
//!  - DMA6 is set up to update the TBPHSHR, TBPHS, TBPRDHR and TBPRD every
//!    period with the next value in the configuration array.
//!  - Other registers such as AQCTL can be controlled through the DMA as well
//!    by following the same procedure. (Not used in this example)
//!
//! \b External \b Connections \n
//! -
//! -
//!
//! \b Watch \b Variables \n
//! - None.
//
//
//#############################################################################
/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */




/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "epwm_ex09_board.h"


void main(void)
{
    //
    // Initialize device clock and peripherals
    //
    Device_init();

    //
    // disable sync and clock to PWM
    //
    SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

    //
    // Configure EPWM
    //
    Board_init();


    //
    // Enable sync and clock to PWM
    //
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);


    //
    // Enable Global Interrupt (INTM) and realtime interrupt (DBGM)
    //
    EINT;
    ERTM;

    EALLOW;

    DELAY_US(5000000);

#if ( IS_GS32F00xx(0x12) || IS_GS32F00xx(0x30) )

    DMA_startChannel(myDMA_CH5_BASE);
    DMA_startChannel(myDMA_CH6_BASE);

#elif ( IS_GS32F3xx(0x22) )

    XDMA_startChannel(myDMA_CH5_BASE);
    XDMA_startChannel(myDMA_CH6_BASE);
#endif
    //
    // IDLE loop. Just sit and loop forever (optional):
    //

    for(;;)
    {

    }
}

#if ( IS_GS32F00xx(0x12) || IS_GS32F00xx(0x30) )

//
// DMA Channel 5 ISR
//
__interrupt void dmaCh5ISR(void)
{

	DMA_clearInterrupt(myDMA_CH5_BASE,DMA_INT_BLOCK);

    __DSB();
    return;
}

//
// DMA Channel 6 ISR
//
__interrupt void dmaCh6ISR(void)
{
	DMA_clearInterrupt(myDMA_CH6_BASE,DMA_INT_BLOCK);

    __DSB();
    return;
}

#elif ( IS_GS32F3xx(0x22) )

//
// DMA Channel 5 ISR
//
__interrupt void dmaCh5ISR(void)
{

	XDMA_clearInterrupt(myDMA_CH5_BASE,XDMA_INT_BLOCK);

    __DSB();
    return;
}

//
// DMA Channel 6 ISR
//
__interrupt void dmaCh6ISR(void)
{
	XDMA_clearInterrupt(myDMA_CH6_BASE,XDMA_INT_BLOCK);

    __DSB();
    return;
}



#endif

