/*
 * 	File: ePWM_ex16_Phase_Counter_Extend
 *
 *	ʾ֮ͬܵµƽ״̬Ԥڵ
 *	ǿƿЧ
 *
 *	ePWM1\2Ϊһ  Upģʽʾ
 *	ʾePWM2A ->IO2ePWM2B->IO3۲첨
 *	ePWM2AǿƿơePWM2BӲȻ
 *
 *	ePWM3\4Ϊһ  Downģʽʾ
 *	ʾePWM4A ->IO6ePWM4B->IO7۲첨
 *	ePWM4AǿƿơePWM4BӲȻ
 *
 *
 *	ePWM5\6Ϊһ  Up-Downģʽʾ
 *	ʾePWM6A ->IO10ePWM6B->IO11۲첨
 *	ePWM6AǿƿơePWM6BӲȻ
 *
*/

/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "epwm_ex16_board.h"

//ePWM12Ķʱֵ
uint16_t Interrupt_Cnt1  = 0;
//ePWM34Ķʱֵ
uint16_t Interrupt_Cnt2  = 0;
//ePWM56Ķʱֵ
uint16_t Interrupt_Cnt3  = 0;

//ePWM12Ļ־λ
uint8_t  TBPHS_Flag1     = 1;
//ePWM34Ļ־λ
uint8_t  TBPHS_Flag2     = 1;
//ePWM56Ļ־λ
uint8_t  TBPHS_Flag3     = 1;

int main(void)
{
	 //
	// Initialize device clock and peripherals
	//
	Device_init();


	//
	// Disable sync(Freeze clock to PWM as well)
	//
	SysCtl_disablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);


	//
	// For this case just init GPIO pins for ePWM1, ePWM2, ePWM3
	//
	Board_init();


	//
	// Enable sync and clock to PWM
	//
	SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);

	CPUTTimer1_init();

	//
	// Enable global Interrupts and higher priority real-time debug events:
	//
	EINT;  // Enable Global interrupt INTM
	ERTM;  // Enable Global realtime interrupt DBGM

	//
	// IDLE loop. Just sit and loop forever (optional):
	//
	for(;;)
	{
		asm ("  NOP");
	}

	return 0;

}


__interrupt void TIMER1_IRQHandler(void)
{
    if( Interrupt_Cnt1 >= 5 ) //5ms
    {

    	//ePWM2 Up
    	if(TBPHS_Flag1)
    	{
     	    EPWM_setPhaseShift(EPWM2_BASE, 0);
     	    TBPHS_Flag1 = 0;
            Interrupt_Cnt1 = 0;

    	}else
    	{

            if( EPWM_getTimeBaseCounterValue(EPWM2_BASE) <= 5000 )
                {
        	  		EPWM_setPhaseShift(EPWM2_BASE, 15000);
        	  		TBPHS_Flag1 = 1;
                    Interrupt_Cnt1 = 0;
                }

    	}


    }else
    {
        Interrupt_Cnt1++;
    }


    if( Interrupt_Cnt2 >= 5 ) //5ms
    {

    	//ePWM4 Down
    	if(TBPHS_Flag2)
    	{
     	    EPWM_setPhaseShift(EPWM4_BASE, 0);
     	    TBPHS_Flag2 = 0;
            Interrupt_Cnt2 = 0;
    	}else
    	{
            if( EPWM_getTimeBaseCounterValue(EPWM4_BASE) >= 15000 )
            {
    	  		EPWM_setPhaseShift(EPWM4_BASE, 5000);
    	  		TBPHS_Flag2 = 1;
    	  		Interrupt_Cnt2 = 0;
            }


    	}




    }else
    {
        Interrupt_Cnt2++;
    }


    if( Interrupt_Cnt3 >= 5 ) //5ms
    {

    	//ePWM6 Up Down
    	if(TBPHS_Flag2)
    	{
     	    EPWM_setPhaseShift(EPWM6_BASE, 0);
     	    TBPHS_Flag3 = 0;
            Interrupt_Cnt3 = 0;
    	}else
    	{

            if( EPWM_getTimeBaseCounterValue(EPWM6_BASE) <= 3000 )
              {

          	  		EPWM_setPhaseShift(EPWM6_BASE, 10000);
          	  	    TBPHS_Flag3 = 1;
          	  		Interrupt_Cnt3 = 0;
              }

    	}


    }else
    {
        Interrupt_Cnt3++;
    }



	CPUTimer_clearOverflowFlag(myCPUTIMER1_BASE);

}
