/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */



#include "epwm_ex16_board.h"





//*****************************************************************************
//
// Board Configurations
// Initializes the rest of the modules.
// Call this function in your application if you wish to do all module
// initialization.
// If you wish to not use some of the initializations, instead of the
// Board_init use the individual Module_inits
//
//*****************************************************************************
void Board_init()
{
    EALLOW;

    PinMux_init();
    EPWM1_2_init();
    EPWM3_4_init();
    EPWM5_6_init();

    EDIS;
}

//*****************************************************************************
//
// PINMUX Configurations
//
//*****************************************************************************
void PinMux_init()
{
    //
    // PinMux for modules assigned to CPU1
    //

    //
    // EPWM1 -> myEPWM1 Pinmux
    //
    GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);

    //
    // EPWM2 -> myEPWM2 Pinmux
    //
    GPIO_setPinConfig(myEPWM2_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM2_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM2_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM2_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM2_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM2_EPWMB_GPIO, GPIO_QUAL_SYNC);

    //
    // EPWM3 -> myEPWM3 Pinmux
    //
    GPIO_setPinConfig(myEPWM3_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM3_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM3_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM3_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM3_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM3_EPWMB_GPIO, GPIO_QUAL_SYNC);

    //
    // EPWM4 -> myEPWM4 Pinmux
    //
    GPIO_setPinConfig(myEPWM4_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM4_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM4_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM4_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM4_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM4_EPWMB_GPIO, GPIO_QUAL_SYNC);


    //
    // EPWM5 -> myEPWM5 Pinmux
    //
    GPIO_setPinConfig(myEPWM5_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM5_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM5_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM5_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM5_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM5_EPWMB_GPIO, GPIO_QUAL_SYNC);


    //
    // EPWM6 -> myEPWM6 Pinmux
    //
    GPIO_setPinConfig(myEPWM6_EPWMA_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM6_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM6_EPWMA_GPIO, GPIO_QUAL_SYNC);

    GPIO_setPinConfig(myEPWM6_EPWMB_PIN_CONFIG);
    GPIO_setPadConfig(myEPWM6_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(myEPWM6_EPWMB_GPIO, GPIO_QUAL_SYNC);

}


//*****************************************************************************
//
// CPUTimer Configurations
//
//*****************************************************************************
void CPUTTimer1_init(void)
{
	/* Initialize CPUTimer with interrupt enable */
#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)    
    CPUTimer_setPreScaler(myCPUTIMER1_BASE, CPUTIMER_CLOCK_PRESCALER_1);
#else
    CPUTimer_setPreScaler(myCPUTIMER1_BASE, 1);
#endif
	CPUTimer_setTimerMode(myCPUTIMER1_BASE,CPUTIMER_TIMERMODE_PERIODIC);
	CPUTimer_setEmulationMode(myCPUTIMER1_BASE,CPUTIMER_EMULATIONMODE_RUNFREE);
	CPUTimer_init(myCPUTIMER1_BASE,60000);

	Interrupt_register(INT_TIMER1, TIMER1_IRQHandler);
	Interrupt_enable(INT_TIMER1);

}


//*****************************************************************************
//
// EPWM Configurations
//
//*****************************************************************************
void EPWM1_2_init()
{
	//ePWM1
	//TB
	//	ePWMʱ1Ƶ
	EPWM_setClockPrescaler(myEPWM1_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);
	//	ģʽϼ
    EPWM_setTimeBaseCounterMode(myEPWM1_BASE, EPWM_COUNTER_MODE_UP);
	//	ֵTBPRD = 20000
    EPWM_setTimeBasePeriod(myEPWM1_BASE, 20000);
    //	ֵTBCTR = 0
    EPWM_setTimeBaseCounter(myEPWM1_BASE, 0);
    //	ฺʧ
    EPWM_disablePhaseShiftLoad(myEPWM1_BASE);
    //	ֵTBPHS = 0
    EPWM_setPhaseShift(myEPWM1_BASE, 0);
    //	ePWM1ڼֵ TBCTR = 0 ͬź
    EPWM_enableSyncOutPulseSource(myEPWM1_BASE, EPWM_SYNC_OUT_PULSE_ON_CNTR_ZERO);


    //CC
    //	ñȽAֵCMPA = 10000
    EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, 10000);
    //	ñȽAļģʽTBCTR = 0 ʱµCMPA
    EPWM_setCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
    //	ñȽBֵCMPB = 10000
    EPWM_setCounterCompareValue(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, 10000);
    //	ñȽBļģʽTBCTR = 0 ʱµCMPB
    EPWM_setCounterCompareShadowLoadMode(myEPWM1_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);



    //AQ
    //	Aͨ¼: TBCTR = 0 -> ePWM1AHIGH
    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH,  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    //	Aͨ¼: TBCTR = UP_CMPA -> ePWM1ALOW
    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼ӰӼģʽ -> Aͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM1_BASE,EPWM_ACTION_QUALIFIER_A);
    //	Bͨ¼: TBCTR = 0 -> ePWM1BHIGH
    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH,  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    //	Bͨ¼: TBCTR = UP_CMPB -> ePWM1BLOW
    EPWM_setActionQualifierAction(myEPWM1_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    //	Bͨ¼ӰӼģʽ -> Bͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM1_BASE,EPWM_ACTION_QUALIFIER_B);

	//ePWM2
	//TB
	//	ePWMʱ1Ƶ
	EPWM_setClockPrescaler(myEPWM2_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);  //EPWMʱΪ1Ƶ
	//	ģʽϼ
    EPWM_setTimeBaseCounterMode(myEPWM2_BASE, EPWM_COUNTER_MODE_UP);
	//	ֵTBPRD = 20000
    EPWM_setTimeBasePeriod(myEPWM2_BASE, 20000);
    //	ֵTBCTR = 0
    EPWM_setTimeBaseCounter(myEPWM2_BASE, 0);
    //	ฺʹ
    EPWM_enablePhaseShiftLoad(myEPWM2_BASE);
    //	ֵTBPHS = 0
    EPWM_setPhaseShift(myEPWM2_BASE, 0);
    //	ePWM1ͬźΪePWM2ͬźԴ
    EPWM_setSyncInPulseSource(myEPWM2_BASE, EPWM_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM1);
	//	AͨͬźŴʱƽ״̬ǿ
	EPWM_setControlSyncEventOutputMode_Extend(myEPWM2_BASE,EPWM_Event_OutputChannel_A,EPWM_Event_OutputMode_Software);
	//	Aͨѡǿ͵ƽ
	EPWM_setControlSyncEventOutputPolarity_Extend(myEPWM2_BASE,EPWM_Event_OutputChannel_A,EPWM_Event_OutputPolarity_LOW);
	//	ƽ״̬ģʽTBCTR = 0Aͨµĵƽ״̬
	EPWM_setControlSyncEventLoadMode_Extend(myEPWM2_BASE,EPWM_Event_OutputChannel_A,EPWM_Event_LoadMode_ZERO);

	//	עΪ˿ԱûɸԼѡ
	//	BͨͬźŴʱƽ״̬ǿ
	//EPWM_setExtendControlSyncEventOutputMode(myEPWM2_BASE,EPWM_Event_OutputChannel_B,EPWM_Event_OutputMode_Software);
	//	Bͨѡǿ͵ƽ
	//EPWM_setExtendControlSyncEventOutputPolarity(myEPWM2_BASE,EPWM_Event_OutputChannel_B,EPWM_Event_OutputPolarity_HIGH);
	//	ƽ״̬ģʽTBCTR = 0Bͨµĵƽ״̬
	//EPWM_setExtendControlSyncEventLoadMode(myEPWM2_BASE,EPWM_Event_OutputChannel_B,EPWM_Event_LoadMode_ZERO);


	//CC
    //	ñȽAֵCMPA = 10000
    EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_A, 10000);
    //	ñȽAļģʽTBCTR = 0 ʱµCMPA
    EPWM_setCounterCompareShadowLoadMode(myEPWM2_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO);
    //	ñȽBֵCMPB = 10000
    EPWM_setCounterCompareValue(myEPWM2_BASE, EPWM_COUNTER_COMPARE_B, 10000);
    //	ñȽBļģʽTBCTR = 0 ʱµCMPB
    EPWM_setCounterCompareShadowLoadMode(myEPWM2_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO);


    //AQ
    //	Aͨ¼: TBCTR = 0 -> ePWM2AHIGH
    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    //	Aͨ¼: TBCTR = UP_CMPA -> ePWM2ALOW
    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼ӰӼģʽ -> Aͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM2_BASE,EPWM_ACTION_QUALIFIER_A);
    //	Bͨ¼: TBCTR = 0 -> ePWM2BHIGH
    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    //	Bͨ¼: TBCTR = UP_CMPB -> ePWM2BLOW
    EPWM_setActionQualifierAction(myEPWM2_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    //	Bͨ¼ӰӼģʽ -> Bͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM2_BASE,EPWM_ACTION_QUALIFIER_B);

}


void EPWM3_4_init()
{

	//ePWM3
	//TB
	//	ePWMʱ1Ƶ
	EPWM_setClockPrescaler(myEPWM3_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);  //EPWMʱΪ1Ƶ
	//	ģʽ¼
    EPWM_setTimeBaseCounterMode(myEPWM3_BASE, EPWM_COUNTER_MODE_DOWN);
	//	ֵTBPRD = 20000
    EPWM_setTimeBasePeriod(myEPWM3_BASE, 20000);
    //	ֵTBCTR = 0
    EPWM_setTimeBaseCounter(myEPWM3_BASE, 0);
    //	ฺʧ
    EPWM_disablePhaseShiftLoad(myEPWM3_BASE);
    //	ֵTBPHS = 0
    EPWM_setPhaseShift(myEPWM3_BASE, 0);
    //	ePWM3ڼֵ TBCTR = 0 ͬź
    EPWM_enableSyncOutPulseSource(myEPWM3_BASE, EPWM_SYNC_OUT_PULSE_ON_CNTR_ZERO);


    //CC
    //	ñȽAֵCMPA = 10000
    EPWM_setCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_A, 10000);
    //	ñȽAļģʽTBCTR = 0 ʱµCMPA
    EPWM_setCounterCompareShadowLoadMode(myEPWM3_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_PERIOD);
    //	ñȽBֵCMPB = 10000
    EPWM_setCounterCompareValue(myEPWM3_BASE, EPWM_COUNTER_COMPARE_B, 10000);
    //	ñȽBļģʽTBCTR = 0 ʱµCMPB
    EPWM_setCounterCompareShadowLoadMode(myEPWM3_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_PERIOD);



    //AQ
    //	Aͨ¼: TBCTR = TBPRD -> ePWM3AHIGH
    EPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
    //	Aͨ¼: TBCTR = Down_CMPA -> ePWM3ALOW
    EPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
    //	Aͨ¼ӰӼģʽ -> Aͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM3_BASE,EPWM_ACTION_QUALIFIER_A);
    //	Bͨ¼: TBCTR = TBPRD -> ePWM3BHIGH
    EPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
    //	Bͨ¼: TBCTR = Down_CMPB -> ePWM3BLOW
    EPWM_setActionQualifierAction(myEPWM3_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
    //	Bͨ¼ӰӼģʽ -> Bͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM3_BASE,EPWM_ACTION_QUALIFIER_B);




	//ePWM4
	//TB
	//	ePWMʱ1Ƶ
	EPWM_setClockPrescaler(myEPWM4_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);  //EPWMʱΪ1Ƶ
	//	ģʽ¼
    EPWM_setTimeBaseCounterMode(myEPWM4_BASE, EPWM_COUNTER_MODE_DOWN);
	//	ֵTBPRD = 20000
    EPWM_setTimeBasePeriod(myEPWM4_BASE, 20000);
    //	ֵTBCTR = 0
    EPWM_setTimeBaseCounter(myEPWM4_BASE, 0);
    //	ฺʹ
    EPWM_enablePhaseShiftLoad(myEPWM4_BASE);
    //	ֵTBPHS = 0
    EPWM_setPhaseShift(myEPWM4_BASE, 0);
    //	ePWM3ͬźΪePWM4ͬźԴ
    EPWM_setSyncInPulseSource(myEPWM4_BASE, EPWM_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM3);
	//	AͨͬźŴʱƽ״̬ǿ
	EPWM_setControlSyncEventOutputMode_Extend(myEPWM4_BASE,EPWM_Event_OutputChannel_A,EPWM_Event_OutputMode_Software);
	//	Aͨѡǿ͵ƽ
	EPWM_setControlSyncEventOutputPolarity_Extend(myEPWM4_BASE,EPWM_Event_OutputChannel_A,EPWM_Event_OutputPolarity_LOW);
	//	ƽ״̬ģʽTBCTR = 0Aͨµĵƽ״̬
	EPWM_setControlSyncEventLoadMode_Extend(myEPWM4_BASE,EPWM_Event_OutputChannel_A,EPWM_Event_LoadMode_ZERO);

	//	עΪ˿ԱûɸԼѡ
	//	BͨͬźŴʱƽ״̬ǿ
	//EPWM_setExtendControlSyncEventOutputMode(myEPWM4_BASE,EPWM_Event_OutputChannel_B,EPWM_Event_OutputMode_Software);
	//	Bͨѡǿ͵ƽ
	//EPWM_setExtendControlSyncEventOutputPolarity(myEPWM4_BASE,EPWM_Event_OutputChannel_B,EPWM_Event_OutputPolarity_HIGH);
	//	ƽ״̬ģʽTBCTR = 0Bͨµĵƽ״̬
	//EPWM_setExtendControlSyncEventLoadMode(myEPWM4_BASE,EPWM_Event_OutputChannel_B,EPWM_Event_LoadMode_ZERO);


	//CC
    //	ñȽAֵCMPA = 10000
    EPWM_setCounterCompareValue(myEPWM4_BASE, EPWM_COUNTER_COMPARE_A, 10000);
    //	ñȽAļģʽTBCTR = 0 ʱµCMPA
    EPWM_setCounterCompareShadowLoadMode(myEPWM4_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_PERIOD);
    //	ñȽBֵCMPB = 10000
    EPWM_setCounterCompareValue(myEPWM4_BASE, EPWM_COUNTER_COMPARE_B, 10000);
    //	ñȽBļģʽTBCTR = 0 ʱµCMPB
    EPWM_setCounterCompareShadowLoadMode(myEPWM4_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_PERIOD);


    //AQ
    //	Aͨ¼: TBCTR = TBPRD -> ePWM4AHIGH
    EPWM_setActionQualifierAction(myEPWM4_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
    //	Aͨ¼: TBCTR = Down_CMPA -> ePWM3ALOW
    EPWM_setActionQualifierAction(myEPWM4_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
    //	Aͨ¼ӰӼģʽ -> Aͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM4_BASE,EPWM_ACTION_QUALIFIER_A);
    //	Bͨ¼: TBCTR = TBPRD -> ePWM3BHIGH
    EPWM_setActionQualifierAction(myEPWM4_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH, EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
    //	Bͨ¼: TBCTR = Down_CMPB -> ePWM3BLOW
    EPWM_setActionQualifierAction(myEPWM4_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
    //	Bͨ¼ӰӼģʽ -> Bͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM4_BASE,EPWM_ACTION_QUALIFIER_B);

}

void EPWM5_6_init()
{

	//ePWM5
	//TB
	//	ePWMʱ1Ƶ
	EPWM_setClockPrescaler(myEPWM5_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);  //EPWMʱΪ1Ƶ
	//	ģʽ¼
    EPWM_setTimeBaseCounterMode(myEPWM5_BASE, EPWM_COUNTER_MODE_UP_DOWN);
	//	ֵTBPRD = 10000
    EPWM_setTimeBasePeriod(myEPWM5_BASE, 10000);
    //	ֵTBCTR = 0
    EPWM_setTimeBaseCounter(myEPWM5_BASE, 0);
    //	ฺʧ
    EPWM_disablePhaseShiftLoad(myEPWM5_BASE);
    //	ֵTBPHS = 0
    EPWM_setPhaseShift(myEPWM5_BASE, 0);
    //	ePWM5ڼֵ TBCTR = 0 ͬź
    EPWM_enableSyncOutPulseSource(myEPWM5_BASE, EPWM_SYNC_OUT_PULSE_ON_CNTR_ZERO);


    //CC
    //	ñȽAֵCMPA = 5000
    EPWM_setCounterCompareValue(myEPWM5_BASE, EPWM_COUNTER_COMPARE_A, 5000);
    //	ñȽAļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPA
    EPWM_setCounterCompareShadowLoadMode(myEPWM5_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
    //	ñȽBֵCMPB = 5000
    EPWM_setCounterCompareValue(myEPWM5_BASE, EPWM_COUNTER_COMPARE_B, 5000);
    //	ñȽBļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPB
    EPWM_setCounterCompareShadowLoadMode(myEPWM5_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);



    //AQ
    //	Aͨ¼: TBCTR = UP_CMPA -> ePWM5AHIGH
    EPWM_setActionQualifierAction(myEPWM5_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH,  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼: TBCTR = Down_CMPA -> ePWM5ALOW
    EPWM_setActionQualifierAction(myEPWM5_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
    //	Aͨ¼ӰӼģʽ -> Aͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM5_BASE,EPWM_ACTION_QUALIFIER_A);
    //	Bͨ¼: TBCTR = UP_CMPB -> ePWM5BHIGH
    EPWM_setActionQualifierAction(myEPWM5_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH,  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    //	Bͨ¼: TBCTR = Down_CMPB -> ePWM5BLOW
    EPWM_setActionQualifierAction(myEPWM5_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
    //	Bͨ¼ӰӼģʽ -> Bͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM5_BASE,EPWM_ACTION_QUALIFIER_B);



	//ePWM6
	//TB
	//	ePWMʱ1Ƶ
	EPWM_setClockPrescaler(myEPWM6_BASE, EPWM_CLOCK_DIVIDER_1, EPWM_HSCLOCK_DIVIDER_1);  //EPWMʱΪ1Ƶ
	//	ģʽ¼
    EPWM_setTimeBaseCounterMode(myEPWM6_BASE, EPWM_COUNTER_MODE_UP_DOWN);
	//	ֵTBPRD = 10000
    EPWM_setTimeBasePeriod(myEPWM6_BASE, 10000);
    //	ֵTBCTR = 0
    EPWM_setTimeBaseCounter(myEPWM6_BASE, 0);
    //	ฺʹ
    EPWM_enablePhaseShiftLoad(myEPWM6_BASE);
    //	ֵTBPHS = 0
    EPWM_setPhaseShift(myEPWM6_BASE, 0);
    //	ePWM5ͬźΪePWM6ͬźԴ
    EPWM_setSyncInPulseSource(myEPWM6_BASE, EPWM_SYNC_IN_PULSE_SRC_SYNCOUT_EPWM5);
	//	AͨͬźŴʱƽ״̬ǿ
	EPWM_setControlSyncEventOutputMode_Extend(myEPWM6_BASE,EPWM_Event_OutputChannel_A,EPWM_Event_OutputMode_Software);
	//	Aͨѡǿ͵ƽ
	EPWM_setControlSyncEventOutputPolarity_Extend(myEPWM6_BASE,EPWM_Event_OutputChannel_A,EPWM_Event_OutputPolarity_LOW);
	//	ƽ״̬ģʽTBCTR = 0Aͨµĵƽ״̬
	EPWM_setControlSyncEventLoadMode_Extend(myEPWM6_BASE,EPWM_Event_OutputChannel_A,EPWM_Event_LoadMode_ZERO_PERIOD);

	//	עΪ˿ԱûɸԼѡ
	//	BͨͬźŴʱƽ״̬ǿ
	//	EPWM_setExtendControlSyncEventOutputMode(myEPWM6_BASE,EPWM_Event_OutputChannel_B,EPWM_Event_OutputMode_Software);
	//	Bͨѡǿ͵ƽ
	//	EPWM_setExtendControlSyncEventOutputPolarity(myEPWM6_BASE,EPWM_Event_OutputChannel_B,EPWM_Event_OutputPolarity_HIGH);
	//	ƽ״̬ģʽTBCTR = 0Bͨµĵƽ״̬
	//	EPWM_setExtendControlSyncEventLoadMode(myEPWM6_BASE,EPWM_Event_OutputChannel_B,EPWM_Event_LoadMode_ZERO_PERIOD);


	//CC
    //	ñȽAֵCMPA = 5000
    EPWM_setCounterCompareValue(myEPWM6_BASE, EPWM_COUNTER_COMPARE_A, 5000);
    //	ñȽAļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPA
    EPWM_setCounterCompareShadowLoadMode(myEPWM6_BASE, EPWM_COUNTER_COMPARE_A, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);
    //	ñȽBֵCMPB = 5000
    EPWM_setCounterCompareValue(myEPWM6_BASE, EPWM_COUNTER_COMPARE_B, 5000);
    //	ñȽBļģʽTBCTR = 0  TBCTR = TBPRD ʱµCMPB
    EPWM_setCounterCompareShadowLoadMode(myEPWM6_BASE, EPWM_COUNTER_COMPARE_B, EPWM_COMP_LOAD_ON_CNTR_ZERO_PERIOD);



    //AQ
    //	Aͨ¼: TBCTR = UP_CMPA -> ePWM6AHIGH
    EPWM_setActionQualifierAction(myEPWM6_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_HIGH,  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    //	Aͨ¼: TBCTR = Down_CMPA -> ePWM6ALOW
    EPWM_setActionQualifierAction(myEPWM6_BASE, EPWM_AQ_OUTPUT_A, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
    //	Aͨ¼ӰӼģʽ -> Aͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM6_BASE,EPWM_ACTION_QUALIFIER_A);
    //	Bͨ¼: TBCTR = UP_CMPB -> ePWM6BHIGH
    EPWM_setActionQualifierAction(myEPWM6_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_HIGH,  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    //	Bͨ¼: TBCTR = Down_CMPB -> ePWM6BLOW
    EPWM_setActionQualifierAction(myEPWM6_BASE, EPWM_AQ_OUTPUT_B, EPWM_AQ_OUTPUT_LOW, EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);
    //	Bͨ¼ӰӼģʽ -> Bͨ¼Ϊ
    EPWM_disableActionQualifierShadowLoadMode(myEPWM6_BASE,EPWM_ACTION_QUALIFIER_B);
}

