// See LICENSE for license details.
#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"

#define myEQEP0_BASE EQEP1_BASE
#define sum 36
#define myEPWM1base EPWM1_BASE
#define PRINTF_SW 1 //0 or 1


uint32_t Count1 = 0;
uint32_t interruptCount1 = 0;
uint32_t interruptCount2 = 0;
volatile uint32_t EQEP_CASE=1;

//Temprory

uint32_t CNT=0;
uint32_t QPOSILAT=0;
uint32_t DIR=0;
uint32_t CNT_TEMP[2]={0,0};
int32_t CNT_DV[2];
volatile uint32_t EQEP_OK=0;
uint32_t i=0;
uint32_t EQEP_F=0;
uint32_t my_GFLG=0;
uint32_t my_FIMF=0;
uint32_t my_CNT=0;



uint64_t TEMP1=0;
uint64_t TEMP2=0;
int32_t CNT_DV_1=0;
void eqep_test4_GPIO_Init();
void eqep_test4_myEQEP0_init();
void eqep_test4_initEPWM(void);

void EQEP1_INT_IRQHandler(void);
void EPWM1XINT_IRQHandler(void);
void EPWM2XINT_IRQHandler(void);
int16_t EQEP_getQDLF(uint32_t base);
void print_ans();


uint32_t QPOSILAT_num[sum];
uint32_t INT_num[sum];
int32_t DIR_num[sum];
uint32_t EQEPCount1=0;
uint32_t PCEINT_num[sum];
uint32_t FIMF_num[sum];
uint32_t FIDF_num[sum];
uint32_t EQEPCount2=0;

int main(void)
{
	int ret;

    Device_init();
    UartPrint_init(SCIA_BASE, 115200);


	printf("eqep_test1_begin!\r\n");

	eqep_test4_GPIO_Init();


	//epeq1a
    XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX01);
    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT1, 0);
    XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_EPWM_MUX01_INPUTXBAR1);

	//epeq1b
    XBAR_enableEPWMMux(XBAR_TRIP5, XBAR_MUX03);
    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT2, 1);
    XBAR_setEPWMMuxConfig(XBAR_TRIP5, XBAR_EPWM_MUX03_INPUTXBAR2);
	//epeq1I
    XBAR_enableEPWMMux(XBAR_TRIP7, XBAR_MUX05);
    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT3, 2);
    XBAR_setEPWMMuxConfig(XBAR_TRIP7, XBAR_EPWM_MUX05_INPUTXBAR3);




	Interrupt_register(INT_EPWM1,EPWM1XINT_IRQHandler);
	Interrupt_SetPriority(INT_EPWM1,2,2);
	Interrupt_enable(INT_EPWM1);


	Interrupt_register(INT_EPWM2,EPWM2XINT_IRQHandler);
	Interrupt_SetPriority(INT_EPWM2,1,1);
	Interrupt_enable(INT_EPWM2);



	Interrupt_register(INT_EQEP1,EQEP1_INT_IRQHandler);
	Interrupt_SetPriority(INT_EQEP1,0,0);
	Interrupt_enable(INT_EQEP1);

	EQEP_SourceSelect source_myEQEP0 =
	{
		EQEP_SOURCE_PWMXBAR1, 		// eQEPA source
		EQEP_SOURCE_PWMXBAR2,		// eQEPB source
		EQEP_SOURCE_PWMXBAR3,  	// eQEP Index source
	};
	EQEP_selectSource(myEQEP0_BASE, source_myEQEP0);
	eqep_test4_myEQEP0_init();
	eqep_test4_initEPWM();


	__enable_irq();


	while(1)
		{

			if( EQEP_OK == 1 && EQEP_CASE == 1)
			{
				#if PRINTF_SW == 1
					printf("QA:EPWMXABR1 QB:EPWMXABR2 QC:EPWMXABR3\r\n");
					print_ans();
				#endif

				EQEP_OK = 0;
				EQEP_CASE++;


				EQEPCount1=0;
				EQEPCount2=0;
				SysCtl_resetEqep();
				SysCtl_resetEpwm();

				EQEP_selectSource(myEQEP0_BASE, source_myEQEP0);
				EQEP_SourceSelect source_myEQEP0 =
				{
					EQEP_SOURCE_PWMXBAR4, 		// eQEPA source
					EQEP_SOURCE_PWMXBAR5,		// eQEPB source
					EQEP_SOURCE_PWMXBAR6,  	// eQEP Index source
				};
				eqep_test4_myEQEP0_init();

				//epeq1a
			    XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX07);
			    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT1, 0);
			    XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_EPWM_MUX07_INPUTXBAR4);

				//epeq1b
			    XBAR_enableEPWMMux(XBAR_TRIP5, XBAR_MUX09);
			    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT2, 1);
			    XBAR_setEPWMMuxConfig(XBAR_TRIP5, XBAR_EPWM_MUX09_INPUTXBAR5);
				//epeq1I
			    XBAR_enableEPWMMux(XBAR_TRIP7, XBAR_MUX11);
			    XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT3, 2);
			    XBAR_setEPWMMuxConfig(XBAR_TRIP7, XBAR_EPWM_MUX11_INPUTXBAR6);

				interruptCount1=0;
				interruptCount2=0;

				eqep_test4_initEPWM();

			}
			else if(EQEP_OK == 1 && EQEP_CASE == 2)
			{

				#if PRINTF_SW == 1
					printf("QA:EPWMXABR4 QB:EPWMXABR5 QC:EPWMXABR6\r\n");
					print_ans();
				#endif

				EQEP_OK = 0;
				EQEP_CASE++;


				EQEPCount1=0;
				EQEPCount2=0;
				SysCtl_resetEqep();
				SysCtl_resetEpwm();

				EQEP_selectSource(myEQEP0_BASE, source_myEQEP0);
				EQEP_SourceSelect source_myEQEP0 =
				{
					EQEP_SOURCE_PWMXBAR7, 		// eQEPA source
					EQEP_SOURCE_PWMXBAR8,		// eQEPB source
					EQEP_SOURCE_PWMXBAR9,  	// eQEP Index source
				};
				eqep_test4_myEQEP0_init();

				//epeq1a
				XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX17);
				XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT1, 0);
				XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_EPWM_MUX17_INPUTXBAR7);

				//epeq1b
				XBAR_enableEPWMMux(XBAR_TRIP5, XBAR_MUX19);
				XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT2, 1);
				XBAR_setEPWMMuxConfig(XBAR_TRIP5, XBAR_EPWM_MUX19_INPUTXBAR8);
				//epeq1I
				XBAR_enableEPWMMux(XBAR_TRIP7, XBAR_MUX21);
				XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT3, 2);
				XBAR_setEPWMMuxConfig(XBAR_TRIP7, XBAR_EPWM_MUX21_INPUTXBAR9);

				interruptCount1=0;
				interruptCount2=0;

				eqep_test4_initEPWM();
			}
			else if(EQEP_OK == 1 && EQEP_CASE == 3)
			{

				#if PRINTF_SW == 1
					printf("QA:EPWMXABR7 QB:EPWMXABR8 QC:EPWMXABR9\r\n");
					print_ans();
				#endif

				EQEP_OK = 0;
				EQEP_CASE++;


				EQEPCount1=0;
				EQEPCount2=0;
				SysCtl_resetEqep();
				SysCtl_resetEpwm();

				EQEP_selectSource(myEQEP0_BASE, source_myEQEP0);
				EQEP_SourceSelect source_myEQEP0 =
				{
					EQEP_SOURCE_PWMXBAR10, 		// eQEPA source
					EQEP_SOURCE_PWMXBAR11,		// eQEPB source
					EQEP_SOURCE_PWMXBAR12,  	// eQEP Index source
				};
				eqep_test4_myEQEP0_init();

				//epeq1a
				XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX23);
				XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT1, 0);
				XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_EPWM_MUX23_INPUTXBAR10);

				//epeq1b
				XBAR_enableEPWMMux(XBAR_TRIP5, XBAR_MUX25);
				XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT2, 1);
				XBAR_setEPWMMuxConfig(XBAR_TRIP5, XBAR_EPWM_MUX25_INPUTXBAR11);
				//epeq1I
				XBAR_enableEPWMMux(XBAR_TRIP7, XBAR_MUX27);
				XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT3, 2);
				XBAR_setEPWMMuxConfig(XBAR_TRIP7, XBAR_EPWM_MUX27_INPUTXBAR12);

				interruptCount1=0;
				interruptCount2=0;

				eqep_test4_initEPWM();
			}
			else if(EQEP_OK == 1 && EQEP_CASE == 4)
			{

				#if PRINTF_SW == 1
					printf("QA:EPWMXABR10 QB:EPWMXABR11 QC:EPWMXABR12\r\n");
					print_ans();
				#endif

				EQEP_OK = 0;
				EQEP_CASE++;


				EQEPCount1=0;
				EQEPCount2=0;
				SysCtl_resetEqep();
				SysCtl_resetEpwm();

				EQEP_selectSource(myEQEP0_BASE, source_myEQEP0);
				EQEP_SourceSelect source_myEQEP0 =
				{
					EQEP_SOURCE_PWMXBAR13, 		// eQEPA source
					EQEP_SOURCE_PWMXBAR14,		// eQEPB source
					EQEP_SOURCE_PWMXBAR12,  	// eQEP Index source
				};
				eqep_test4_myEQEP0_init();

				//epeq1a
				XBAR_enableEPWMMux(XBAR_TRIP4, XBAR_MUX29);
				XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT1, 0);
				XBAR_setEPWMMuxConfig(XBAR_TRIP4, XBAR_EPWM_MUX29_INPUTXBAR13);

				//epeq1b
				XBAR_enableEPWMMux(XBAR_TRIP5, XBAR_MUX31);
				XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT2, 1);
				XBAR_setEPWMMuxConfig(XBAR_TRIP5, XBAR_EPWM_MUX31_INPUTXBAR14);
				//epeq1I
				XBAR_enableEPWMMux(XBAR_TRIP7, XBAR_MUX27);
				XBAR_setInputPin(INPUTXBAR_BASE, XBAR_INPUT3, 2);
				XBAR_setEPWMMuxConfig(XBAR_TRIP7, XBAR_EPWM_MUX27_INPUTXBAR12);

				interruptCount1=0;
				interruptCount2=0;

				eqep_test4_initEPWM();
			}
			else if(EQEP_OK == 1 && EQEP_CASE == 5)
			{

				#if PRINTF_SW == 1
					printf("QA:EPWMXABR13 QB:EPWMXABR14 QC:EPWMXABR12\r\n");
					print_ans();
				#endif

				EQEP_OK = 0;
				EQEP_CASE++;


				EQEPCount1=0;
				EQEPCount2=0;
				SysCtl_resetEqep();


				HWREG(0x400CD558)=0xBEEF;

			}


		}

    return 0;
}

void print_ans()
{
	for(i=1;i < EQEPCount1 - 2;i++)
	{
		CNT_DV[0] = QPOSILAT_num[i] - QPOSILAT_num[i+1];
		CNT_DV[1] = QPOSILAT_num[i+1] - QPOSILAT_num[i+2];


		if( ( CNT_DV[0] == 3995 ) && ( CNT_DV[1] == -3995 ) )
		{
			if( (DIR_num[i] == 1) && ( DIR_num[i+1] == -1 ) && ( DIR_num[i+2] == 1 ) )
			{
				printf("%d: CNT_OK,DIR_OK\r\n",i);
			}
			else
			{
				printf("%d: CNT_OK,DIR_ERROR\r\n",i);
			}
		}
		else if( ( CNT_DV[0] == -3995 ) && ( CNT_DV[1] == 3995 ) )
		{
			if( (DIR_num[i] == -1) && ( DIR_num[i+1] == 1 ) && ( DIR_num[i+2] == -1 ) )
			{
				printf("%d: CNT_OK,DIR_OK\r\n",i);
			}
			else
			{
				printf("%d: CNT_OK,DIR_ERROR\r\n",i);
			}
		}
		else
		{

			printf("%d: CNT_ERROR ",i);
			printf("CNT_DV[0]=%d,CNT_DV[1]=%d\r\n",CNT_DV[0],CNT_DV[1]);
		}
	}


	for(i=0;i < EQEPCount2 - 1;i++)
	{

		if( PCEINT_num[i] == QPOSILAT_num[2*i]  )
		{
				printf("%d: PCE_INT_OK\r\n",i);
		}
		else
		{
			printf("%d: PCE_INT_ERROR ",i);
			printf("PCEINT_num[%d]=%d,QPOSILAT_num[%d]=%d\r\n",i,PCEINT_num[i],2*i,QPOSILAT_num[2*i]);
		}
	}

}

void eqep_test4_GPIO_Init()
{
	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(GPIO_0_EPWM1_A);
	GPIO_setPadConfig(0, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(0, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(0,true);

	GPIO_setPinConfig(GPIO_1_EPWM1_B);
	GPIO_setPadConfig(1, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(1, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(1,true);

    //
	// EPWM2 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(GPIO_2_EPWM2_A);
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(2, GPIO_QUAL_SYNC);
	GPIO_setLoopBack(2,true);


	//eqep1A
	GPIO_setPinConfig(GPIO_50_EQEP1_A);
	GPIO_setPadConfig(50, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(50, GPIO_QUAL_SYNC);
    //eqep1B
	GPIO_setPinConfig(GPIO_51_EQEP1_B);
	GPIO_setPadConfig(51, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(51, GPIO_QUAL_SYNC);

	//eqep1I
	GPIO_setPinConfig(GPIO_53_EQEP1_INDEX);
	GPIO_setPadConfig(53, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(53, GPIO_QUAL_SYNC);





}


void eqep_test4_myEQEP0_init(){
	  //
	        // Disable, clear all flags and interrupts
	        //
	        EQEP_disableInterrupt(myEQEP0_BASE,
	            (EQEP_INT_GLOBAL            |
	            EQEP_INT_POS_CNT_ERROR      |
	            EQEP_INT_PHASE_ERROR        |
	            EQEP_INT_DIR_CHANGE         |
	            EQEP_INT_WATCHDOG           |
	            EQEP_INT_UNDERFLOW          |
	            EQEP_INT_OVERFLOW           |
	            EQEP_INT_POS_COMP_READY     |
	            EQEP_INT_POS_COMP_MATCH     |
	            EQEP_INT_STROBE_EVNT_LATCH  |
	            EQEP_INT_INDEX_EVNT_LATCH   |
	            EQEP_INT_UNIT_TIME_OUT      |
	            EQEP_INT_QMA_ERROR));
	        EQEP_clearInterruptStatus(myEQEP0_BASE,
	            (EQEP_INT_GLOBAL            |
	            EQEP_INT_POS_CNT_ERROR      |
	            EQEP_INT_PHASE_ERROR        |
	            EQEP_INT_DIR_CHANGE         |
	            EQEP_INT_WATCHDOG           |
	            EQEP_INT_UNDERFLOW          |
	            EQEP_INT_OVERFLOW           |
	            EQEP_INT_POS_COMP_READY     |
	            EQEP_INT_POS_COMP_MATCH     |
	            EQEP_INT_STROBE_EVNT_LATCH  |
	            EQEP_INT_INDEX_EVNT_LATCH   |
	            EQEP_INT_UNIT_TIME_OUT      |
	            EQEP_INT_QMA_ERROR));

	//
	// Set the strobe input source of the eQEP module.
	//
	EQEP_setStrobeSource(myEQEP0_BASE,EQEP_STROBE_FROM_GPIO);
	//
	// Sets the polarity of the eQEP module's input signals.
	//
	EQEP_setInputPolarity(myEQEP0_BASE,false,false,false,false);
	//
	// Configures eQEP module's quadrature decoder unit.
	//
	EQEP_setDecoderConfig(myEQEP0_BASE, (EQEP_CONFIG_QUADRATURE | EQEP_CONFIG_1X_RESOLUTION | EQEP_CONFIG_NO_SWAP | EQEP_CONFIG_IGATE_DISABLE));
	//
	// Set the emulation mode of the eQEP module.
	//
	EQEP_setEmulationMode(myEQEP0_BASE,EQEP_EMULATIONMODE_RUNFREE);
	//
	// Configures eQEP module position counter unit.
	//
	EQEP_setPositionCounterConfig(myEQEP0_BASE,EQEP_POSITION_RESET_IDX,3999U);
	//
	// Sets the current encoder position.
	//
	EQEP_setPosition(myEQEP0_BASE,0U);
	//
	// Enables the eQEP module unit timer.
	//
	//EQEP_enableUnitTimer(myEQEP0_BASE,1200000U);
	HWREG(myEQEP0_BASE + EQEP_O_QUPRD) = 1200000U;
	EQEP_disableUnitTimer(myEQEP0_BASE);
	//
	// Disables the eQEP module watchdog timer.
	//
	EQEP_disableWatchdog(myEQEP0_BASE);
	HWREG(myEQEP0_BASE + EQEP_O_QWDTMR) = 0xFFFF0000;
	//
	// Configures the quadrature modes in which the position count can be latched.
	//
	EQEP_setLatchMode(myEQEP0_BASE,(EQEP_LATCH_SW_INDEX_MARKER));
	//
	// Set the quadrature mode adapter (QMA) module mode.
	//
	EQEP_setQMAModuleMode(myEQEP0_BASE,EQEP_QMA_MODE_BYPASS);
	//
	// Disable Direction Change During Index
	//
	EQEP_disableDirectionChangeDuringIndex(myEQEP0_BASE);
	//
	// Configures the mode in which the position counter is initialized.
	//
	EQEP_setPositionInitMode(myEQEP0_BASE,(EQEP_INIT_DO_NOTHING));
	//
	// Sets the software initialization of the encoder position counter.
	//
	EQEP_setSWPositionInit(myEQEP0_BASE,true);
	// Sets the init value for the encoder position counter.
	//
	EQEP_setInitialPosition(myEQEP0_BASE,0U);
	//
	// Enables the eQEP module.
	//
	EQEP_enableModule(myEQEP0_BASE);
	// Enables individual eQEP module interrupt sources.
	//
	EQEP_enableInterrupt(myEQEP0_BASE,(EQEP_INT_INDEX_EVNT_LATCH|EQEP_INT_POS_CNT_ERROR));

}
void eqep_test4_initEPWM(void)
{

    //
    // Set phase shift to 0 and clear the time base counter
    //
    EPWM_setPhaseShift(EPWM1_BASE, 0);
    EPWM_setTimeBaseCounter(myEPWM1base, 0);

    //
    // Disable the shadow load; the load will be immediate instead
    //
    EPWM_disableCounterCompareShadowLoadMode(myEPWM1base,
                                             EPWM_COUNTER_COMPARE_A);
    EPWM_disableCounterCompareShadowLoadMode(myEPWM1base,
                                             EPWM_COUNTER_COMPARE_B);



    //
    // Set the compare A value to half the period value, compare B to 0
    //
    EPWM_setCounterCompareValue(myEPWM1base, EPWM_COUNTER_COMPARE_A, 10000);
    EPWM_setCounterCompareValue(myEPWM1base, EPWM_COUNTER_COMPARE_B, 1);

    //
    // Set action qualifier behavior on compare A events
    // - EPWM1A --> 1 when CTR = CMPA and increasing
    // - EPWM1A --> 0 when CTR = CMPA and decreasing
    //
    EPWM_setActionQualifierAction(myEPWM1base, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    EPWM_setActionQualifierAction(myEPWM1base, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);

    //
    // Set action qualifier behavior on compare B events
    // - EPWM1B --> 1 when CTR = PRD and increasing
    // - EPWM1B --> 0 when CTR = 0 and decreasing
    //
    EPWM_setActionQualifierAction(myEPWM1base, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
    EPWM_setActionQualifierAction(myEPWM1base, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);

    //
    // Enable interrupt when the counter is equal to PRD
    //
    EPWM_setInterruptSource(myEPWM1base, EPWM_INT_TBCTR_PERIOD);
    EPWM_enableInterrupt(myEPWM1base);

    //
    // Interrupt on first event
    //
    EPWM_setInterruptEventCount(myEPWM1base, 1);

    //
    // Set the time base clock prescaler to /1
    //
    EPWM_setClockPrescaler(myEPWM1base, EPWM_CLOCK_DIVIDER_4,
                           EPWM_HSCLOCK_DIVIDER_1);

    //
    // Set the period value; don't shadow the register
    //
    EPWM_setPeriodLoadMode(myEPWM1base, EPWM_PERIOD_DIRECT_LOAD);
    EPWM_setTimeBasePeriod(myEPWM1base, 20000);

    //
    // Put the time base counter into up-down count mode
    //
    EPWM_setTimeBaseCounterMode(myEPWM1base, EPWM_COUNTER_MODE_UP_DOWN);

 /**********************************EPWM2***************************************************/

    //
    // Set phase shift to 0 and clear the time base counter
    //
    EPWM_setPhaseShift(EPWM2_BASE, 0);
    EPWM_setTimeBaseCounter(EPWM2_BASE, 0);


    //
    // Disable the shadow load; the load will be immediate instead
    //
    EPWM_disableCounterCompareShadowLoadMode(EPWM2_BASE,
                                             EPWM_COUNTER_COMPARE_A);
    EPWM_disableCounterCompareShadowLoadMode(EPWM2_BASE,
                                             EPWM_COUNTER_COMPARE_B);
//	HWREGH(EPWM2_BASE + EPWM_O_AQCTL) |= 0x01>>6;
    //
    // Set the compare A value to half the period value, compare B to 0
    //
    EPWM_setCounterCompareValue(EPWM2_BASE, EPWM_COUNTER_COMPARE_A, 5001);
    EPWM_setCounterCompareValue(EPWM2_BASE, EPWM_COUNTER_COMPARE_B, 10000);

    //
    // Set action qualifier behavior on compare A events
    // - EPWM1A --> 1 when CTR = CMPA and increasing
    // - EPWM1A --> 0 when CTR = CMPA and decreasing
    //
	EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
			                          EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
    EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
    		                                EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);

    //
    // Set action qualifier behavior on compare B events
    // - EPWM1B --> 1 when CTR = PRD and increasing
    // - EPWM1B --> 0 when CTR = 0 and decreasing
    //
    EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPB);
    EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPB);

    //
    // Enable interrupt when the counter is equal to PRD
    //
    EPWM_setInterruptSource(EPWM2_BASE, EPWM_INT_TBCTR_ZERO);
    EPWM_enableInterrupt(EPWM2_BASE);

    //
    // Interrupt on first event
    //
    EPWM_setInterruptEventCount(EPWM2_BASE, 1);

    //
    // Set the time base clock prescaler to /1
    //
    EPWM_setClockPrescaler(EPWM2_BASE, EPWM_CLOCK_DIVIDER_4,
                           EPWM_HSCLOCK_DIVIDER_1);

    //
    // Set the period value; don't shadow the register
    //
    EPWM_setPeriodLoadMode(EPWM2_BASE, EPWM_PERIOD_DIRECT_LOAD);
    EPWM_setTimeBasePeriod(EPWM2_BASE, 20000);

    //
    // Put the time base counter into up-down count mode
    //
    EPWM_setTimeBaseCounterMode(EPWM2_BASE, EPWM_COUNTER_MODE_UP_DOWN);
    //
    // Sync the ePWM time base clock
    //

    SysCtl_enablePeripheral_TBCLKSYNC();
#if IS_GS32F00xx(0x12)
    EPWM_setHrpwmDllCfg1(PREEPWM_BASE, 0x7FFF << 11);
#elif IS_GS32F3xx(0x22)
    EPWM_setHrpwmDllCfg0(PREEPWM_BASE,0x1);
#endif


}

/**
 * \brief   ePWM3 ISR--interrupts once every 4 QCLK counts (one period)
 *
 * \param   none
 *
 * \retval  None
 */
void EPWM1XINT_IRQHandler(void)
{



    interruptCount1++;


    if( interruptCount1 % 6 == 2)
    { //epwm1b 0,1 -> 0,0

		EPWM_setActionQualifierAction(myEPWM1base, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
		EPWM_setActionQualifierAction(myEPWM1base, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);

    }
	  else if(interruptCount1 % 6 == 3)
    {
		EPWM_setActionQualifierAction(myEPWM1base, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
         EPWM_setActionQualifierAction(myEPWM1base, EPWM_AQ_OUTPUT_B,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
    }

	else if(interruptCount1 % 6 == 0)
	{
		EPWM_setActionQualifierAction(myEPWM1base, EPWM_AQ_OUTPUT_B,
							  EPWM_AQ_OUTPUT_LOW,
							  EPWM_AQ_OUTPUT_ON_TIMEBASE_ZERO);
			EPWM_setActionQualifierAction(myEPWM1base, EPWM_AQ_OUTPUT_B,
							  EPWM_AQ_OUTPUT_HIGH,
							  EPWM_AQ_OUTPUT_ON_TIMEBASE_PERIOD);
	}


    //
    // Clear interrupt flag and issue ACK
    //
    EPWM_clearEventTriggerInterruptFlag(myEPWM1base);
    //Interrupt_clearACKGroup(INTERRUPT_ACK_GROUP3);
}

void EPWM2XINT_IRQHandler(void)

{

	interruptCount2++;
	if ( interruptCount2 % 6 == 1 )
	{
//		GPIO_writePin(myGPIO54, 1);
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
		//GPIO_togglePin(3);
	}
	else if ( interruptCount2 % 6 == 2 )
	{

	}
	else if ( interruptCount2 % 6 == 3 )
	{
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
		//GPIO_togglePin(3);
	}
	else if ( interruptCount2 % 6 == 4 )
	{
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_LOW,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
		//GPIO_writePin(10,1);
		//GPIO_togglePin(3);
	}
	else if ( interruptCount2 % 6 == 0 )
	{
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_NO_CHANGE,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_UP_CMPA);
		EPWM_setActionQualifierAction(EPWM2_BASE, EPWM_AQ_OUTPUT_A,
                                  EPWM_AQ_OUTPUT_HIGH,
                                  EPWM_AQ_OUTPUT_ON_TIMEBASE_DOWN_CMPA);
		//GPIO_togglePin(3);
	}

	if(interruptCount2  >= sum)
	{
		EQEP_OK = 1;
		SysCtl_resetEpwm();

	}

		EPWM_clearEventTriggerInterruptFlag(EPWM2_BASE);
}

void EQEP1_INT_IRQHandler(void)
{

	DIR = EQEP_getQDLF(myEQEP0_BASE);

	if(( EQEP_OK == 0 )&& ((EQEP_getInterruptStatus(myEQEP0_BASE) >> 10) & 1 == 1))
	{

		QPOSILAT = EQEP_getIndexPositionLatch(myEQEP0_BASE);


		INT_num[EQEPCount1] = interruptCount2 % 6 + 1;


		QPOSILAT_num[EQEPCount1] = QPOSILAT;

		DIR_num[EQEPCount1]=  DIR;

		EQEPCount1++;

	}
	EQEP_clearInterruptStatus(myEQEP0_BASE,EQEP_INT_INDEX_EVNT_LATCH|EQEP_INT_GLOBAL);



	if(( EQEP_OK == 0 ) && ((EQEP_getInterruptStatus(myEQEP0_BASE) >> 1) & 1 == 1))
	{
		PCEINT_num[EQEPCount2] = EQEP_getIndexPositionLatch(myEQEP0_BASE);
		EQEPCount2++;

	}
	EQEP_clearInterruptStatus(myEQEP0_BASE,EQEP_INT_POS_CNT_ERROR|EQEP_INT_GLOBAL);



}


int16_t EQEP_getQDLF(uint32_t base)
{
    int16_t direction;

    //
    // Check the arguments.
    //
    ASSERT(EQEP_isBaseValid(base));

    //
    // Return the direction of rotation.
    //
    if((HWREGH(base + EQEP_O_QEPSTS) & EQEP_QEPSTS_QDLF) != 0U)
    {
        direction = 1;
    }
    else
    {
        direction = -1;
    }

    return(direction);
}

