/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */
/*
 * @brief  GPIO ISR
 */
#if USING_VECTOR_INTERRUPT != 0
__INTERRUPT void GPIO_IRQHandler(void)
{
    SAVE_IRQ_CSR_CONTEXT(); // Save interrupt context

    GpioDataRegs.GPATOGGLE.bit.GPIO1 = 0x1; // Toggle GPIO1 state

    RESTORE_IRQ_CSR_CONTEXT(); // Restore interrupt context
}
#else
void GPIO_IRQHandler(void)
{
    GpioDataRegs.GPATOGGLE.bit.GPIO1 = 0x1; // Toggle GPIO1 state
}
#endif

void myGPIOInputInterrupt_init()
{

    GpioCtrlRegs.GPAPUD.bit.GPIO0   = GPIO_PULL_ENABLE; // Enable pull-up resistor on GPIO0
    GpioCtrlRegs.GPAQSEL1.bit.GPIO0 = GPIO_QUAL_SYNC;   // Set GPIO0 qualification to synchronized
    GpioCtrlRegs.GPADIR.bit.GPIO0   = GPIO_DIR_MODE_IN; // Set GPIO0 as input
}
void myGPIOOutput_init()
{

    GpioCtrlRegs.GPAPUD.bit.GPIO1   = GPIO_PULL_DISABLE; // Disable pull-up resistor on GPIO1
    GpioCtrlRegs.GPAQSEL1.bit.GPIO1 = GPIO_QUAL_SYNC;    // Set GPIO1 qualification to synchronized
    GpioCtrlRegs.GPADIR.bit.GPIO1   = GPIO_DIR_MODE_OUT; // Set GPIO1 as output
}

void GPIO_init()
{
    // Configure GPIO0 and GPIO1 as GPIO pins
    GpioCtrlRegs.GPAMUX1.bit.GPIO0 = GPIO_0_GPIO0 & GPIO_MUX_MASK; // GPIO_0_GPIO0
    GpioCtrlRegs.GPAMUX1.bit.GPIO1 = GPIO_1_GPIO1 & GPIO_MUX_MASK; // GPIO_1_GPIO1

    myGPIOInputInterrupt_init(); // Initialize GPIO input with interrupt settings
    myGPIOOutput_init();         // Initialize GPIO output settings
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*
 * @brief  main function.
 */
int main(void)
{
    // Initialize the device
    Device_init();

    // Initialize GPIO pins and configure interrupt settings
    GPIO_init();

    // Configure the interrupt type for XINT1 as rising edge trigger
    GPIO_setInterruptType(GPIO_INT_XINT1, GPIO_INT_TYPE_RISING_EDGE);

    // Bind GPIO0 to XINT1
    GpioIntRegs.GPIOXINT1SEL.bit.GPIOSEL = 0x0;

    // Enable XINT1 interrupt
    GPIO_enableInterrupt(GPIO_INT_XINT1);

    // Register the GPIO interrupt handler for XINT1
    Interrupt_register(INT_XINT1, GPIO_IRQHandler);

    // Enable XINT1 interrupt for the CPU
    Interrupt_enable(INT_XINT1);

    // Enable global interrupts
    __enable_irq();

    while (1) {
    }

    return 0;
}
