/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "printf.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define my_GPIO_PORT_DATA GPIO_PORTA_L
#define my_GPIO_PORT_CTRL GPIO_PORTA

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

uint32_t gpio_dataout_L=0;

uint32_t gpio_data_L=0;

uint32_t gpio_outreport_L=0;

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

void GPIO_Test1_Init();

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */
void GPIO_Test1_Init()
{
	uint32_t i=0;
	uint32_t my_INDEX_FIRST = 0;
	uint32_t my_INDEX_FINAL = 0;
	//enable write
	//*******************************************************

	my_INDEX_FIRST = (uint32_t) my_GPIO_PORT_DATA*16;
	my_INDEX_FINAL = my_INDEX_FIRST + 16;

	GPIO_setAnalogMode(13,GPIO_ANALOG_DISABLED);

	for(i=my_INDEX_FIRST;i<my_INDEX_FINAL;i++)
	{
		GPIO_setDirectionMode(i,GPIO_DIR_MODE_OUT);//set gpioi to output mode
		GPIO_setLoopBack(i,TRUE);//gpioi Loopback enable
	}

	gpio_dataout_L = GPIO_readPortDataOut(my_GPIO_PORT_DATA);//read portx DATAOUT
	gpio_data_L = GPIO_readPortData(my_GPIO_PORT_DATA);//read portx DATA
	if (my_GPIO_PORT_DATA%2==0)//read portx outreport
	{
		gpio_outreport_L = GPIO_readPortOutReport(my_GPIO_PORT_CTRL)& 0xFFFF;
	}
	else
	{
		gpio_outreport_L = (GPIO_readPortOutReport(my_GPIO_PORT_CTRL) >> 16 )& 0xFFFF;
	}

	GPIO_writePortData(my_GPIO_PORT_DATA,0xFFFF);////write portx DATAOUT to 0xFFFF
	gpio_dataout_L = GPIO_readPortDataOut(my_GPIO_PORT_DATA);//read portx DATAOUT
	gpio_data_L = GPIO_readPortData(my_GPIO_PORT_DATA);//read portx DATA
	if (my_GPIO_PORT_DATA%2==0)//read portx outreport
	{
		gpio_outreport_L = GPIO_readPortOutReport(my_GPIO_PORT_CTRL)& 0xFFFF;
	}
	else
	{
		gpio_outreport_L = (GPIO_readPortOutReport(my_GPIO_PORT_CTRL) >> 16 )& 0xFFFF;
	}

	GPIO_writePortData(my_GPIO_PORT_DATA,0x0000);//write portx DATAOUT to 0x0000
	gpio_dataout_L = GPIO_readPortDataOut(my_GPIO_PORT_DATA);//read portx DATAOUT
	gpio_data_L = GPIO_readPortData(my_GPIO_PORT_DATA);//read portx DATA
	if (my_GPIO_PORT_DATA%2==0)//read portx outreport
	{
		gpio_outreport_L = GPIO_readPortOutReport(my_GPIO_PORT_CTRL)& 0xFFFF;
	}
	else
	{
		gpio_outreport_L = (GPIO_readPortOutReport(my_GPIO_PORT_CTRL) >> 16 )& 0xFFFF;
	}

	//set portx to input mode
	for(i=my_INDEX_FIRST;i<my_INDEX_FINAL;i++)
	{
		GPIO_setDirectionMode(i,GPIO_DIR_MODE_IN);//set gpio to input mode
		GPIO_setLoopBack(i,FALSE);//gpio Loopback disable
	}
	//*******************************************************

	gpio_data_L = GPIO_readPortData(my_GPIO_PORT_DATA);//read portx DATAֵ


	gpio_data_L = GPIO_readPortData(my_GPIO_PORT_DATA);//read portx DATAֵ

	//*******************************************************
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/**
  * @brief  Main program
  * @param  None
  * @retval None
  */

int main(void)
{
	Device_init();

    UartPrint_init(SCIA_BASE, 115200);

	printf("gpio_test1_begin!\r\n");

    __enable_irq();

    GPIO_Test1_Init();

	while(1)
	{

	}
}



