/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "device.h"
#include "printf.h"
#include "board_cfg.h"


void GPIO_Test2_Init()
{
	//set GPIO0 to output mode
	GPIO_setDirectionMode(0,GPIO_DIR_MODE_OUT);

	//set GPIO1 pad to Invert polarity on input
	GPIO_setPinConfig(GPIO_1_GPIO1);
	GPIO_setPadConfig(1, GPIO_PIN_TYPE_INVERT);
	GPIO_setQualificationMode(1, GPIO_QUAL_SYNC);

	//set INPUTXBAR OUTPUTXBAR to GPIO1 GPIO2
	XBAR_setInputPin(INPUTXBAR_BASE,XBAR_INPUT1,1);

    XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX01);

	XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_OUT_MUX01_INPUTXBAR1);

	//set GPIO2 pinmux to OUTPUTXBAR1
	GPIO_setPinConfig(GPIO_2_OUTPUTXBAR1);
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(2, GPIO_QUAL_SYNC);

}

/* Private functions ---------------------------------------------------------*/
/**
  * @brief  Main program
  * @param  None
  * @retval None
  */

int main(void)
{


	Device_init();

    UartPrint_init(SCIA_BASE, 115200);

	printf("gpio_test2_begin!\r\n");

    __enable_irq();

    GPIO_Test2_Init();

	while(1)
	{

	}

}


