// See LICENSE for license details.
#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "driverlib.h"
#include "printf.h"
#include "log.h"
#include "board_cfg.h"
#include "load_img.h"
#include "interrupt.h"

#define OUTPUT_TEST 1  //0:VOL test  1:VOH test
#define INPUT_TEST 0  //0:VIL test  1:VIH test
#define DELAYTIME 10000
#define LOOP_SUM 10

#if IS_GS32F00xx(0x12)
	uint32_t GPIO_test_Index[] = {0,1,4,5,13,20,21};//set pins to test rising or falling times and current
#elif IS_GS32F3xx(0x22)
	uint32_t GPIO_test_Index[] = {0,1,4,5};//set pins to test rising or falling times and current
#endif

uint32_t length_GPIO=0;
uint32_t printf_index=0;

void GPIO_Output_Init();
void GPIO_Input_Init();

typedef enum
{
    GPIO_PINS_DIR_OUT,       //!< Pin is in digital mode
	GPIO_PINS_DIR_IN         //!< Pin is in analog mode
} GPIO_PinsDirectionMode;


typedef enum
{
	GPIO_PINS_DRIVE_STRENGTH_0,       //drive strength GPIO:2mA  PI2C GPIO:4mA
	GPIO_PINS_DRIVE_STRENGTH_1,		 //drive strength GPIO:4mA  PI2C GPIO:20mA
	GPIO_PINS_DRIVE_STRENGTH_2,		 //drive strength GPIO:8mA
	GPIO_PINS_DRIVE_STRENGTH_3        //drive strength GPIO:12mA
} GPIO_PinsDriveStrength;


void GPIO_setPinsFalling(void)
{
	uint32_t i=0;
	for(i=0;i<length_GPIO;i++)
	{
		uint32_t GPIO_INDEX_TEMP=0;
		GPIO_INDEX_TEMP = GPIO_test_Index[i];
		GPIO_writePin(GPIO_INDEX_TEMP,1);

		DELAY_US(DELAYTIME);

		GPIO_writePin(GPIO_INDEX_TEMP,0);

		DELAY_US(DELAYTIME);
	}

}

void GPIO_setPinsRising(void)
{
	uint32_t i=0;
	for(i=0;i<length_GPIO;i++)
	{
		uint32_t GPIO_INDEX_TEMP=0;
		GPIO_INDEX_TEMP = GPIO_test_Index[i];
		GPIO_writePin(GPIO_INDEX_TEMP,0);

		DELAY_US(DELAYTIME);

		GPIO_writePin(GPIO_INDEX_TEMP,1);

		DELAY_US(DELAYTIME);
	}
}

void GPIO_setPinsStrength(GPIO_PinsDriveStrength PinsDriveStrength)
{
	uint32_t i=0;
	if (PinsDriveStrength == GPIO_PINS_DRIVE_STRENGTH_0)
	{

		for(i=0;i<length_GPIO;i++)
		{
			uint32_t GPIO_INDEX_TEMP=0;
			GPIO_INDEX_TEMP = GPIO_test_Index[i];
			GPIO_setStrength(GPIO_INDEX_TEMP,GPIO_PIN_DRIVE_STRENGTH_0);//set gpio0 drive strength 0
		}
	}
	else if(PinsDriveStrength == GPIO_PINS_DRIVE_STRENGTH_1)
	{
		for(i=0;i<length_GPIO;i++)
		{
			uint32_t GPIO_INDEX_TEMP=0;
			GPIO_INDEX_TEMP = GPIO_test_Index[i];
			GPIO_setStrength(GPIO_INDEX_TEMP,GPIO_PIN_DRIVE_STRENGTH_1);//set gpio0 drive strength 1
		}
	}
	else if(PinsDriveStrength == GPIO_PINS_DRIVE_STRENGTH_2)
	{
		for(i=0;i<length_GPIO;i++)
		{
			uint32_t GPIO_INDEX_TEMP=0;
			GPIO_INDEX_TEMP = GPIO_test_Index[i];
			GPIO_setStrength(GPIO_INDEX_TEMP,GPIO_PIN_DRIVE_STRENGTH_2);//set gpio0 drive strength 2
		}
	}
	else if(PinsDriveStrength == GPIO_PINS_DRIVE_STRENGTH_3)
	{
		for(i=0;i<length_GPIO;i++)
		{
			uint32_t GPIO_INDEX_TEMP=0;
			GPIO_INDEX_TEMP = GPIO_test_Index[i];
			GPIO_setStrength(GPIO_INDEX_TEMP,GPIO_PIN_DRIVE_STRENGTH_3);//set gpio0 drive strength 3
		}
	}

}

void GPIO_setPinsDirectionMode(GPIO_PinsDirectionMode PinsDirectionMode)
{
	uint32_t i=0;
	if (PinsDirectionMode == GPIO_PINS_DIR_OUT)
	{

		for(i=0;i<length_GPIO;i++)
		{
			uint32_t GPIO_INDEX_TEMP=0;
			GPIO_INDEX_TEMP = GPIO_test_Index[i];
			GPIO_setDirectionMode(GPIO_INDEX_TEMP,GPIO_DIR_MODE_OUT);
		}
	}
	else if(PinsDirectionMode == GPIO_PINS_DIR_IN)
	{
		for(i=0;i<length_GPIO;i++)
		{
			uint32_t GPIO_INDEX_TEMP=0;
			GPIO_INDEX_TEMP = GPIO_test_Index[i];
			GPIO_setDirectionMode(GPIO_INDEX_TEMP,GPIO_DIR_MODE_IN);
		}
	}

}

int main(void)
{
    uint32_t oldTicks;
    uint32_t tickCnt;

     Device_init();

     UartPrint_init(LOG_SCI_BASE, 115200);

     printf("gpio_test07_begin!\r\n");

     DELAY_US(1000);

     length_GPIO = sizeof(GPIO_test_Index)/4;

     GPIO_Output_Init();//VOH/VOL

     GPIO_Input_Init();//VIH/VIL

    __enable_irq();



    while (1)
    {
		uint32_t i ;
		uint32_t DATA = 0 ;
		printf("%d*************************************\r\n",printf_index);
		for(i=0;i<length_GPIO;i++)
		{
			DATA = GPIO_readPin(GPIO_test_Index[i]);// read data pin
			printf("GPIO%d: %d\r\n", GPIO_test_Index[i],DATA);
			DELAY_US(1000);
		}

		DELAY_US(1000000);
		printf_index++;

    }

    return 0;
}

void GPIO_Output_Init()
{

#if IS_GS32F00xx(0x12)
	GPIO_setAnalogMode(13,GPIO_ANALOG_DISABLED);
	GPIO_setAnalogMode(20,GPIO_ANALOG_DISABLED);
	GPIO_setAnalogMode(21,GPIO_ANALOG_DISABLED);
#elif IS_GS32F3xx(0x22)


#endif
	uint32_t i=0;
#if OUTPUT_TEST == 1
	//*******************************************VOH********************************************************//
	GPIO_setPinsStrength(GPIO_PINS_DRIVE_STRENGTH_0);
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_OUT);
	for(i=0;i<LOOP_SUM;i++)
	{
		GPIO_setPinsRising();
	}
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_IN);

	GPIO_setPinsStrength(GPIO_PINS_DRIVE_STRENGTH_1);
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_OUT);
	for(i=0;i<LOOP_SUM;i++)
	{
		GPIO_setPinsRising();
	}
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_IN);

	GPIO_setPinsStrength(GPIO_PINS_DRIVE_STRENGTH_2);
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_OUT);
	for(i=0;i<LOOP_SUM;i++)
	{
		GPIO_setPinsRising();
	}
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_IN);

	GPIO_setPinsStrength(GPIO_PINS_DRIVE_STRENGTH_3);
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_OUT);
	for(i=0;i<LOOP_SUM;i++)
	{
		GPIO_setPinsRising();
	}
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_IN);

#elif OUTPUT_TEST == 0
	//*******************************************VOL********************************************************//
	GPIO_setPinsStrength(GPIO_PINS_DRIVE_STRENGTH_0);
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_OUT);
	for(i=0;i<LOOP_SUM;i++)
	{
		GPIO_setPinsFalling();
	}
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_IN);

	GPIO_setPinsStrength(GPIO_PINS_DRIVE_STRENGTH_1);
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_OUT);
	for(i=0;i<LOOP_SUM;i++)
	{
		GPIO_setPinsFalling();
	}
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_IN);

	GPIO_setPinsStrength(GPIO_PINS_DRIVE_STRENGTH_2);
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_OUT);
	for(i=0;i<LOOP_SUM;i++)
	{
		GPIO_setPinsFalling();
	}
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_IN);

	GPIO_setPinsStrength(GPIO_PINS_DRIVE_STRENGTH_3);
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_OUT);
	for(i=0;i<LOOP_SUM;i++)
	{
		GPIO_setPinsFalling();
	}
	GPIO_setPinsDirectionMode(GPIO_PINS_DIR_IN);


#endif


}


void GPIO_Input_Init()
{
	uint32_t i=0;
	#if INPUT_TEST == 1
	//*******************************************VIH********************************************************//
	for(i=0;i<length_GPIO;i++)
	{
		uint32_t GPIO_INDEX_TEMP=0;
		GPIO_INDEX_TEMP = GPIO_test_Index[i];
		GPIO_setPadConfig(GPIO_INDEX_TEMP,GPIO_PIN_TYPE_PULLUP);//set gpio to pullup
		GPIO_setDirectionMode(GPIO_INDEX_TEMP,GPIO_DIR_MODE_IN);//set gpio Direction to input mode
	}
	#elif INPUT_TEST == 0
	//*******************************************VIL********************************************************//
	for(i=0;i<length_GPIO;i++)
	{
		uint32_t GPIO_INDEX_TEMP=0;
		GPIO_INDEX_TEMP = GPIO_test_Index[i];
		GPIO_setPadConfig(GPIO_INDEX_TEMP,GPIO_PIN_TYPE_PULLDOWN);//set gpio to pulldowm
		GPIO_setDirectionMode(GPIO_INDEX_TEMP,GPIO_DIR_MODE_IN);//set gpio Direction to input mode
	}
	#endif

}
