/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */



#ifndef __EEPROM_POLLING_H_
#define __EEPROM_POLLING_H_

#ifdef __cplusplus
extern "C"{
#endif

#include "device.h"
#include "printf.h"

typedef enum
{
    I2C_NEXT_CONDITION_NONE          = 0x01,
    I2C_NEXT_CONDITION_STOP          = 0x02,
    I2C_NEXT_CONDITION_RESTART       = 0x04,
} I2C_NEXT_CONDITION;

/* Error messages for read and write functions */
#define ERROR_BUS_BUSY             0x1000
#define ERROR_NACK_RECEIVED        0x2000
#define ERROR_ARBITRATION_LOST     0x3000
#define ERROR_ADDRESS_ERROR        0x4000
#define ERROR_STOP_NOT_READY       0x5555
#define I2C_LINK_SUCCESS           0x0000

#define EEPROM_SLAVE_ADDRESS   0x50

#define EEPROM_PAGE_LEN   8	//Byte Length of a page
#define W_DATA_LEN   EEPROM_PAGE_LEN*16 //Total number of bytes written to EEPROM

#define W_ADDR       0x00//Starting address for writing to EEPROM
#define EEPROM_DATA_ADDRESS_LEN   1		//EEPROM address length


uint16_t eeprom_DataAddrWrite(uint32_t base, uint32_t data_addr);
uint16_t eeprom_WriteData(uint32_t base, uint32_t data_addr, uint8_t *data_cmd, uint32_t data_cmd_len, I2C_NEXT_CONDITION next_cond);
uint16_t eeprom_ReadData(uint32_t base, uint32_t data_addr, uint8_t *data_cmd, uint32_t data_cmd_len, I2C_NEXT_CONDITION next_cond);
uint16_t checkBusStatus(uint32_t base);
uint16_t handleNACK(uint32_t base);
void eeprom_init(uint32_t addr_len);
void I2C_GPIO_init(void);
void I2Cinit(uint32_t i2c_base);
uint16_t verifyEEPROMRead(uint32_t i2c_base);
void i2c_eeprom_operate(uint32_t i2c_base);

extern uint16_t status;
extern uint32_t g_i2c_base;


#ifdef __cplusplus
}
#endif

#endif
