/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __SLAVE_H_
#define __SLAVE_H_

#ifdef __cplusplus
extern "C"{
#endif


#include "device.h"
#include <stdio.h>

#define W_DATA_LEN   16

#define I2C_SLAVE_ADDRESS   0x55


void i2c_err_irq_check(uint32_t i2c_base, uint32_t i2c_port_num, uint32_t irq_status);
void I2CX_SLAVE_INTR_IRQHandler(void);
void I2C_slave_init(uint32_t i2c_base);
void i2c_slave_verify(uint32_t i2c_base);
void i2c_slave_check_data_rcv(void);
void i2c_test03_master_slave(void);

#ifdef __cplusplus
}
#endif

#endif
