/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


#ifndef IIC_SOFTWARE_SIMULATION_H_
#define IIC_SOFTWARE_SIMULATION_H_

#ifdef __cplusplus
extern "C"{
#endif

#include "device.h"

#if (GS32_PART_NUM != 0x35)

#define SDA_PIN 2U
#define SCL_PIN 3U

#define SDA_PINMUX	GPIO_2_GPIO2
#define SCL_PINMUX	GPIO_3_GPIO3

#define SDA_OUTPUT	GPIO_setDirectionMode(SDA_PIN,GPIO_DIR_MODE_OUT)
#define SDA_INPUT	GPIO_setDirectionMode(SDA_PIN,GPIO_DIR_MODE_IN)

#define SDA_H		GPIO_writePin(SDA_PIN,1)
#define SDA_L		GPIO_writePin(SDA_PIN,0)
#define SCL_H		GPIO_writePin(SCL_PIN,1)
#define SCL_L		GPIO_writePin(SCL_PIN,0)

#define SDA_READ	GPIO_readPin(SDA_PIN)

#else

#define I2C_SDA_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO30 = (GPIO_30_GPIO30 & GPIO_MUX_MASK)
#define I2C_SCL_PIN_MUX		GpioCtrlRegs.GPAMUX2.bit.GPIO31 = (GPIO_31_GPIO31 & GPIO_MUX_MASK)

#define SDA_OUTPUT	GpioCtrlRegs.GPADIR.bit.GPIO30 = 0x01
#define SDA_INPUT	GpioCtrlRegs.GPADIR.bit.GPIO31 = 0x00
#define SCL_OUTPUT	GpioCtrlRegs.GPADIR.bit.GPIO30 = 0x01

#define SDA_H		GpioDataRegs.GPASET.bit.GPIO30 = 1
#define SDA_L		GpioDataRegs.GPACLEAR.bit.GPIO30 = 1
#define SCL_H		GpioDataRegs.GPASET.bit.GPIO31 = 1
#define SCL_L		GpioDataRegs.GPACLEAR.bit.GPIO31 = 1

#define SDA_READ	GpioDataRegs.GPADAT.bit.GPIO30

#endif

#define IIC_WAIT	iic_delay()

void i2c_init(void);
int i2c_read_one_byte(uint8_t addr,uint8_t reg,uint8_t* data);
int i2c_read_buffer(uint8_t addr,uint8_t reg,uint8_t *data,uint32_t len);
int i2c_write_one_byte(uint8_t addr,uint8_t reg,uint8_t data);
int i2c_write_buffer(uint8_t addr,uint8_t reg, uint8_t *data,uint32_t len);

#ifdef __cplusplus
}
#endif

#endif
