/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "driverlib.h"
#include "device.h"
#include "dma_controller.h"


/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define txID(x)        (0x19 + (x))
#define rxID(x)        (0x1D + (x))

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

LIN_MasterMegsBuf masterTxMsgs[TOTAL_MSG];
#if(!LIN_ACTION)
LIN_MasterSubMegsBuf masterRxMsgs[TOTAL_MSG];
#endif

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

static void configMsgs(void)
{

    int i = 0;

    for (; i < TOTAL_MSG; i++)
    {

#if(LIN_PDCM_CONFIG)
#if(LIN_ACTION)
    	masterTxMsgs[i].mr.bit.nact = 0;
    	masterTxMsgs[i].mr.bit.pardis = 0;
    	masterTxMsgs[i].mr.bit.chkdis = 0;
    	masterTxMsgs[i].mr.bit.chktyp = 1;
    	masterTxMsgs[i].mr.bit.dlm = 0;
    	masterTxMsgs[i].mr.bit.fsdis = 0;
    	masterTxMsgs[i].mr.bit.wkuptyp = 1;
    	masterTxMsgs[i].dlc = FRAME_LENGTH - 1;
#else
    	masterTxMsgs[i].mr.bit.nact = 1;
    	masterTxMsgs[i].mr.bit.pardis = 0;
    	masterTxMsgs[i].mr.bit.chkdis = 0;
    	masterTxMsgs[i].mr.bit.chktyp = 1;
    	masterTxMsgs[i].mr.bit.dlm = 0;
    	masterTxMsgs[i].mr.bit.fsdis = 0;
    	masterTxMsgs[i].mr.bit.wkuptyp = 1;
    	masterTxMsgs[i].dlc = FRAME_LENGTH - 1;
#endif
#endif

#if(LIN_ACTION)
    	masterTxMsgs[i].identifier =  txID(i);
    	masterTxMsgs[i].Data[0] = 0x11* (i+1);
    	masterTxMsgs[i].Data[1] = 0x23;
    	masterTxMsgs[i].Data[2] = 0x45;
    	masterTxMsgs[i].Data[3] = 0x67;
    	masterTxMsgs[i].Data[4] = 0x89;
    	masterTxMsgs[i].Data[5] = 0xAB;
    	masterTxMsgs[i].Data[6] = 0xCD;
    	masterTxMsgs[i].Data[7] = 0xFE;
#else
		masterTxMsgs[i].identifier = rxID(i);

		masterRxMsgs[i].Data[0] = 0x01;
		masterRxMsgs[i].Data[1] = 0x02;
		masterRxMsgs[i].Data[2] = 0x03;
		masterRxMsgs[i].Data[3] = 0x04;
		masterRxMsgs[i].Data[4] = 0x05;
		masterRxMsgs[i].Data[5] = 0x06;
		masterRxMsgs[i].Data[6] = 0x07;
		masterRxMsgs[i].Data[7] = 0x08;

#endif

    }
}


static void configureDMAChannels(uint32_t linbase)
{
#if (IS_GS32F00xx(0x12) || IS_GS32F00xx(0x30))

#if(LIN_ACTION)
    DMA_ConfigParams txWrDmaCfg = {0};

    txWrDmaCfg.enableInterrupt = 0;
    //enable DMA Trigger by DMA MUX
#if(IS_GS32F00xx(0x30))
    txWrDmaCfg.dmaDstReqId = DMAMUX_ReqId_lin1_tx;
#else
    txWrDmaCfg.dmaDstReqId = DMAMUX_LIN_TX;
#endif

    txWrDmaCfg.srcAddr = (uint32_t)masterTxMsgs;
    txWrDmaCfg.destAddr = (uint32_t)(linbase + LIN_US_THR);
    txWrDmaCfg.blockTS = TOTAL_MSG * sizeof(LIN_MasterMegsBuf);
    txWrDmaCfg.ttfc    = DMA_TT_FC_1_M2P_DMAC;
    txWrDmaCfg.srcBtl  = DMA_BTL_1;
    txWrDmaCfg.reloadSrc = true;
    txWrDmaCfg.destBtl = DMA_BTL_1;
    txWrDmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    txWrDmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
    txWrDmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
    txWrDmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;

#if(IS_GS32F00xx(0x30))
    txWrDmaCfg.enableBlkOfst = false;
    txWrDmaCfg.blockOffset = 0;
    txWrDmaCfg.enableBlkCnt = false;
    txWrDmaCfg.blockCnt = 1;
	DMA_configChannel(DMA_CH1_BASE, &txWrDmaCfg);
#else
    DMA_configChannel(DMA1_CH1_BASE, &txWrDmaCfg);
#endif


#else
    DMA_ConfigParams rxWrDmaCfg = {0};
	DMA_ConfigParams rxRdDmaCfg = {0};

	rxWrDmaCfg.enableInterrupt = 0;
	//enable DMA Trigger by DMA MUX
#if(IS_GS32F00xx(0x30))
	rxWrDmaCfg.dmaDstReqId = DMAMUX_ReqId_lin1_tx;
#else
	rxWrDmaCfg.dmaDstReqId = DMAMUX_LIN_TX;
#endif
	rxWrDmaCfg.srcAddr = (uint32_t)masterTxMsgs;
	rxWrDmaCfg.destAddr = (uint32_t)(linbase + LIN_US_THR);
	rxWrDmaCfg.blockTS = TOTAL_MSG * sizeof(LIN_MasterMegsBuf);
	rxWrDmaCfg.ttfc    = DMA_TT_FC_1_M2P_DMAC;
	rxWrDmaCfg.srcBtl  = DMA_BTL_1;
	rxWrDmaCfg.reloadSrc = true;
	rxWrDmaCfg.destBtl = DMA_BTL_1;
	rxWrDmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
	rxWrDmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
	rxWrDmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
	rxWrDmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;

#if(IS_GS32F00xx(0x30))
	rxWrDmaCfg.enableBlkOfst = false;
	rxWrDmaCfg.blockOffset = 0;
	rxWrDmaCfg.enableBlkCnt = false;
	rxWrDmaCfg.blockCnt = 1;
	DMA_configChannel(DMA_CH2_BASE, &rxWrDmaCfg);
#else
	DMA_configChannel(DMA1_CH2_BASE, &rxWrDmaCfg);
#endif


    rxRdDmaCfg.enableInterrupt = 0;
    //enable DMA Trigger by DMA MUX

#if(IS_GS32F00xx(0x30))
    rxRdDmaCfg.dmaSrcReqId = DMAMUX_ReqId_lin1_rx;
#else
	rxRdDmaCfg.dmaSrcReqId = DMAMUX_LIN_RX;
#endif
    rxRdDmaCfg.srcAddr = (uint32_t)(linbase + LIN_US_RHR);
    rxRdDmaCfg.destAddr = (uint32_t)masterRxMsgs;
    rxRdDmaCfg.blockTS = TOTAL_MSG * sizeof(LIN_MasterSubMegsBuf);
    rxRdDmaCfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
    rxRdDmaCfg.srcBtl  = DMA_BTL_1;
    rxRdDmaCfg.reloadDst = true;
    rxRdDmaCfg.destBtl = DMA_BTL_1;
    rxRdDmaCfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
    rxRdDmaCfg.destAddrDirect = DMA_ADDR_INCRE;
    rxRdDmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
    rxRdDmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;
#if(IS_GS32F00xx(0x30))
    rxRdDmaCfg.enableBlkOfst = false;
    rxRdDmaCfg.blockOffset = 0;
    rxRdDmaCfg.enableBlkCnt = false;
    rxRdDmaCfg.blockCnt = 1;
	DMA_configChannel(DMA_CH3_BASE, &rxRdDmaCfg);
#else
	DMA_configChannel(DMA1_CH3_BASE, &rxRdDmaCfg);
#endif
#endif

#elif (IS_GS32F3xx(0x22))

#if(LIN_ACTION)
    XDMA_ConfigParams txWrDmaCfg = {0};

    txWrDmaCfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
    txWrDmaCfg.dmaDstReqId = DMAMUX_LIN_TX;
    txWrDmaCfg.srcAddr = (uint32_t)masterTxMsgs;
    txWrDmaCfg.destAddr = (uint32_t)(linbase + LIN_US_THR);
    txWrDmaCfg.blockTS = TOTAL_MSG * sizeof(LIN_MasterMegsBuf);
    txWrDmaCfg.ttfc    = XDMA_TT_FC_1_M2P_DMAC;
    txWrDmaCfg.srcBtl  = XDMA_BTL_1;
    txWrDmaCfg.reloadSrc = XDMA_RELOAD;
    txWrDmaCfg.destBtl = XDMA_BTL_1;
    txWrDmaCfg.srcAddrDirect = XDMA_ADDR_INCRE;
    txWrDmaCfg.destAddrDirect = XDMA_ADDR_NO_CHANGE;
    txWrDmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
    txWrDmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_1;
    XDMA_configChannel(DMA1_CH1_BASE, &txWrDmaCfg);
#else
    XDMA_ConfigParams rxWrDmaCfg = {0};
	XDMA_ConfigParams rxRdDmaCfg = {0};

	rxWrDmaCfg.enableInterrupt = 0;
	//enable DMA Trigger by DMA MUX
	rxWrDmaCfg.dmaDstReqId = DMAMUX_LIN_TX;
	rxWrDmaCfg.srcAddr = (uint32_t)masterTxMsgs;
	rxWrDmaCfg.destAddr = (uint32_t)(linbase + LIN_US_THR);
	rxWrDmaCfg.blockTS = TOTAL_MSG * sizeof(LIN_MasterMegsBuf);
	rxWrDmaCfg.ttfc    = XDMA_TT_FC_1_M2P_DMAC;
	rxWrDmaCfg.srcBtl  = XDMA_BTL_1;
	rxWrDmaCfg.reloadSrc = XDMA_RELOAD;
	rxWrDmaCfg.destBtl = XDMA_BTL_1;
	rxWrDmaCfg.srcAddrDirect = XDMA_ADDR_INCRE;
	rxWrDmaCfg.destAddrDirect = XDMA_ADDR_NO_CHANGE;
	rxWrDmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
	rxWrDmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_1;
	XDMA_configChannel(DMA1_CH2_BASE, &rxWrDmaCfg);

    rxRdDmaCfg.enableInterrupt = 0;
    //enable DMA Trigger by DMA MUX
    rxRdDmaCfg.dmaSrcReqId = DMAMUX_LIN_RX;
    rxRdDmaCfg.srcAddr = (uint32_t)(linbase + LIN_US_RHR);
    rxRdDmaCfg.destAddr = (uint32_t)masterRxMsgs;
    rxRdDmaCfg.blockTS = TOTAL_MSG * sizeof(LIN_MasterSubMegsBuf);
    rxRdDmaCfg.ttfc    = XDMA_TT_FC_2_P2M_DMAC;
    rxRdDmaCfg.srcBtl  = XDMA_BTL_1;
    rxRdDmaCfg.reloadDst = XDMA_RELOAD;
    rxRdDmaCfg.destBtl = XDMA_BTL_1;
    rxRdDmaCfg.srcAddrDirect = XDMA_ADDR_NO_CHANGE;
    rxRdDmaCfg.destAddrDirect = XDMA_ADDR_INCRE;
    rxRdDmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
    rxRdDmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_1;
    XDMA_configChannel(DMA1_CH3_BASE, &rxRdDmaCfg);
#endif

#endif
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

void dma_init(uint32_t linbase)
{
#if (IS_GS32F00xx(0x12))
	DMA_initController(DMA1_BASE);
#elif (IS_GS32F3xx(0x22))
	XDMA_initController(DMA1_BASE);
#elif(IS_GS32F00xx(0x30))
	DMA_initController(DMA_BASE);
#endif
	configMsgs();
	configureDMAChannels(linbase);
}

