/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef DMA_CONTROLLER_H_
#define DMA_CONTROLLER_H_

#ifdef __cplusplus
extern "C"{
#endif

#include "device.h"
#include "lin_transfer.h"


#define FRAME_LENGTH        (8U)

#if(IS_GS32F00xx(0x12))

#if(LIN_BASE == LINA_BASE)

#define DMAMUX_LIN_TX DMAMUX_ReqId_lin1_tx
#define DMAMUX_LIN_RX DMAMUX_ReqId_lin1_rx

#elif (LIN_BASE == LINB_BASE)

#define DMAMUX_LIN_TX DMAMUX_ReqId_lin2_tx
#define DMAMUX_LIN_RX DMAMUX_ReqId_lin2_rx

#endif

#elif (IS_GS32F3xx(0x22))

#if(LIN_BASE == LINA_BASE)

#define DMAMUX_LIN_TX DMAMUX_ReqId_lin1_tx
#define DMAMUX_LIN_RX DMAMUX_ReqId_lin1_rx

#elif (LIN_BASE == LINB_BASE)

#define DMAMUX_LIN_TX DMAMUX_ReqId_lin2_tx
#define DMAMUX_LIN_RX DMAMUX_ReqId_lin2_rx

#endif

#endif

typedef struct
{
	uint8_t Data[FRAME_LENGTH];
}LIN_SlaveDataBuf;



void dma_init(uint32_t linbase);

#ifdef __cplusplus
}
#endif

#endif /* DMA_CONTROLLER_H_ */
