/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __LIN_TRANSFER_H__
#define __LIN_TRANSFER_H__

#ifdef __cplusplus
extern "C"{
#endif

#include "inc/hw_types.h"
#include "inc/hw_memmap.h"

#define LIN_BASE LINA_BASE

#if (IS_GS32F00xx(0x12))

#if (LIN_BASE == LINA_BASE)

#define LIN_TX_PIN GPIO_22_LINA_TX
#define LIN_RX_PIN GPIO_23_LINA_RX

#define LIN_IRQ_NUMBER INT_LINA

#elif (LIN_BASE == LINB_BASE)

#define LIN_TX_PIN GPIO_10_LINB_TX
#define LIN_RX_PIN GPIO_9_LINB_RX

#define LIN_IRQ_NUMBER INT_LINB

#endif

#elif (IS_GS32F3xx(0x22))

#if (LIN_BASE == LINA_BASE)

#define LIN_TX_PIN GPIO_6_LINA_TX
#define LIN_RX_PIN GPIO_7_LINA_RX

#define LIN_IRQ_NUMBER INT_LINA

#elif (LIN_BASE == LINB_BASE)

#endif

#elif(IS_GS32F00xx(0x30))

#if (GS32_PART_NUM == 0x5000)

#define LIN_TX_PIN GPIO_10_LINA_TX
#define LIN_RX_PIN GPIO_11_LINA_RX

#define LIN_IRQ_NUMBER INT_LINA

#elif(GS32_PART_NUM == 0x35)


#define LIN_TX_PIN_MUX 	GpioCtrlRegs.GPAMUX1.bit.GPIO14 = (GPIO_14_LINA_TX & GPIO_MUX_MASK)
#define LIN_RX_PIN_MUX 	GpioCtrlRegs.GPAMUX1.bit.GPIO15 = (GPIO_15_LINA_RX & GPIO_MUX_MASK)

#define LIN_IRQ_NUMBER INT_LINA

#elif (GS32_PART_NUM == 0x0025)

#define LIN_TX_PIN GPIO_32_LINA_TX
#define LIN_RX_PIN GPIO_23_LINA_RX

#define LIN_IRQ_NUMBER INT_LINA

#elif (GS32_PART_NUM == 0x0039A)

#define LIN_TX_PIN GPIO_22_LINA_TX
#define LIN_RX_PIN GPIO_23_LINA_RX

#define LIN_IRQ_NUMBER INT_LINA

#endif

#endif

#define LIN_PUBLISAH		(1U)
#define LIN_SUBSCRIBE		(0U)

#define LIN_ACTION			LIN_PUBLISAH

void lin_init(void);

#ifdef __cplusplus
}
#endif

#endif
