/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "driverlib.h"
#include "device.h"
#include "dma_controller.h"


/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

uint8_t data_buffer[BUFFER_MAX_NUM] = {0};

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

static void configMsgs(void)
{
	uint8_t i = 0;

	for(i=0;i<BUFFER_MAX_NUM;i++){
		data_buffer[i] = i*2;
	}
}

static void configureDMAChannels(uint32_t linbase)
{
#if (IS_GS32F00xx(0x30))

#if(LIN_ACTION)

	DMA_ConfigParams txWrDmaCfg = {0};

	txWrDmaCfg.enableInterrupt = 0;

	txWrDmaCfg.dmaDstReqId = DMAMUX_LIN_TX;

    txWrDmaCfg.srcAddr = (uint32_t)(&data_buffer);
    txWrDmaCfg.destAddr = (uint32_t)(linbase + LIN_US_THR);
    txWrDmaCfg.blockTS = sizeof(data_buffer);
    txWrDmaCfg.ttfc    = DMA_TT_FC_1_M2P_DMAC;
    txWrDmaCfg.srcBtl  = DMA_BTL_1;
    txWrDmaCfg.reloadSrc = true;
    txWrDmaCfg.destBtl = DMA_BTL_1;
    txWrDmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    txWrDmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
    txWrDmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
    txWrDmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;

    txWrDmaCfg.enableBlkOfst = false;
    txWrDmaCfg.blockOffset = 0;
    txWrDmaCfg.enableBlkCnt = false;
    txWrDmaCfg.blockCnt = 1;

    DMA_configChannel(DMA_CH1_BASE, &txWrDmaCfg);

#else

	DMA_ConfigParams rxRdDmaCfg = {0};

	rxRdDmaCfg.enableInterrupt = 0;
	rxRdDmaCfg.dmaSrcReqId = DMAMUX_LIN_RX;
	rxRdDmaCfg.srcAddr = (uint32_t)(linbase + LIN_US_RHR);
	rxRdDmaCfg.destAddr = (uint32_t)data_buffer;
	rxRdDmaCfg.blockTS = sizeof(data_buffer);
	rxRdDmaCfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
	rxRdDmaCfg.srcBtl  = DMA_BTL_1;
	rxRdDmaCfg.reloadDst = true;
	rxRdDmaCfg.destBtl = DMA_BTL_1;
	rxRdDmaCfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
	rxRdDmaCfg.destAddrDirect = DMA_ADDR_INCRE;
	rxRdDmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
	rxRdDmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;

    rxRdDmaCfg.enableBlkOfst = false;
    rxRdDmaCfg.blockOffset = 0;
    rxRdDmaCfg.enableBlkCnt = false;
    rxRdDmaCfg.blockCnt = 1;
	DMA_configChannel(DMA_CH1_BASE, &rxRdDmaCfg);

#endif

#elif(IS_GS32F3xx(0x22))

#if(LIN_ACTION)

	XDMA_ConfigParams txWrDmaCfg = {0};

    txWrDmaCfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
    txWrDmaCfg.dmaDstReqId = DMAMUX_LIN_TX;
    txWrDmaCfg.srcAddr = (uint32_t)data_buffer;
    txWrDmaCfg.destAddr = (uint32_t)(linbase + LIN_US_THR);
    txWrDmaCfg.blockTS = sizeof(data_buffer);
    txWrDmaCfg.ttfc    = XDMA_TT_FC_1_M2P_DMAC;
    txWrDmaCfg.srcBtl  = XDMA_BTL_1;
    txWrDmaCfg.reloadSrc = XDMA_RELOAD;
    txWrDmaCfg.destBtl = XDMA_BTL_1;
    txWrDmaCfg.srcAddrDirect = XDMA_ADDR_INCRE;
    txWrDmaCfg.destAddrDirect = XDMA_ADDR_NO_CHANGE;
    txWrDmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
    txWrDmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_1;
    XDMA_configChannel(DMA1_CH1_BASE, &txWrDmaCfg);

#else

    XDMA_ConfigParams rxRdDmaCfg = {0};

    rxRdDmaCfg.enableInterrupt = 0;
    //enable DMA Trigger by DMA MUX
    rxRdDmaCfg.dmaSrcReqId = DMAMUX_LIN_RX;
    rxRdDmaCfg.srcAddr = (uint32_t)(linbase + LIN_US_RHR);
    rxRdDmaCfg.destAddr = (uint32_t)data_buffer;
    rxRdDmaCfg.blockTS = sizeof(data_buffer);
    rxRdDmaCfg.ttfc    = XDMA_TT_FC_2_P2M_DMAC;
    rxRdDmaCfg.srcBtl  = XDMA_BTL_1;
    rxRdDmaCfg.reloadDst = XDMA_RELOAD;
    rxRdDmaCfg.destBtl = XDMA_BTL_1;
    rxRdDmaCfg.srcAddrDirect = XDMA_ADDR_NO_CHANGE;
    rxRdDmaCfg.destAddrDirect = XDMA_ADDR_INCRE;
    rxRdDmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
    rxRdDmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_1;
    XDMA_configChannel(DMA1_CH1_BASE, &rxRdDmaCfg);

#endif


#elif(IS_GS32F00xx(0x12))

#if(LIN_ACTION)

    DMA_ConfigParams txWrDmaCfg = {0};

    txWrDmaCfg.enableInterrupt = 0;
    txWrDmaCfg.dmaDstReqId = DMAMUX_LIN_TX;
    txWrDmaCfg.srcAddr = (uint32_t)data_buffer;
	txWrDmaCfg.destAddr = (uint32_t)(linbase + LIN_US_THR);
	txWrDmaCfg.blockTS = sizeof(data_buffer);
	txWrDmaCfg.ttfc    = DMA_TT_FC_1_M2P_DMAC;
	txWrDmaCfg.srcBtl  = DMA_BTL_1;
	txWrDmaCfg.reloadSrc = true;
	txWrDmaCfg.destBtl = DMA_BTL_1;
	txWrDmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
	txWrDmaCfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
	txWrDmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
	txWrDmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;

	DMA_configChannel(DMA_CH1_BASE, &txWrDmaCfg);

#else

	DMA_ConfigParams rxRdDmaCfg = {0};

	rxRdDmaCfg.enableInterrupt = 0;
	rxRdDmaCfg.dmaSrcReqId = DMAMUX_LIN_RX;
    rxRdDmaCfg.srcAddr = (uint32_t)(linbase + LIN_US_RHR);
    rxRdDmaCfg.destAddr = (uint32_t)data_buffer;
    rxRdDmaCfg.blockTS = sizeof(data_buffer);
    rxRdDmaCfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
    rxRdDmaCfg.srcBtl  = DMA_BTL_1;
    rxRdDmaCfg.reloadDst = true;
    rxRdDmaCfg.destBtl = DMA_BTL_1;
    rxRdDmaCfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
    rxRdDmaCfg.destAddrDirect = DMA_ADDR_INCRE;
    rxRdDmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
    rxRdDmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;

    DMA_configChannel(DMA_CH1_BASE, &rxRdDmaCfg);

#endif

#endif


}


/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

void dma_init(uint32_t linbase)
{
#if (IS_GS32F00xx(0x12))
	DMA_initController(DMA1_BASE);
#elif (IS_GS32F3xx(0x22))
	XDMA_initController(DMA1_BASE);
#elif(IS_GS32F00xx(0x30))
	DMA_initController(DMA_BASE);
#endif
#if(LIN_ACTION)
	configMsgs();
#endif
	configureDMAChannels(linbase);
}

