
#include "device.h"
#include "driverlib.h"
#include "load_img.h"
#include "log.h" //smp thread safe
#include "board_cfg.h"


int16_t  filter1Result[2048] = { [0 ... 2047 ]  = 0x5a};
uint16_t AFCount = 0;
int sampleFinish = 0;

void sdfm1_DR1_ISR()
{
    if(Sdfm1Regs.SDIFLG.bit.AF1 == 1)
    {
        filter1Result[AFCount++] = Sdfm1Regs.SDDATA1.all >> 16U;
        Sdfm1Regs.SDIFLGCLR.bit.AF1 = 1;
    }
    if (AFCount == 2048)
    {
        sampleFinish = 1;
    }
    
}

int main()
{
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);
    log_set_level(LOG_INFO);
    log_info("print ok \r\n");

    GPIO_setPinConfig(GPIO_17_SD1_C1);
    GPIO_setPadConfig(17, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(17, GPIO_QUAL_ASYNC);

    GPIO_setPinConfig(GPIO_16_SD1_D1);
    GPIO_setPadConfig(16, GPIO_PIN_TYPE_STD);
    GPIO_setQualificationMode(16, GPIO_QUAL_ASYNC);

    SysCtl_configureType(1);
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_SDFM);

    // Comparator parameter
    Sdfm1Regs.SDCPARM1.bit.CS1_CS0 = 3;
    Sdfm1Regs.SDCPARM1.bit.COSR = 32 - 1;

    // Data filter parameter
    Sdfm1Regs.SDDFPARM1.all |= 128 - 1;
//    Sdfm1Regs.SDDFPARM1.bit.DOSR = 128 - 1;  unsupport store byte command
    Sdfm1Regs.SDDFPARM1.bit.SST = 3;
    Sdfm1Regs.SDDFPARM1.bit.FEN = 1;
    Sdfm1Regs.SDDFPARM1.bit.AE = 1;

    // Data parameter
    Sdfm1Regs.SDDPARM1.bit.DR = 0;
    Sdfm1Regs.SDDPARM1.bit.SH = 7;

    Sdfm1Regs.SDCTLPARM1.bit.MOD = SDFM_MODULATOR_CLK_EQUAL_DATA_RATE;
    Sdfm1Regs.SDCTLPARM1.bit.SDCLKSEL = 1;
    Sdfm1Regs.SDFLT1CMPH1.bit.HLT = 0x7fff;
    Sdfm1Regs.SDFLT1CMPL1.bit.LLT = 0;
    Sdfm1Regs.SDMFILEN.bit.MFE = 1;
    Sdfm1Regs.SDCTL.bit.MIE = 1;


    Interrupt_register(INT_SDFM1DR1, sdfm1_DR1_ISR);
    Interrupt_enable(INT_SDFM1DR1);

    __enable_irq();
    while (1)
    {
    }

    return 0;
}
