
#include "sdfm_ex3_filter_sync_dmaread_board.h"
#include "sdfm.h"
// SDFM1 SD1_C1 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C1 17
#define mySDFM1_SDFM1C1_GPIO 17
#define mySDFM1_SDFM1C1_PIN_CONFIG GPIO_17_SD1_C1
//
// SDFM1 SD1_D1 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D1 16
#define mySDFM1_SDFM1D1_GPIO 16
#define mySDFM1_SDFM1D1_PIN_CONFIG GPIO_16_SD1_D1


// SDFM1 SD1_C2 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C2 19
#define mySDFM1_SDFM1C2_GPIO 19
#define mySDFM1_SDFM1C2_PIN_CONFIG GPIO_19_SD1_C2
//
// SDFM1 SD1_D2 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D2 18
#define mySDFM1_SDFM1D2_GPIO 18
#define mySDFM1_SDFM1D2_PIN_CONFIG GPIO_18_SD1_D2


//
// SDFM1 SD1_C3 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C3 53
#define mySDFM1_SDFM1C3_GPIO 53
#define mySDFM1_SDFM1C3_PIN_CONFIG GPIO_53_SD1_C3
//
// SDFM1 SD1_D3 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D3 52
#define mySDFM1_SDFM1D3_GPIO 52
#define mySDFM1_SDFM1D3_PIN_CONFIG GPIO_52_SD1_D3

//
// SDFM1 SD1_C4 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C4 55
#define mySDFM1_SDFM1C4_GPIO 55
#define mySDFM1_SDFM1C4_PIN_CONFIG GPIO_55_SD1_C4

//
// SDFM1 SD1_D4 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D4 22
#define mySDFM1_SDFM1D4_GPIO 22
#define mySDFM1_SDFM1D4_PIN_CONFIG GPIO_22_SD1_D4

#define RESULTS_BUFFER_SIZE     (512)
#define CHECK_SIZE              (32)

uint16_t mySD1Filter1DataBuffer[RESULTS_BUFFER_SIZE + CHECK_SIZE];
uint16_t mySD1Filter2DataBuffer[RESULTS_BUFFER_SIZE + CHECK_SIZE];
uint16_t mySD1Filter3DataBuffer[RESULTS_BUFFER_SIZE + CHECK_SIZE];
uint16_t mySD1Filter4DataBuffer[RESULTS_BUFFER_SIZE + CHECK_SIZE];




void Board_init(void){
	PinMux_init();
	DMA_init();
	sdfm_init();

}
void PinMux_init()
{

	// SDFM1 Pin Mux
	//SDFM1 SD1_C1 _GP17
	GPIO_setPinConfig(mySDFM1_SDFM1C1_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C1_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C1_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C1_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D1 _GP16
	GPIO_setPinConfig(mySDFM1_SDFM1D1_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D1_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D1_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D1_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_C2 _GP19
	GPIO_setPinConfig(mySDFM1_SDFM1C2_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C2_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C2_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C2_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D2 _GP18
	GPIO_setPinConfig(mySDFM1_SDFM1D2_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D2_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D2_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D2_GPIO, GPIO_QUAL_ASYNC);


	//SDFM1 SD1_C3 _GP53
	GPIO_setPinConfig(mySDFM1_SDFM1C3_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C3_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C3_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C3_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D3 _GP52
	GPIO_setPinConfig(mySDFM1_SDFM1D3_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D3_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D3_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D3_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_C4 _GP55
	GPIO_setPinConfig(mySDFM1_SDFM1C4_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C4_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C4_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C4_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D4 _GP22
	GPIO_setPinConfig(mySDFM1_SDFM1D4_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D4_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D4_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D4_GPIO, GPIO_QUAL_ASYNC);
}

void sdfm_init(void){

    uint16_t  hlt, llt;


    //
    // Configure SDFM type to 0 and see if data ack generated SDINT.
    //
	SysCtl_configureType(0);


    //
    // Input Control Unit
    //
    // Configure Input Control Unit: Modulator Clock rate = Modulator data rate
    //
    SDFM_setupModulatorClock(SDFM1_BASE, SDFM_FILTER_1,SDFM_MODULATOR_CLK_EQUAL_DATA_RATE);
    SDFM_setupModulatorClock(SDFM1_BASE, SDFM_FILTER_2,SDFM_MODULATOR_CLK_EQUAL_DATA_RATE);
    SDFM_setupModulatorClock(SDFM1_BASE, SDFM_FILTER_3,SDFM_MODULATOR_CLK_EQUAL_DATA_RATE);
    SDFM_setupModulatorClock(SDFM1_BASE, SDFM_FILTER_4,SDFM_MODULATOR_CLK_EQUAL_DATA_RATE);

    //
    // Comparator Unit - over and under value threshold settings
    //
    hlt = 0x7FFF;
    llt = 0x0000;

    //
    // Configure Comparator Unit's comparator filter type and comparator's
    // OSR value, higher threshold, lower threshold
    //
    SDFM_configComparator(SDFM1_BASE,
        (SDFM_FILTER_1 | SDFM_FILTER_SINC_3 | SDFM_SET_OSR(32)),
        (SDFM_GET_LOW_THRESHOLD(llt) | SDFM_GET_HIGH_THRESHOLD(hlt)), 0);
    SDFM_configComparator(SDFM1_BASE,
        (SDFM_FILTER_2 | SDFM_FILTER_SINC_3 | SDFM_SET_OSR(32)),
        (SDFM_GET_LOW_THRESHOLD(llt) | SDFM_GET_HIGH_THRESHOLD(hlt)), 0);
    SDFM_configComparator(SDFM1_BASE,
        (SDFM_FILTER_3 | SDFM_FILTER_SINC_3 | SDFM_SET_OSR(32)),
        (SDFM_GET_LOW_THRESHOLD(llt) | SDFM_GET_HIGH_THRESHOLD(hlt)), 0);
    SDFM_configComparator(SDFM1_BASE,
        (SDFM_FILTER_4 | SDFM_FILTER_SINC_3 | SDFM_SET_OSR(32)),
        (SDFM_GET_LOW_THRESHOLD(llt) | SDFM_GET_HIGH_THRESHOLD(hlt)), 0);


    //
    // Data filter Module
    //
    // Configure Data filter modules filter type, OSR value and
    // enable / disable data filter
    //
//    SDFM_configDataFilter(SDFM1_BASE, (SDFM_FILTER_1 | SDFM_FILTER_SINC_3 |
//           SDFM_SET_OSR(256)), (SDFM_DATA_FORMAT_16_BIT | SDFM_FILTER_ENABLE |
//           SDFM_SHIFT_VALUE(0x000A)));
//
//    SDFM_configDataFilter(SDFM1_BASE, (SDFM_FILTER_2 | SDFM_FILTER_SINC_3 |
//           SDFM_SET_OSR(256)), (SDFM_DATA_FORMAT_16_BIT | SDFM_FILTER_ENABLE |
//           SDFM_SHIFT_VALUE(0x000A)));
//
//    SDFM_configDataFilter(SDFM1_BASE, (SDFM_FILTER_3 | SDFM_FILTER_SINC_3 |
//           SDFM_SET_OSR(256)), (SDFM_DATA_FORMAT_16_BIT | SDFM_FILTER_ENABLE |
//           SDFM_SHIFT_VALUE(0x000A)));
//
//    SDFM_configDataFilter(SDFM1_BASE, (SDFM_FILTER_4 | SDFM_FILTER_SINC_3 |
//           SDFM_SET_OSR(256)), (SDFM_DATA_FORMAT_16_BIT | SDFM_FILTER_ENABLE |
//           SDFM_SHIFT_VALUE(0x000A)));
    SDFM_configDataFilter(SDFM1_BASE, (SDFM_FILTER_1 | SDFM_FILTER_SINC_3 |
           SDFM_SET_OSR(128)), (SDFM_DATA_FORMAT_16_BIT | SDFM_FILTER_ENABLE |
           SDFM_SHIFT_VALUE(7)));

    SDFM_configDataFilter(SDFM1_BASE, (SDFM_FILTER_2 | SDFM_FILTER_SINC_3 |
           SDFM_SET_OSR(128)), (SDFM_DATA_FORMAT_16_BIT | SDFM_FILTER_ENABLE |
           SDFM_SHIFT_VALUE(7)));

    SDFM_configDataFilter(SDFM1_BASE, (SDFM_FILTER_3 | SDFM_FILTER_SINC_3 |
           SDFM_SET_OSR(128)), (SDFM_DATA_FORMAT_16_BIT | SDFM_FILTER_ENABLE |
           SDFM_SHIFT_VALUE(7)));

    SDFM_configDataFilter(SDFM1_BASE, (SDFM_FILTER_4 | SDFM_FILTER_SINC_3 |
           SDFM_SET_OSR(128)), (SDFM_DATA_FORMAT_16_BIT | SDFM_FILTER_ENABLE |
           SDFM_SHIFT_VALUE(7)));

    //
    // Enable Master filter bit: Unless this bit is set none of the filter modules
    // can be enabled. All the filter modules are synchronized when master filter
    // bit is enabled after individual filter modules are enabled.
    //
    SDFM_enableMainFilter(SDFM1_BASE);

    SDFM_disableExternalReset(SDFM1_BASE, SDFM_FILTER_1);
    SDFM_disableExternalReset(SDFM1_BASE, SDFM_FILTER_2);
    SDFM_disableExternalReset(SDFM1_BASE, SDFM_FILTER_3);
    SDFM_disableExternalReset(SDFM1_BASE, SDFM_FILTER_4);


    //
    // Enable interrupts
    //
    // Following SDFM interrupts can be enabled / disabled using this function.
    // Enable / disable comparator high threshold
    // Enable / disable comparator low threshold
    // Enable / disable modulator clock failure
    // Enable / disable data filter acknowledge
    //
    SDFM_enableInterrupt(SDFM1_BASE, SDFM_FILTER_1,
            (SDFM_MODULATOR_FAILURE_INTERRUPT |
             SDFM_DATA_FILTER_ACKNOWLEDGE_INTERRUPT));

    SDFM_enableInterrupt(SDFM1_BASE, SDFM_FILTER_2,
            (SDFM_MODULATOR_FAILURE_INTERRUPT |
             SDFM_DATA_FILTER_ACKNOWLEDGE_INTERRUPT));

    SDFM_enableInterrupt(SDFM1_BASE, SDFM_FILTER_3,
            (SDFM_MODULATOR_FAILURE_INTERRUPT |
             SDFM_DATA_FILTER_ACKNOWLEDGE_INTERRUPT));

    SDFM_enableInterrupt(SDFM1_BASE, SDFM_FILTER_4,
            (SDFM_MODULATOR_FAILURE_INTERRUPT |
             SDFM_DATA_FILTER_ACKNOWLEDGE_INTERRUPT));

    SDFM_disableInterrupt(SDFM1_BASE, SDFM_FILTER_1,
            (SDFM_HIGH_LEVEL_THRESHOLD_INTERRUPT |
             SDFM_LOW_LEVEL_THRESHOLD_INTERRUPT));

    SDFM_disableInterrupt(SDFM1_BASE, SDFM_FILTER_2,
            (SDFM_HIGH_LEVEL_THRESHOLD_INTERRUPT |
             SDFM_LOW_LEVEL_THRESHOLD_INTERRUPT));

    SDFM_disableInterrupt(SDFM1_BASE, SDFM_FILTER_3,
            (SDFM_HIGH_LEVEL_THRESHOLD_INTERRUPT |
             SDFM_LOW_LEVEL_THRESHOLD_INTERRUPT));

    SDFM_disableInterrupt(SDFM1_BASE, SDFM_FILTER_4,
            (SDFM_HIGH_LEVEL_THRESHOLD_INTERRUPT |
             SDFM_LOW_LEVEL_THRESHOLD_INTERRUPT));
    SDFM_disableInterrupt(SDFM1_BASE, SDFM_FILTER_1,SDFM_MODULATOR_FAILURE_INTERRUPT);
    SDFM_disableInterrupt(SDFM1_BASE, SDFM_FILTER_2,SDFM_MODULATOR_FAILURE_INTERRUPT);
    SDFM_disableInterrupt(SDFM1_BASE, SDFM_FILTER_3,SDFM_MODULATOR_FAILURE_INTERRUPT);
    SDFM_disableInterrupt(SDFM1_BASE, SDFM_FILTER_4,SDFM_MODULATOR_FAILURE_INTERRUPT);

    //
    // Enable master interrupt so that any of the filter interrupts can trigger
    // by SDFM interrupt to CPU
    //
    SDFM_enableMainInterrupt(SDFM1_BASE);
}
#if IS_GS32F00xx(0x12)
void DMA_init()
{
    //
    // Perform a hard reset on DMA
    //
    DMA_initController(DMA1_BASE);



    DMA_ConfigParams dmaCfg = {0};
    dmaCfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt1;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA1 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter1DataBuffer;
    dmaCfg.blockTS = 512;
    dmaCfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.reloadSrc = false;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
    dmaCfg.destAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_2;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_2;

    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);
    DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_TFR);



    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt2;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA2 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter2DataBuffer;
    DMA_configChannel(DMA_CH2_BASE, &dmaCfg);
    DMA_clearInterrupt(DMA_CH2_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH2_BASE, DMA_INT_TFR);


    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt3;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA3 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter3DataBuffer;
    DMA_configChannel(DMA_CH3_BASE, &dmaCfg);
    DMA_clearInterrupt(DMA_CH3_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH3_BASE, DMA_INT_TFR);

    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt4;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA4 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter4DataBuffer;
    DMA_configChannel(DMA_CH4_BASE, &dmaCfg);
    DMA_clearInterrupt(DMA_CH4_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH4_BASE, DMA_INT_TFR);


    DMA_startChannel(DMA_CH1_BASE);
    DMA_startChannel(DMA_CH2_BASE);
    DMA_startChannel(DMA_CH3_BASE);
    DMA_startChannel(DMA_CH4_BASE);
}

#elif IS_GS32F3xx(0x22)
void DMA_init()
{
    //
    // Perform a hard reset on DMA
    //
    XDMA_initController(DMA1_BASE);
    XDMA_enableInterrupt(DMA1_BASE);


    XDMA_ConfigParams dmaCfg = {0};
    dmaCfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt1;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA1 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter1DataBuffer;
    dmaCfg.blockTS = 512;
    dmaCfg.ttfc    = XDMA_TT_FC_2_P2M_DMAC;
    dmaCfg.srcBtl  = XDMA_BTL_1;
    dmaCfg.reloadSrc = false;
    dmaCfg.destBtl = XDMA_BTL_1;
    dmaCfg.srcAddrDirect = XDMA_ADDR_NO_CHANGE;
    dmaCfg.destAddrDirect = XDMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_2;
    dmaCfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_2;

    XDMA_configChannel(DMA1_CH1_BASE, &dmaCfg);
    XDMA_clearInterrupt(DMA1_CH1_BASE, XDMA_INT_TFR);
    XDMA_unMaskInterrupt(DMA1_CH1_BASE, XDMA_INT_TFR);



    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt2;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA2 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter2DataBuffer;
    XDMA_configChannel(DMA1_CH2_BASE, &dmaCfg);
    XDMA_clearInterrupt(DMA1_CH2_BASE, XDMA_INT_TFR);
    XDMA_unMaskInterrupt(DMA1_CH2_BASE, XDMA_INT_TFR);



    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt3;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA3 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter3DataBuffer;
    XDMA_configChannel(DMA1_CH3_BASE, &dmaCfg);
    XDMA_clearInterrupt(DMA1_CH3_BASE, XDMA_INT_TFR);
    XDMA_unMaskInterrupt(DMA1_CH3_BASE, XDMA_INT_TFR);

    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt4;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA4 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter4DataBuffer;
    XDMA_configChannel(DMA1_CH4_BASE, &dmaCfg);
    XDMA_clearInterrupt(DMA1_CH4_BASE, XDMA_INT_TFR);
    XDMA_unMaskInterrupt(DMA1_CH4_BASE, XDMA_INT_TFR);



    XDMA_startChannel(DMA1_CH1_BASE);
    XDMA_startChannel(DMA1_CH2_BASE);
    XDMA_startChannel(DMA1_CH3_BASE);
    XDMA_startChannel(DMA1_CH4_BASE);
}
#elif IS_GS32F00xx(0x30)
void DMA_init()
{
    //
    // Perform a hard reset on DMA
    //
    DMA_initController(DMA_BASE);



    DMA_ConfigParams dmaCfg = {0};
    dmaCfg.enableInterrupt = 1;
    //enable DMA Trigger by DMA MUX
    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt1;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA1 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter1DataBuffer;
    dmaCfg.blockTS = 512;
    dmaCfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_1;
    dmaCfg.reloadSrc = false;
    dmaCfg.destBtl = DMA_BTL_1;
    dmaCfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
    dmaCfg.destAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_2;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_2;

    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);
    DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_TFR);



    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt2;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA2 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter2DataBuffer;
    DMA_configChannel(DMA_CH2_BASE, &dmaCfg);
    DMA_clearInterrupt(DMA_CH2_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH2_BASE, DMA_INT_TFR);


    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt3;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA3 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter3DataBuffer;
    DMA_configChannel(DMA_CH3_BASE, &dmaCfg);
    DMA_clearInterrupt(DMA_CH3_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH3_BASE, DMA_INT_TFR);

    dmaCfg.dmaSrcReqId = DMAMUX_ReqId_sd1_flt4;
    dmaCfg.srcAddr = (uint32_t)(SDFM1_BASE  + SDFM_O_SDDATA4 + 0x2);// read high 16bit
    dmaCfg.destAddr = (uint32_t)mySD1Filter4DataBuffer;
    DMA_configChannel(DMA_CH4_BASE, &dmaCfg);
    DMA_clearInterrupt(DMA_CH4_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH4_BASE, DMA_INT_TFR);


    DMA_startChannel(DMA_CH1_BASE);
    DMA_startChannel(DMA_CH2_BASE);
    DMA_startChannel(DMA_CH3_BASE);
    DMA_startChannel(DMA_CH4_BASE);
}
#endif



