#include "sdfm_ex4_pwm_sync_cpuread_board.h"
#include "sdfm.h"
#include "board_cfg.h"

//
// Defines
//
#define MAX_SAMPLES               1024
#define SDFM_PIN_MUX_OPTION1      1
#define SDFM_PIN_MUX_OPTION2      2
#define EPWM_TIMER_TBPRD          65535  // ePWM Period register
#define SDFM_INT_MASK             0x8000F000U

//
// Globals
//
uint32_t sdfmInstance;
uint32_t pwmInstance = EPWM1_BASE; // ePWM 11 for synchronizing SDFM1 filters



// SDFM1 SD1_C1 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C1 17
#define mySDFM1_SDFM1C1_GPIO 17
#define mySDFM1_SDFM1C1_PIN_CONFIG GPIO_17_SD1_C1
//
// SDFM1 SD1_D1 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D1 16
#define mySDFM1_SDFM1D1_GPIO 16
#define mySDFM1_SDFM1D1_PIN_CONFIG GPIO_16_SD1_D1


// SDFM1 SD1_C2 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C2 19
#define mySDFM1_SDFM1C2_GPIO 19
#define mySDFM1_SDFM1C2_PIN_CONFIG GPIO_19_SD1_C2
//
// SDFM1 SD1_D2 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D2 18
#define mySDFM1_SDFM1D2_GPIO 18
#define mySDFM1_SDFM1D2_PIN_CONFIG GPIO_18_SD1_D2


//
// SDFM1 SD1_C3 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C3 53
#define mySDFM1_SDFM1C3_GPIO 53
#define mySDFM1_SDFM1C3_PIN_CONFIG GPIO_53_SD1_C3
//
// SDFM1 SD1_D3 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D3 52
#define mySDFM1_SDFM1D3_GPIO 52
#define mySDFM1_SDFM1D3_PIN_CONFIG GPIO_52_SD1_D3

//
// SDFM1 SD1_C4 - GPIO Settings
//
#define GPIO_PIN_SDFM1_C4 55
#define mySDFM1_SDFM1C4_GPIO 55
#define mySDFM1_SDFM1C4_PIN_CONFIG GPIO_55_SD1_C4

//
// SDFM1 SD1_D4 - GPIO Settings
//
#define GPIO_PIN_SDFM1_D4 22
#define mySDFM1_SDFM1D4_GPIO 22
#define mySDFM1_SDFM1D4_PIN_CONFIG GPIO_22_SD1_D4



void Board_init(void){
	PinMux_init();
	sdfm_init();
}
void PinMux_init()
{

	// SDFM1 Pin Mux
	//SDFM1 SD1_C1 _GP17
	GPIO_setPinConfig(mySDFM1_SDFM1C1_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C1_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C1_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C1_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D1 _GP16
	GPIO_setPinConfig(mySDFM1_SDFM1D1_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D1_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D1_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D1_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_C2 _GP19
	GPIO_setPinConfig(mySDFM1_SDFM1C2_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C2_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C2_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C2_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D2 _GP18
	GPIO_setPinConfig(mySDFM1_SDFM1D2_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D2_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D2_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D2_GPIO, GPIO_QUAL_ASYNC);


	//SDFM1 SD1_C3 _GP53
	GPIO_setPinConfig(mySDFM1_SDFM1C3_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C3_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C3_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C3_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D3 _GP52
	GPIO_setPinConfig(mySDFM1_SDFM1D3_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D3_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D3_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D3_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_C4 _GP55
	GPIO_setPinConfig(mySDFM1_SDFM1C4_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1C4_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1C4_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1C4_GPIO, GPIO_QUAL_ASYNC);

	//SDFM1 SD1_D4 _GP22
	GPIO_setPinConfig(mySDFM1_SDFM1D4_PIN_CONFIG);
	GPIO_setPadConfig(mySDFM1_SDFM1D4_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setDirectionMode(mySDFM1_SDFM1D4_GPIO, GPIO_DIR_MODE_IN);
	GPIO_setQualificationMode(mySDFM1_SDFM1D4_GPIO, GPIO_QUAL_ASYNC);


}
//
// initEPWM - Initialize specified EPWM settings
//

EPWM_SignalParams pwmSignal =
            {1000, 0.5f, 0.5f, true, DEVICE_SYSCLK_FREQ,
            EPWM_COUNTER_MODE_UP_DOWN, EPWM_CLOCK_DIVIDER_1,
            EPWM_HSCLOCK_DIVIDER_1};

//
// EPWM1 -> myEPWM1 Pinmux
//
//
// EPWM1_A - GPIO Settings
//
#define GPIO_PIN_EPWM1_A 0
#define myEPWM1_EPWMA_GPIO 0
#define myEPWM1_EPWMA_PIN_CONFIG GPIO_0_EPWM1_A
//
// EPWM1_B - GPIO Settings
//
#define GPIO_PIN_EPWM1_B 1
#define myEPWM1_EPWMB_GPIO 1
#define myEPWM1_EPWMB_PIN_CONFIG GPIO_1_EPWM1_B

void initEPWM(uint32_t epwmInstance)
{
	//
	// EPWM1 -> myEPWM1 Pinmux
	//
	GPIO_setPinConfig(myEPWM1_EPWMA_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMA_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMA_GPIO, GPIO_QUAL_SYNC);

	GPIO_setPinConfig(myEPWM1_EPWMB_PIN_CONFIG);
	GPIO_setPadConfig(myEPWM1_EPWMB_GPIO, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(myEPWM1_EPWMB_GPIO, GPIO_QUAL_SYNC);
	EPWM_configureSignal(epwmInstance, &pwmSignal);


	EPWM_enableADCTrigger(epwmInstance, EPWM_SOC_A);
	EPWM_setADCTriggerSource(epwmInstance, EPWM_SOC_A, EPWM_SOC_TBCTR_ZERO);
	EPWM_setADCTriggerEventPrescale(epwmInstance, EPWM_SOC_A, 1);
	EPWM_clearADCTriggerFlag(epwmInstance,EPWM_SOC_A);

    //
    // Enable sync and clock to PWM
    //
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_TBCLKSYNC);
}
void sdfm_init(void){

	uint16_t  pinMuxOption;
    uint16_t  hlt, llt;


    //
    // Configure SDFM type to 0 and see if data ack generated SDINT.
    //
	SysCtl_configureType(0);
	pinMuxOption = SDFM_PIN_MUX_OPTION1;

    //
    // Select SDFM1
    //
    sdfmInstance = SDFM1_BASE;

    //
    // Input Control Unit
    //
    // Configure Input Control Unit: Modulator Clock rate = Modulator data rate
    //
    SDFM_setupModulatorClock(sdfmInstance, SDFM_FILTER_1,SDFM_MODULATOR_CLK_EQUAL_DATA_RATE);
    SDFM_setupModulatorClock(sdfmInstance, SDFM_FILTER_2,SDFM_MODULATOR_CLK_EQUAL_DATA_RATE);
    SDFM_setupModulatorClock(sdfmInstance, SDFM_FILTER_3,SDFM_MODULATOR_CLK_EQUAL_DATA_RATE);
    SDFM_setupModulatorClock(sdfmInstance, SDFM_FILTER_4,SDFM_MODULATOR_CLK_EQUAL_DATA_RATE);

    //
    // Comparator Unit - over and under value threshold settings
    //
    hlt = 0x7FFF;
    llt = 0x0000;

    //
    // Configure Comparator Unit's comparator filter type and comparator's
    // OSR value, higher threshold, lower threshold
    //
    SDFM_configComparator(sdfmInstance,
        (SDFM_FILTER_1 | SDFM_FILTER_SINC_3 | SDFM_SET_OSR(32)),
        (SDFM_GET_LOW_THRESHOLD(llt) | SDFM_GET_HIGH_THRESHOLD(hlt)), 0);
    SDFM_configComparator(sdfmInstance,
        (SDFM_FILTER_2 | SDFM_FILTER_SINC_3 | SDFM_SET_OSR(32)),
        (SDFM_GET_LOW_THRESHOLD(llt) | SDFM_GET_HIGH_THRESHOLD(hlt)), 0);
    SDFM_configComparator(sdfmInstance,
        (SDFM_FILTER_3 | SDFM_FILTER_SINC_3 | SDFM_SET_OSR(32)),
        (SDFM_GET_LOW_THRESHOLD(llt) | SDFM_GET_HIGH_THRESHOLD(hlt)), 0);
    SDFM_configComparator(sdfmInstance,
        (SDFM_FILTER_4 | SDFM_FILTER_SINC_3 | SDFM_SET_OSR(32)),
        (SDFM_GET_LOW_THRESHOLD(llt) | SDFM_GET_HIGH_THRESHOLD(hlt)), 0);


    //
    // Data filter Module
    //
    // Configure Data filter modules filter type, OSR value and
    // enable / disable data filter
    //
    SDFM_configDataFilter(sdfmInstance, (SDFM_FILTER_1 | SDFM_FILTER_SINC_3 |
           SDFM_SET_OSR(256)), (SDFM_DATA_FORMAT_16_BIT | SDFM_FILTER_ENABLE |
           SDFM_SHIFT_VALUE(0x000A)));

    SDFM_configDataFilter(sdfmInstance, (SDFM_FILTER_2 | SDFM_FILTER_SINC_3 |
           SDFM_SET_OSR(256)), (SDFM_DATA_FORMAT_16_BIT | SDFM_FILTER_ENABLE |
           SDFM_SHIFT_VALUE(0x000A)));

    SDFM_configDataFilter(sdfmInstance, (SDFM_FILTER_3 | SDFM_FILTER_SINC_3 |
           SDFM_SET_OSR(256)), (SDFM_DATA_FORMAT_16_BIT | SDFM_FILTER_ENABLE |
           SDFM_SHIFT_VALUE(0x000A)));

    SDFM_configDataFilter(sdfmInstance, (SDFM_FILTER_4 | SDFM_FILTER_SINC_3 |
           SDFM_SET_OSR(256)), (SDFM_DATA_FORMAT_16_BIT | SDFM_FILTER_ENABLE |
           SDFM_SHIFT_VALUE(0x000A)));


    //
    // Enable Master filter bit: Unless this bit is set none of the filter modules
    // can be enabled. All the filter modules are synchronized when master filter
    // bit is enabled after individual filter modules are enabled.
    //
    SDFM_enableMainFilter(sdfmInstance);


    SDFM_enableExternalReset(sdfmInstance, SDFM_FILTER_1);
    SDFM_enableExternalReset(sdfmInstance, SDFM_FILTER_2);
    SDFM_enableExternalReset(sdfmInstance, SDFM_FILTER_3);
    SDFM_enableExternalReset(sdfmInstance, SDFM_FILTER_4);

	SDFM_setPWMSyncSource(sdfmInstance, SDFM_FILTER_1, SDFM_SYNC_PWM1_SOCA);

    //
    // Init EPWMs
    //
    initEPWM(pwmInstance);

    //
    // Enable interrupts
    //
    // Following SDFM interrupts can be enabled / disabled using this function.
    //  Enable / disable comparator high threshold
    //  Enable / disable comparator low threshold
    //  Enable / disable modulator clock failure
    //  Enable / disable filter acknowledge
    //
    SDFM_enableInterrupt(sdfmInstance, SDFM_FILTER_1,
            (SDFM_MODULATOR_FAILURE_INTERRUPT |
             SDFM_DATA_FILTER_ACKNOWLEDGE_INTERRUPT));

    SDFM_enableInterrupt(sdfmInstance, SDFM_FILTER_2,
            (SDFM_MODULATOR_FAILURE_INTERRUPT |
             SDFM_DATA_FILTER_ACKNOWLEDGE_INTERRUPT));

    SDFM_enableInterrupt(sdfmInstance, SDFM_FILTER_3,
            (SDFM_MODULATOR_FAILURE_INTERRUPT |
             SDFM_DATA_FILTER_ACKNOWLEDGE_INTERRUPT));

    SDFM_enableInterrupt(sdfmInstance, SDFM_FILTER_4,
            (SDFM_MODULATOR_FAILURE_INTERRUPT |
             SDFM_DATA_FILTER_ACKNOWLEDGE_INTERRUPT));

    SDFM_disableInterrupt(sdfmInstance, SDFM_FILTER_1,
            (SDFM_HIGH_LEVEL_THRESHOLD_INTERRUPT |
             SDFM_LOW_LEVEL_THRESHOLD_INTERRUPT));

    SDFM_disableInterrupt(sdfmInstance, SDFM_FILTER_2,
            (SDFM_HIGH_LEVEL_THRESHOLD_INTERRUPT |
             SDFM_LOW_LEVEL_THRESHOLD_INTERRUPT));

    SDFM_disableInterrupt(sdfmInstance, SDFM_FILTER_3,
            (SDFM_HIGH_LEVEL_THRESHOLD_INTERRUPT |
             SDFM_LOW_LEVEL_THRESHOLD_INTERRUPT));

    SDFM_disableInterrupt(sdfmInstance, SDFM_FILTER_4,
            (SDFM_HIGH_LEVEL_THRESHOLD_INTERRUPT |
             SDFM_LOW_LEVEL_THRESHOLD_INTERRUPT));

    SDFM_disableInterrupt(sdfmInstance, SDFM_FILTER_1,SDFM_MODULATOR_FAILURE_INTERRUPT);
    SDFM_disableInterrupt(sdfmInstance, SDFM_FILTER_2,SDFM_MODULATOR_FAILURE_INTERRUPT);
    SDFM_disableInterrupt(sdfmInstance, SDFM_FILTER_3,SDFM_MODULATOR_FAILURE_INTERRUPT);
    SDFM_disableInterrupt(sdfmInstance, SDFM_FILTER_4,SDFM_MODULATOR_FAILURE_INTERRUPT);

    while((HWREGH(pwmInstance + EPWM_O_TBCTR)) < 550);


    //
    // Enable master interrupt so that any of the filter interrupts can trigger
    // by SDFM interrupt to CPU
    //
    SDFM_enableMainInterrupt(sdfmInstance);
}





