/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include <spi_ex06_board.h>

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void Board_init()
{
	GPIO_init();
	PinMux_init();
	DMA_init();
	SPIX_init();
	INTERRUPT_init();
}
void GPIO_init()
{
    /* Enable write on one pin as CS */
    GPIO_enableWritePin(8);
}

void PinMux_init(void)
{
#if IS_GS32F00xx(0x12)
		// SPIA Pin Mux
		//SPIA_STE_GPIO0
		GPIO_setPinConfig(mySPI0_SPISTE_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPISTE_GPIO, GPIO_PIN_TYPE_STD|GPIO_PIN_TYPE_PULLUP);
		GPIO_setQualificationMode(mySPI0_SPISTE_GPIO, GPIO_QUAL_ASYNC);

		//SPIA_CLK_GPIO12
		GPIO_setPinConfig(mySPI0_SPICLK_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPICLK_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPICLK_GPIO, GPIO_QUAL_ASYNC);

		//SPIA_SIMO_GPIO11
		GPIO_setPinConfig(mySPI0_SPISIMO_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPISIMO_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPISIMO_GPIO, GPIO_QUAL_ASYNC);

		//SPIA_SOMI_GPIO1
		GPIO_setPinConfig(mySPI0_SPISOMI_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPISOMI_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPISOMI_GPIO, GPIO_QUAL_ASYNC);
#elif IS_GS32F3xx(0x22)
		// SPIB Pin Mux
		//SPIB_STE_GPIO66
		GPIO_setPinConfig(mySPI0_SPISTE_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPISTE_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPISTE_GPIO, GPIO_QUAL_ASYNC);

		//SPIB_CLK_GPIO65
		GPIO_setPinConfig(mySPI0_SPICLK_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPICLK_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPICLK_GPIO, GPIO_QUAL_ASYNC);

		//SPIB_SIMO_GPIO63
		GPIO_setPinConfig(mySPI0_SPISIMO_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPISIMO_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPISIMO_GPIO, GPIO_QUAL_ASYNC);

		//SPIB_SOMI_GPIO64
		GPIO_setPinConfig(mySPI0_SPISOMI_PIN_CONFIG);
		GPIO_setPadConfig(mySPI0_SPISOMI_GPIO, GPIO_PIN_TYPE_STD);
		GPIO_setQualificationMode(mySPI0_SPISOMI_GPIO, GPIO_QUAL_ASYNC);
#endif
}

void DMA_init()
{
#if IS_GS32F00xx(0x12)
	DMA_initController(DMA_BASE);
#elif IS_GS32F3xx(0x22)
	XDMA_initController(DMA1_BASE);
#endif
	mySPI0_TX_DMA_init();
	mySPI0_RX_DMA_init();

#if IS_GS32F00xx(0x12)
	DMA_enableInterrupt(DMA1_BASE);
#elif IS_GS32F3xx(0x22)
	XDMA_enableInterrupt(DMA1_BASE);
#endif



}

void mySPI0_TX_DMA_init(){
#if IS_GS32F00xx(0x12)
	DMA_stopChannel(mySPI0_TX_DMA_BASE);
	DMA_ConfigParams dma1Cfg = {0};
	dma1Cfg.enableInterrupt = 1;
	//enable DMA Trigger by DMA MUX
	dma1Cfg.dmaDstReqId = DMAMUX_ReqId_spi0_tx;
	dma1Cfg.srcAddr = (uint32_t)(send_cmd);
	dma1Cfg.destAddr = mySPI0_TX_DMA_ADDRESS;
	dma1Cfg.blockTS = TEST_ALL_COUNT;
	dma1Cfg.ttfc    = DMA_TT_FC_1_M2P_DMAC;
	dma1Cfg.srcBtl  = DMA_BTL_4;
	dma1Cfg.destBtl = DMA_BTL_4;
	dma1Cfg.srcAddrDirect = DMA_ADDR_INCRE;
	dma1Cfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
	dma1Cfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
	dma1Cfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;
	dma1Cfg.srcHkSelect = DMA_HKS_SOFTWARE;
	dma1Cfg.srcHardInf = DMA_HKS_HARD_INF_0;
	dma1Cfg.destHkSelect = DMA_HKS_HARDWARE;
	dma1Cfg.destHardInf = DMA_HKS_HARD_INF_1;
	DMA_configChannel(mySPI0_TX_DMA_BASE, &dma1Cfg);
	DMA_clearInterrupt(mySPI0_TX_DMA_BASE, DMA_INT_TFR);
	DMA_unMaskInterrupt(mySPI0_TX_DMA_BASE, DMA_INT_TFR);
#elif IS_GS32F3xx(0x22)
    XDMA_stopChannel(mySPI0_TX_DMA_BASE);
    XDMA_ConfigParams dma1Cfg = {0};
    dma1Cfg.enableInterrupt = 1;
    dma1Cfg.dmaDstReqId = DMAMUX_ReqId_spi1_tx;
    dma1Cfg.srcAddr = (uint32_t)(send_cmd);
    dma1Cfg.destAddr = mySPI0_TX_DMA_ADDRESS;
    dma1Cfg.blockTS = TEST_ALL_COUNT;
    dma1Cfg.ttfc    = XDMA_TT_FC_1_M2P_DMAC;
    dma1Cfg.srcBtl  = XDMA_BTL_4;
    dma1Cfg.destBtl = XDMA_BTL_4;
    dma1Cfg.srcAddrDirect = XDMA_ADDR_INCRE;
    dma1Cfg.destAddrDirect = XDMA_ADDR_NO_CHANGE;
    dma1Cfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
    dma1Cfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_1;
    XDMA_configChannel(mySPI0_TX_DMA_BASE, &dma1Cfg);
    XDMA_unMaskInterrupt(mySPI0_TX_DMA_BASE, XDMA_INT_BLOCK);
    XDMA_clearInterrupt(mySPI0_TX_DMA_BASE, XDMA_INT_BLOCK);
#endif
}

void mySPI0_RX_DMA_init(){
#if IS_GS32F00xx(0x12)
	DMA_stopChannel(mySPI0_RX_DMA_BASE);
	DMA_ConfigParams dma2Cfg = {0};
	dma2Cfg.enableInterrupt = 1;
	dma2Cfg.dmaSrcReqId = DMAMUX_ReqId_spi0_rx;
	dma2Cfg.srcAddr = mySPI0_RX_DMA_ADDRESS;
	dma2Cfg.destAddr = (uint32_t)(rcv_virdata);
	dma2Cfg.blockTS = TEST_ALL_COUNT;
	dma2Cfg.ttfc    = DMA_TT_FC_2_P2M_DMAC;
	dma2Cfg.srcBtl  = DMA_BTL_4;
	dma2Cfg.destBtl = DMA_BTL_4;
	dma2Cfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
	dma2Cfg.destAddrDirect = DMA_ADDR_INCRE;
	dma2Cfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
	dma2Cfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;
	dma2Cfg.srcHkSelect = DMA_HKS_HARDWARE;
	dma2Cfg.srcHardInf = DMA_HKS_HARD_INF_2;
	dma2Cfg.destHkSelect = DMA_HKS_SOFTWARE;
	dma2Cfg.destHardInf = DMA_HKS_HARD_INF_3;
	DMA_configChannel(mySPI0_RX_DMA_BASE, &dma2Cfg);
	DMA_clearInterrupt(mySPI0_RX_DMA_BASE, DMA_INT_TFR);
	DMA_unMaskInterrupt(mySPI0_RX_DMA_BASE, DMA_INT_TFR);
#elif IS_GS32F3xx(0x22)
    XDMA_stopChannel(mySPI0_RX_DMA_BASE);
    XDMA_ConfigParams dma2Cfg = {0};
    dma2Cfg.enableInterrupt = 1;
    dma2Cfg.dmaSrcReqId = DMAMUX_ReqId_spi1_rx;
    dma2Cfg.srcAddr = mySPI0_RX_DMA_ADDRESS;
    dma2Cfg.destAddr = (uint32_t)(rcv_virdata);
    dma2Cfg.blockTS = TEST_ALL_COUNT;
    dma2Cfg.ttfc    = XDMA_TT_FC_2_P2M_DMAC;
    dma2Cfg.srcBtl  = XDMA_BTL_4;
    dma2Cfg.destBtl = XDMA_BTL_4;
    dma2Cfg.srcAddrDirect = XDMA_ADDR_NO_CHANGE;
    dma2Cfg.destAddrDirect = XDMA_ADDR_INCRE;
    dma2Cfg.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
    dma2Cfg.destTrWidthBytes= XDMA_TR_WIDTH_BYTE_1;
    XDMA_configChannel(mySPI0_RX_DMA_BASE, &dma2Cfg);
    XDMA_unMaskInterrupt(mySPI0_RX_DMA_BASE, XDMA_INT_BLOCK);
    XDMA_clearInterrupt(mySPI0_RX_DMA_BASE, XDMA_INT_BLOCK);

#endif
}

void INTERRUPT_init(void)
{
	Interrupt_register(mySPI_INT,spiFIFOISR);
	Interrupt_enable(mySPI_INT);

	Interrupt_register(INT_DMA_CH0,&DMA_Tx_IRQHandler);
	Interrupt_enable(INT_DMA_CH0);

	Interrupt_register(INT_DMA_CH1,&DMA_Rx_IRQHandler);
	Interrupt_enable(INT_DMA_CH1);
}

void SPIX_init(void)
{
	mySPI_init();
}

void mySPI_init(void)
{
    /* Disable the SSI module before initialization */
	SPI_disableModule(mySPI_BASE);

	/* Initialize SSI */
	SPI_setConfig(mySPI_BASE,DEVICE_APBCLK_FREQ,SPI_PROT_POL0PHA0,\
			SPI_MODE_CONTROLLER,mySPI_BITRATE,mySPI_DATAWIDTH);

    /* Sets the FIFO level at which interrupts are generated. */
    SPI_setFIFOInterruptLevel(mySPI_BASE, SPI_FIFO_TX1, SPI_FIFO_RX1);

    /* Disable all interrupt */
    SPI_disableAllInterrupt(mySPI_BASE);

	/* Clear all interrupt */
	SPI_clearAllInterruptStatus(mySPI_BASE);

    /* Enable interrupt */
/*	SPI_enableInterrupt(mySPI_BASE,SPI_INT_RXFF_OVERFLOW | \
			SPI_INT_RXFF_UNDERFLOW | SPI_INT_TXFF_OF);*/

	/* Open loop */
	SPI_disableLoopback(mySPI_BASE);

	/* Set Tx FIFO level to start DMA transfer */
	SPI_setDmaTxDataLevel(mySPI_BASE,SPI_FIFO_TX4);

	/* Set Rx FIFO level to start DMA receive */
	SPI_setDmaRxDataLevel(mySPI_BASE,SPI_FIFO_RX4);

	/*enable DMA transfer function */
	SPI_disableTransmitDMA(mySPI_BASE);

	/*enable DMA receive function */
	SPI_disableReceiveDMA(mySPI_BASE);

    /* Enable the SSI module before initialization */
    SPI_enableModule(mySPI_BASE);

}



#ifdef __cplusplus
}
#endif

