
#ifndef BOARD_H
#define BOARD_H

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

//
// Included Files
//

#include "driverlib.h"
#include "device.h"

extern uint16_t send[128];
extern uint16_t recive[128];
//*****************************************************************************
//
// PinMux Configurations
//
//*****************************************************************************

/* ========================================================================== */
/*                           PinMux Configuration                             */
/* ========================================================================== */
#if IS_GS32F00xx(0x12)
//
// SPIB -> mySPI0 Pinmux
//
//
// SPIB_SIMO - GPIO Settings
//
#define GPIO_PIN_SPIB_SIMO 7
#define mySPI1_SPISIMO_GPIO 7
#define mySPI1_SPISIMO_PIN_CONFIG GPIO_7_SPIB_SIMO
//
// SPIB_SOMI - GPIO Settings
//
#define GPIO_PIN_SPIB_SOMI 6
#define mySPI1_SPISOMI_GPIO 6
#define mySPI1_SPISOMI_PIN_CONFIG GPIO_6_SPIB_SOMI
//
// SPIB_CLK - GPIO Settings
//
#define GPIO_PIN_SPIB_CLK 4
#define mySPI1_SPICLK_GPIO 4
#define mySPI1_SPICLK_PIN_CONFIG GPIO_4_SPIB_CLK
//
// SPIB_STE - GPIO Settings
//
#define GPIO_PIN_SPIB_STE 15
#define mySPI1_SPISTE_GPIO 15
#define mySPI1_SPISTE_PIN_CONFIG GPIO_15_SPIB_STE

#elif IS_GS32F3xx(0x22)
//
// SPIB -> mySPI0 Pinmux
//
//
// SPIB_SIMO - GPIO Settings
//
/*
#define GPIO_PIN_SPIB_SIMO 24
#define mySPI1_SPISIMO_GPIO 24
#define mySPI1_SPISIMO_PIN_CONFIG GPIO_24_SPISIMOB
//
// SPIB_SOMI - GPIO Settings
//
#define GPIO_PIN_SPIB_SOMI 25
#define mySPI1_SPISOMI_GPIO 25
#define mySPI1_SPISOMI_PIN_CONFIG GPIO_25_SPISOMIB
//
// SPIB_CLK - GPIO Settings
//
#define GPIO_PIN_SPIB_CLK 22
#define mySPI1_SPICLK_GPIO 22
#define mySPI1_SPICLK_PIN_CONFIG GPIO_22_SPICLKB
//
// SPIB_STE - GPIO Settings
//
#define GPIO_PIN_SPIB_STE 23
#define mySPI1_SPISTE_GPIO 23
#define mySPI1_SPISTE_PIN_CONFIG GPIO_23_SPISTEB
*/

#define GPIO_PIN_SPIC_SIMO 100
#define mySPI1_SPISIMO_GPIO 100
#define mySPI1_SPISIMO_PIN_CONFIG GPIO_100_SPISIMOC
//
// SPIB_SOMI - GPIO Settings
//
#define GPIO_PIN_SPIC_SOMI 101
#define mySPI1_SPISOMI_GPIO 101
#define mySPI1_SPISOMI_PIN_CONFIG GPIO_101_SPIC_SOMI
//
// SPIB_CLK - GPIO Settings
//
#define GPIO_PIN_SPIC_CLK 102
#define mySPI1_SPICLK_GPIO 102
#define mySPI1_SPICLK_PIN_CONFIG GPIO_102_SPICLKC
//
// SPIB_STE - GPIO Settings
//
#define GPIO_PIN_SPIC_STE 103
#define mySPI1_SPISTE_GPIO 103
#define mySPI1_SPISTE_PIN_CONFIG GPIO_103_SPISTEC
#endif

//*****************************************************************************
//
// DMA Configurations
//
//*****************************************************************************

#if IS_GS32F00xx(0x12)
#define mySPI0_TX_DMA_BASE DMA1_CH1_BASE
#elif IS_GS32F3xx(0x22)
#define mySPI0_TX_DMA_BASE DMA1_CH1_BASE
#endif
void mySPI0_TX_DMA_init();

#if IS_GS32F00xx(0x12)
#define mySPI0_RX_DMA_BASE DMA1_CH2_BASE
#elif IS_GS32F3xx(0x22)
#define mySPI0_RX_DMA_BASE DMA1_CH2_BASE
#endif
void mySPI0_RX_DMA_init();



//*****************************************************************************
//
// INTERRUPT Configurations
//
//*****************************************************************************

#if IS_GS32F00xx(0x12)
#define INT_mySPI0_TX_DMA	INT_DMA1_CH1
#define INT_mySPI0_RX_DMA	INT_DMA1_CH2
#elif IS_GS32F3xx(0x22)
#define INT_mySPI0_TX_DMA	INT_DMA1_CH1
#define INT_mySPI0_RX_DMA	INT_DMA1_CH2
#endif
// Interrupt Settings for INT_mySPI0_TX_DMA
extern void INT_mySPI0_TX_DMA_ISR(void);

// Interrupt Settings for INT_mySPI0_RX_DMA
extern void INT_mySPI0_RX_DMA_ISR(void);

//*****************************************************************************
//
// SPI Configurations
//
//*****************************************************************************
#if IS_GS32F00xx(0x12)
#define mySPI_BASE SPIA_BASE
#elif IS_GS32F3xx(0x22)
#define mySPI_BASE SPIC_BASE
#endif
#define mySPI0_BITRATE 1000000
#define mySPI0_RX_DMA_ADDRESS ((uint32_t)(mySPI_BASE + SPI_O_DATAREG))
#define mySPI0_TX_DMA_ADDRESS ((uint32_t)(mySPI_BASE + SPI_O_DATAREG))
void mySPI0_init();
extern void spiRxFIFOISR(void);


//*****************************************************************************
//
// SYSCTL Configurations
//
//*****************************************************************************

//*****************************************************************************
//
// Board Configurations
//
//*****************************************************************************
void	Board_init();
void	DMA_init();
void	INTERRUPT_init();
void	SPIX_init();
void	PinMux_init();

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif  // end of BOARD_H definition
