/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define LED_GPIO_PIN    GPIO_PIN_LED1
#define LED_GPIO_CFG    GPIO_CFG_LED1


#define LED2_GPIO_PIN   GPIO_PIN_LED2
#define LED2_GPIO_CFG   GPIO_CFG_LED2


/*
 * PMP_CONFIG_MODE = 1 Configure PMPxCFG and PMPADDRx respectively to configure PMP, and set PMP to read-only
 * PMP_CONFIG_MODE = 2 The idx entry sets the PMP entry and configures PMP to write only
 * */
#define PMP_CONFIG_MODE 1

#define PMP_PROTECTED_SIZE 0x1FF //Protect an address range of 4KB in size,SIZE = (4096 - 1) >>3
#define PMP_PROTECTED_ADD 0x80001000 //The starting address of the protected address
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*
 * @brief  main function.
 */
int main(void)
{
    uint32_t oldTicks;
    uint32_t tickCnt;
    volatile rv_csr_t add;
    volatile uint8_t cfg;

    Device_init();

    GPIO_setPinConfig(LED_GPIO_CFG);     //gpio
    GPIO_setAnalogMode(LED_GPIO_PIN,GPIO_ANALOG_DISABLED);
    GPIO_enableWritePin(LED_GPIO_PIN);


    GPIO_setPinConfig(LED2_GPIO_PIN);     //gpio
    GPIO_setAnalogMode(LED2_GPIO_PIN,GPIO_ANALOG_DISABLED);
    GPIO_enableWritePin(LED2_GPIO_PIN);

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    log_info("Hello DSP template!\r\n");
    log_info("Code @ 0x%08X, Data @ 0x%08X.\r\n", (uint32_t)main, (uint32_t)&oldTicks);

    GPIO_writePin(LED2_GPIO_PIN, 1);
    DELAY_US(1000*1000);

#if(PMP_CONFIG_MODE == 1)
    __enable_irq();

    /* Calculation formula for protected address size:
     * offset = (size - 1) >> 3
     *pmpadd = (phy_addr >> 2) | offset
     *Protected address range:[Protect the starting address,Protect the starting address+Protect the address size)
     * */
	__set_PMPADDRx(1, ((PMP_PROTECTED_ADD >> 2) | PMP_PROTECTED_SIZE));//Configure pmpaddr,

	/* If PMP protection is required to take effect in M mode, PMP_L needs to be written
	 * update the address first, in case the entry is locked that
	 * */
	__set_PMPxCFG(1, PMP_R | PMP_L |PMP_A_NAPOT);//Configure pmpcfg

#elif(PMP_CONFIG_MODE == 2)
	pmp_config tmpCfg;
	tmpCfg.base_addr = PMP_PROTECTED_ADD;//Configure the protected starting address
	tmpCfg.order = 12;//4KB = 2^12
	tmpCfg.protection = (PMP_W | PMP_L |PMP_A_NAPOT);////Configure pmpcfg

	__set_PMPENTRYx(1, &tmpCfg);
#endif


	add = __get_PMPADDRx(1);//Read the pmpaddr value
	cfg = __get_PMPxCFG(1);//Read the pmpcfg value


#if(PMP_CONFIG_MODE == 1)
    volatile uint32_t* pReg = (volatile uint32_t*)(PMP_PROTECTED_ADD + 0x1000);
    uint32_t read_value = *pReg;
    *pReg = 0xA5A5A5A5;//Try to write a value to the boundary address

    volatile uint32_t* pReg1 = (volatile uint32_t*)(PMP_PROTECTED_ADD - 0x4);
    uint32_t read_value1 = *pReg1;
    *pReg1 = 0xA5A5A5A5;//Try to write a value to the boundary address

    volatile uint32_t* pReg2 = (volatile uint32_t*)(PMP_PROTECTED_ADD - 0x3);
    uint32_t read_value3 = *pReg2;
    *pReg2 = 0x1;//An attempt to write the value to the boundary address triggered a write exception

    /* A write exception is triggered. At this point
     * the program will enter core_exception_handler and stop running
     * */
    volatile  uint32_t *ptr = (uint32_t*) PMP_PROTECTED_ADD;
    uint32_t read_value2 = *ptr;
    *ptr = 0xDEADBEEF;//Trigger a write exception


#elif(PMP_CONFIG_MODE == 2)
    volatile uint32_t* pReg = (volatile uint32_t*)(PMP_PROTECTED_ADD + 0x1000);
    *pReg = 0xA5A5A5A5;
    uint32_t read_value = *pReg;//Try to read the content of the address.

    volatile uint32_t* pReg1 = (volatile uint32_t*)(PMP_PROTECTED_ADD - 0x4);
    *pReg1 = 0xA5A5A5A5;
    uint32_t read_value1 = *pReg1;//Try to read the content of the address.

    /* A write exception is triggered. At this point
     * the program will enter core_exception_handler and stop running
     * */
    volatile  uint32_t *ptr = (uint32_t*) PMP_PROTECTED_ADD;
    *ptr = 0xDEADBEEF;
    uint32_t read_value2 = *ptr;//Try to read the content of the address.

#endif

    while (1) {
    	GPIO_togglePin(LED_GPIO_PIN);
    	DELAY_US(1000*1000);
    }

    return 0;
}

