/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * @example: loopback
 * @Language:English
 * @encode:
 * @brief:
 * 	This routine demonstrates the use of the Loopback function in the SCI module.
 * 	By writing data to the sendobuff array and enabling Loopback mode,
 * 	then sending the data from the sendobuff array,
 * 	Read the data from the RX end again and store it in the receiving buff array.
 * 	Finally, compare the data in the sending buff and receiving buff arrays to see if they are the same.
 *
 *	Note:
 *	 	1. When setting the SCI baud rate, it should be ensured that SCI is in an idle state.
 *			SCI can be made idle through the SCI_deset() function before setting the baud rate.
 * */

/*
 * @example: loopback
 * @Language:Chinese
 * @encode:GBK
 * @brief:
 *	ʾSCIģLoopbackܵʹá
 *	ͨsend_buffдݣʹLoopbackģʽsend_buffݷͳȥ
 *	ٶȡRX˵ݲ洢receive_buffУȽsend_buffreceive_buffǷͬ
 *
 *	ע⣺SCIʱӦ֤SCIڿ״̬ԵSCI_resetʹSCIλٽвá
 * */

#include "device.h"
#include "sci_ex01_loopback.h"

int main(void)
{
	/* initialize the Flash and System Clock, and enable the clocks for all peripherals. */
    Device_init();

    UART_Init(MY_SCI_BASE, 115200);

    UART_writeCharArray(MY_SCI_BASE, "SCI_ex01_loopback start \r\n", 26);

    sci_ex01_loopback_Example(MY_SCI_BASE);

    UART_writeCharArray(MY_SCI_BASE, "SCI_ex01_loopback end \r\n", 24);

    for(;;);
    return 0;
}




