/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * @example: Receive interrupt
 * @Language:English
 * @encode:
 * @brief:
 * This routine demonstrates the function of using interrupts to receive data without enabling FIFO.
 * The sender sends one byte at a time, and the routine reads this byte and returns it.
 *
 *	Note:
 *	 	1. When setting the SCI baud rate, it should be ensured that SCI is in an idle state.
 *			SCI can be made idle through the SCI_deset() function before setting the baud rate.
 * */

/*
 * @example: Receive interrupt
 * @Language:Chinese
 * @encode:GBK
 * @brief:
 *	ʾڲʹFIFO£ʹжݵĹܡ
 *	ͷÿηһֽڣ̶ȡֽڲء
 *
 *	ע⣺SCIʱӦ֤SCIڿ״̬ԵSCI_resetʹSCIλٽвá
 * */

#include "device.h"
#include "sci_ex02_rx_irq.h"

int main(void)
{

	/* initialize the Flash and System Clock, and enable the clocks for all peripherals. */
    Device_init();

    /* Enable global interrupt */
    __enable_irq();

    UART_Init(MY_SCI_BASE, 115200);

    UART_writeCharArray(MY_SCI_BASE, "SCI_ex02_rx_irq start \r\n", 24);

    sci_ex02_rx_irq_Example(MY_SCI_BASE);

	UART_writeCharArray(MY_SCI_BASE, "SCI_ex02_rx_irq end \r\n", 22);

	for(;;);
    return 0;
}




