/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    dma_ex11_sci_autoback_with_timeout_board.c
*   @brief
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "board_cfg.h"
#include "printf.h"
#include <string.h>
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */



/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */
char UART_TXBUF[32];
char UART_RXBUF[32]={0};
uint64_t ctrl = 0,config = 0;
char tmpstr[32] = {0};

#define g_SCI_base    SCIB_BASE
void dma_uart(void);

#if (defined(LOAD_MONITOR) && LOAD_MONITOR)
__IO DLOAD_STRUCT    dload;
#endif


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

void uart_init()
{
    //gpio
	if (g_SCI_base == SCIA_BASE)
	{
		GPIO_setPadConfig(42, GPIO_PIN_TYPE_PULLUP);
	    GPIO_setPadConfig(43, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPinConfig(SCIA_TX_PIN);
	    GPIO_setPinConfig(SCIA_RX_PIN);
	}
	else if (g_SCI_base == SCIB_BASE)
	{
		GPIO_setPadConfig(14, GPIO_PIN_TYPE_PULLUP);
	    GPIO_setPadConfig(15, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPinConfig(SCIB_TX_PIN);
	    GPIO_setPinConfig(SCIB_RX_PIN);
	}
	else if (g_SCI_base == SCIC_BASE)
	{
		GPIO_setPadConfig(56, GPIO_PIN_TYPE_PULLUP);
	    GPIO_setPadConfig(57, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPinConfig(GPIO_57_SCIC_RX);
	    GPIO_setPinConfig(GPIO_56_SCIC_TX);
	}
	else if (g_SCI_base == SCID_BASE)
	{
		GPIO_setPadConfig(46, GPIO_PIN_TYPE_PULLUP);
	    GPIO_setPadConfig(47, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPinConfig(GPIO_47_SCID_TX);
	    GPIO_setPinConfig(GPIO_46_SCID_RX);
	}
	else if (g_SCI_base == SCIE_BASE)
	{
		GPIO_setPadConfig(84, GPIO_PIN_TYPE_PULLUP);
	    GPIO_setPadConfig(85, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPinConfig(GPIO_84_SCIE_TX);
	    GPIO_setPinConfig(GPIO_85_SCIE_RX);
	}
	else if(g_SCI_base == SCIF_BASE)
	{
		GPIO_setPadConfig(44, GPIO_PIN_TYPE_PULLUP);
	    GPIO_setPadConfig(45, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPinConfig(GPIO_44_SCIF_TX);
	    GPIO_setPinConfig(GPIO_45_SCIF_RX);
	}

	SCI_setBaud(g_SCI_base,DEVICE_APBCLK_FREQ,115200);

	SCI_setInitConfig(g_SCI_base, SCI_CONFIG_PAR_NONE, SCI_STOP_1BIT, SCI_CHAR_8BITS);

    SCI_enableFIFO(g_SCI_base);
    SCI_setFIFOInterruptLevel(g_SCI_base, SCI_FIFO_TX0, SCI_FIFO_RX4);
    SCI_enableInterrupt(g_SCI_base, SCI_RX_DATA_AVAILABLE_INT);


}


void dma_uart_tx()
{
	XDMA_ConfigParams dmaCfg1 = {0};
	for(int i=0;i<32;i++)
	{
		UART_TXBUF[i]='A';
	}
	UART_TXBUF[30] = '\r';
	UART_TXBUF[31] = '\n';
//	printf("buf ready\r\n");

	XDMA_stopChannel(DMA1_CH1_BASE);
	dmaCfg1.enableInterrupt = 1;
	dmaCfg1.srcAddr = (uint32_t)(&UART_TXBUF[0]);
	dmaCfg1.destAddr = (g_SCI_base + SCI_O_RBR_THR_DLL);
	dmaCfg1.blockTS = 32;
	dmaCfg1.ttfc = XDMA_TT_FC_1_M2P_DMAC;
	dmaCfg1.srcBtl  = XDMA_BTL_1;
	dmaCfg1.destBtl = XDMA_BTL_1;
	dmaCfg1.srcAddrDirect = XDMA_ADDR_INCRE;
	dmaCfg1.destAddrDirect = XDMA_ADDR_NO_CHANGE;
	dmaCfg1.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
	dmaCfg1.destTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
	dmaCfg1.destHardInf = XDMA_HKS_HARD_INF_0;
	if (g_SCI_base == SCIA_BASE)
	{
		dmaCfg1.dmaDstReqId = DMAMUX_ReqId_scia_tx;
	}
	else if (g_SCI_base == SCIB_BASE)
	{
		dmaCfg1.dmaDstReqId = DMAMUX_ReqId_scib_tx;
	}
	else if (g_SCI_base == SCIC_BASE)
	{
		dmaCfg1.dmaDstReqId = DMAMUX_ReqId_scic_tx;
	}
	else if (g_SCI_base == SCID_BASE)
	{
		dmaCfg1.dmaDstReqId = DMAMUX_ReqId_scid_tx;
	}
	else if (g_SCI_base == SCIE_BASE)
	{
		dmaCfg1.dmaDstReqId = DMAMUX_ReqId_scie_tx;
	}
	else if(g_SCI_base == SCIF_BASE)
	{
		dmaCfg1.dmaDstReqId = DMAMUX_ReqId_scif_tx;
	}
//	dmaCfg1.dmaDstReqId = DMAMUX_ReqId_scib_tx;
	XDMA_configChannel(DMA1_CH1_BASE, &dmaCfg1);
	XDMA_clearInterrupt(DMA1_CH1_BASE, XDMA_INT_TFR);
	XDMA_unMaskInterrupt(DMA1_CH1_BASE, XDMA_INT_TFR);

}


void dma_uart_rx()
{
	int i = 0;

	XDMA_ConfigParams dmaCfg2 = {0};

	XDMA_stopChannel(DMA1_CH2_BASE);
	dmaCfg2.enableInterrupt = 1;
	dmaCfg2.srcAddr = (g_SCI_base + SCI_O_RBR_THR_DLL);
	dmaCfg2.destAddr = (uint32_t)(&UART_RXBUF[0]);
	dmaCfg2.blockTS = 8;
	dmaCfg2.ttfc = XDMA_TT_FC_2_P2M_DMAC;
	dmaCfg2.srcBtl  = XDMA_BTL_4;
	dmaCfg2.destBtl = XDMA_BTL_4;
	dmaCfg2.srcAddrDirect = XDMA_ADDR_NO_CHANGE;
	dmaCfg2.destAddrDirect = XDMA_ADDR_INCRE;
	dmaCfg2.srcTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
	dmaCfg2.destTrWidthBytes = XDMA_TR_WIDTH_BYTE_1;
	dmaCfg2.srcHardInf = XDMA_HKS_HARD_INF_0;
	if (g_SCI_base == SCIA_BASE)
	{
		dmaCfg2.dmaSrcReqId = DMAMUX_ReqId_scia_rx;
	}
	else if (g_SCI_base == SCIB_BASE)
	{
		dmaCfg2.dmaSrcReqId = DMAMUX_ReqId_scib_rx;
	}
	else if (g_SCI_base == SCIC_BASE)
	{
		dmaCfg2.dmaSrcReqId = DMAMUX_ReqId_scic_rx;
	}
	else if (g_SCI_base == SCID_BASE)
	{
		dmaCfg2.dmaSrcReqId = DMAMUX_ReqId_scid_rx;
	}
	else if (g_SCI_base == SCIE_BASE)
	{
		dmaCfg2.dmaSrcReqId = DMAMUX_ReqId_scie_rx;
	}
	else if(g_SCI_base == SCIF_BASE)
	{
		dmaCfg2.dmaSrcReqId = DMAMUX_ReqId_scif_rx;
	}


    XDMA_configChannel(DMA1_CH2_BASE, &dmaCfg2);
	XDMA_clearInterrupt(DMA1_CH2_BASE, XDMA_INT_TFR);
	XDMA_unMaskInterrupt(DMA1_CH2_BASE, XDMA_INT_TFR);

}


void dma_uart()
{
	uart_init();

	char* msg = "DMA controlled UART Tx test done.\r\n";

	volatile uint8_t ret;
	volatile uint32_t res;
	XDMA_initController(DMA1_BASE);

	dma_uart_tx();
	dma_uart_rx();


	XDMA_startChannel(DMA1_CH1_BASE);
	XDMA_startChannel(DMA1_CH2_BASE);
	res=XDMA_isFifoEmpty(DMA1_CH2_BASE);

	while((XDMA_getInterruptStatus(DMA1_CH1_BASE) & XDMA_INT_TFR) == 0);

	UART_writeCharArray(g_SCI_base, msg, strlen(msg));

	msg = "please input 10 chars\r\n";

	UART_writeCharArray(g_SCI_base, msg, strlen(msg));



	while(!(ret & XDMA_INT_TFR))
	{
		ret = XDMA_getInterruptStatus(DMA1_CH2_BASE);
	}

	msg = "UART_RXBUF:";
	UART_writeCharArray(g_SCI_base, msg, strlen(msg));
	for(int i=0;i<10;i++)
	{
//		printf("%c",UART_RXBUF[i]);
		UART_writeCharNonBlocking(g_SCI_base, UART_RXBUF[i]);
	}

	msg = "\r\nDMA controlled UART Rx test done.\r\n";
	UART_writeCharArray(g_SCI_base, msg, strlen(msg));

}

int main(void)
{


#if ((GS32F3xx & 0xFF00) || (GS32F00xx & 0xFF00))

#endif
	Device_init();
//	UartPrint_init(g_g_SCI_base, 115200);

	//SCI_disableFIFO(SCIA_BASE);

    dma_uart();





    /* We should never get here as control is now taken by the scheduler */
    for(;;);
}
