/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * @example: Maximum baud rate communication and CRC16 verification
 * @Language:English
 * @encode:
 * @brief:
 * 			Maximum baud rate communication
 * 			Data length: 	Fixed 16 bytes
 * 			Verification:	CRC16 verification, poly=0x1021
 *
 *	Wiring Connect:
 * 		device1		device2
 *		  TX	-->	  RX
 *		  RX	-->	  TX
 *	The multiplexed GPIOs for TX/RX are defined by the macros SCI_TX_GPIO and SCI_RX_GPIO in inc/sci_ex10_xxx.h.
 *
 *	Debugging Observations:
 *		Monitor the following variables to evaluate system performance:
 *			rcv_buff: 				Data buffer array storing received data.
 *			intoIrq_count: 			Number of interrupt entries.
 *			irq_readData_count: 	Count of bytes read per interrupt.
 *			CRC16_error_count: 		Number of CRC16 verification errors (counted per 16-byte block).
 *			rcvData_rightful_flag: 	Data validity flag (set when CRC16 verification passes).
 *
 *	Note: When configuring the SCI baud rate, ensure the SCI is in an idle state.
 *	You may call the SCI_reset function to reset the SCI before setting the baud rate.
 * */

/*
 * @example: loopback
 * @Language:Chinese
 * @encode:GBK
 * @brief:
 * 			baud-rateͨţ
 * 			ݳȣ̶16byte
 * 			У鷽ʽCRC16У飬 poly=0x1021
 *
 * 	߷ʽ
 * 		device1	-->	device2
 *		  TX	-->	  RX
 *		  RX	-->	  TX
 *	TXRXĸGPIOinc/sci_ex10_xxx.hĺSCI_TX_GPIOSCI_TX_GPIO
 *
 *	debug
 *		ͨ۲±۲еĽ
 *			rcv_buff				洢ݵ飬洢յݡ
 *			intoIrq_count			жϵĴ
 *			irq_readData_count		ȡbyte
 *			CRC16_error_count		УĴһΪ16byte
 *			rcvData_righful_flag	ȷ־CRC16УͨΪ
 *
 *	ע⣺SCIʱӦ֤SCIڿ״̬ԵSCI_resetʹSCIλٽвá
 * */

#include "device.h"
#include "sci_ex10_MaxBaud_receive.h"

int main(void)
{

	/* initialize the Flash and System Clock, and enable the clocks for all peripherals. */
    Device_init();

    /* Enable global interrupt */
    __enable_irq();

    UART_Init(MY_SCI_BASE, 6250000);		//baud_max = 6.25M (APB_max=100M)

    sci_ex10_MaxBaud_Example(MY_SCI_BASE);

	for(;;);
    return 0;
}




