#include "sci_echoback_board.h"

void uart_pinmux_init(uint32_t base)
{
	if (base == SCIA_BASE)
	{
		GPIO_setPinConfig(SCIA_TX_PIN);
		GPIO_setPinConfig(SCIA_RX_PIN);

		GPIO_setPadConfig(28, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(29, GPIO_PIN_TYPE_PULLUP);
	}
	else if (base == SCIB_BASE)
	{
		GPIO_setPinConfig(SCIB_TX_PIN);
		GPIO_setPinConfig(SCIB_RX_PIN);

		GPIO_setPadConfig(14, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(15, GPIO_PIN_TYPE_PULLUP);
	}
}


void uart_init(uint32_t SCI_BASE, uint32_t Baud)
{
    SysCtl_resetSci();

	SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_SCI);

	SCI_performSoftwareReset(SCI_BASE);
	SCI_setConfig(SCI_BASE, DEVICE_APBCLK_FREQ, Baud,(SCI_CONFIG_WLEN_8|SCI_CONFIG_STOP_ONE|SCI_CONFIG_PAR_NONE));
	SCI_clearInterruptStatus(SCI_BASE, SCI_INT_TXFF | SCI_INT_RXFF);
	SCI_disableFIFO(SCI_BASE);
	SCI_resetChannels(SCI_BASE);
	SCI_enableModule(SCI_BASE);
	SCI_performSoftwareReset(SCI_BASE);
}


