#include "sci_nofifo_interrupts.h"

#define my_sci_base SCIA_BASE

void uart_pinmux_init(uint32_t base)
{
	if (base == SCIA_BASE)
	{
		GPIO_setPinConfig(SCIA_TX_PIN);
		GPIO_setPinConfig(SCIA_RX_PIN);

		GPIO_setPadConfig(28, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(29, GPIO_PIN_TYPE_PULLUP);
	}
	else if (base == SCIB_BASE)
	{
		GPIO_setPinConfig(SCIB_TX_PIN);
		GPIO_setPinConfig(SCIB_RX_PIN);

		GPIO_setPadConfig(14, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(15, GPIO_PIN_TYPE_PULLUP);
	}
}

void uart_init(uint32_t SCI_Base, uint32_t Baud)
{
    SysCtl_resetSci();
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_SCI);

	/* Initialize SCIB and its FIFO. */
    SCI_performSoftwareReset(SCI_Base);

    /* Configure SCI for echoback. */
    SCI_setConfig(SCI_Base, DEVICE_APBCLK_FREQ, Baud, (SCI_CONFIG_WLEN_8 |
                                                          SCI_CONFIG_STOP_ONE |
                                                        SCI_CONFIG_PAR_NONE));
    SCI_resetChannels(SCI_Base);
    SCI_resetRxFIFO(SCI_Base);
    SCI_resetTxFIFO(SCI_Base);
    SCI_clearInterruptStatus(SCI_Base, SCI_INT_TXRDY | SCI_INT_RXRDY_BRKDT);
    /* Enable the TXRDY and RXRDY interrupts. */
    SCI_enableInterrupt(SCI_Base, SCI_INT_TXRDY | SCI_INT_RXRDY_BRKDT);
    SCI_enableModule(SCI_Base);
    SCI_performSoftwareReset(SCI_Base);
}

/* sciaTXFIFOISR - SCIA Transmit FIFO ISR */
__interrupt void sciaTxISR(void)
{
	char* msg = "\0";
	uint32_t interrupt_status = SCI_getInterruptStatus(my_sci_base);

	if (interrupt_status & SCI_INT_TXRDY)
	{
		/*Disable the TXRDY interrupt.*/
		SCI_disableInterrupt(my_sci_base, SCI_INT_TXRDY);

		msg = "\r\nEnter a character: \0";
		UART_writeCharArray(my_sci_base, msg, 22);
	}
	else
	{
		SCI_performSoftwareReset(my_sci_base);
	}

    __DSB();
}


/* sciaRXFIFOISR - SCIA Receive FIFO ISR */
__interrupt void sciaRxISR(void)
{
   uint16_t receivedChar;
   char* msg = "\0";
   uint32_t interrupt_status = 0;

   interrupt_status = SCI_getInterruptStatus(my_sci_base);

   if (interrupt_status & SCI_INT_RXRDY_BRKDT)
   {
	   /* Enable the TXRDY interrupt again. */
	   SCI_enableInterrupt(my_sci_base, SCI_INT_TXRDY);

	   /*Read a character from the RXBUF.*/
	   receivedChar = SCI_readCharBlockingNonFIFO(my_sci_base);

	   /* Echo back the character. */
	   msg = "  You sent: \0";
	   UART_writeCharArray(my_sci_base, msg, 13);
	   SCI_writeCharBlockingNonFIFO(my_sci_base, receivedChar);
   }
   else
   {
	   SCI_performSoftwareReset(my_sci_base);
   }
   
    __DSB();
}


