// See LICENSE for license details.
#include "sci_idle_line_master.h"

#define SEND_DATA_LEN   64

extern uint32_t g_SCI_base;
extern volatile uint8_t flag_n;
extern uint8_t buff[64];
extern uint16_t cnt;

int main(void)
{
    uint32_t oldTicks;
    uint32_t tickCnt;
    uint32_t i = 0;

    Device_init();

    uart_pinmux_init(g_SCI_base);
    uart_init(g_SCI_base, 115200);

    Interrupt_register(INT_SCIA_RX, SCIx_RX_INTR_IRQHandler);

	char *prompt_info = "the device address is 0x59(Y), and You will enter msg, which end with \\n: \r\n";

	UART_writeCharArray(g_SCI_base, prompt_info, strlen(prompt_info));

    Interrupt_enable(INT_SCIA_RX);
    __enable_irq();


    while(1)
    {
        while(flag_n)
        {
            flag_n=0;
            UART_writeCharArray(g_SCI_base, buff, cnt-1);
            for (i = 0; i < SEND_DATA_LEN; i++)
            {
            	buff[i] = 0;
            }

            SCI_enableSleepMode(g_SCI_base);

            cnt=0;
        }
    }

}
