//#############################################################################
//
// FILE:   sci_ex3_echoback.c
//
// TITLE:  SCI echoback example.
//
//! \addtogroup driver_example_list
//! <h1>SCI Echoback</h1>
//!
//!  This test receives and echo-backs data through the SCI-A port.
//!
//!  A terminal such as 'putty' can be used to view the data from
//!  the SCI and to send information to the SCI. Characters received
//!  by the SCI port are sent back to the host.
//!
//!  \b Running \b the \b Application
//!  Open a COM port with the following settings using a terminal:
//!  -  Find correct COM port
//!  -  Bits per second = 115200
//!  -  Data Bits = 8
//!  -  Parity = None
//!  -  Stop Bits = 1
//!  -  Hardware Control = None
//!
//!  The program will print out a greeting and then ask you to
//!  enter a character which it will echo back to the terminal.
//!
//!  \b Watch \b Variables \n
//!  - loopCounter - the number of characters sent
//!
//! \b External \b Connections \n
//!  Connect the USB cable from Control card J1:A to PC
//!
//
//#############################################################################
// See LICENSE for license details.

#include "sci_fifo_level.h"

extern uint32_t my_sci_base;

int main(void)
{
    uint16_t receivedChar;
    unsigned char *msg;
    uint16_t rxStatus = 0U;
    uint8_t i = 0;


    /* Initialize device clock and peripherals */
    Device_init();

    uart_pinmux_init(my_sci_base);

    uart_init(my_sci_base, 115200);

    Interrupt_register(INT_SCIA_TX, SCI_TX_ISR);
    Interrupt_register(INT_SCIA_RX, SCI_RX_ISR);


#ifdef AUTOBAUD
    SCI_lockAutobaud(SCIB_BASE);
#endif


    Interrupt_enable(INT_SCIA_TX);
    Interrupt_enable(INT_SCIA_RX);


    /* Enables CPU interrupts */
    __enable_irq();


    /* IDLE loop. Just sit and loop forever (optional): */
    for(;;)
    {

    }
}
