/*
 * sci_fifo_level.c
 *
 *  Created on: 2025 May 13
 *      Author: hpec
 */
#include "sci_fifo_level.h"

uint32_t my_sci_base = SCIA_BASE;

volatile SCI_RxFIFOLevel rcv_level_set = SCI_FIFO_RX1;

uint8_t rcv_data[128] = {0};
volatile uint8_t rcv_cnt = 0;
volatile uint8_t interrupt_id = 0;

void uart_pinmux_init(uint32_t base)
{
	if (base == SCIA_BASE)
	{
		GPIO_setPinConfig(SCIA_TX_PIN);
		GPIO_setPinConfig(SCIA_RX_PIN);

		GPIO_setPadConfig(28, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(29, GPIO_PIN_TYPE_PULLUP);
	}
	else if (base == SCIB_BASE)
	{
		GPIO_setPinConfig(SCIB_TX_PIN);
		GPIO_setPinConfig(SCIB_RX_PIN);

		GPIO_setPadConfig(14, GPIO_PIN_TYPE_PULLUP);
		GPIO_setPadConfig(15, GPIO_PIN_TYPE_PULLUP);
	}
}

void uart_init(uint32_t SCI_Base, uint32_t Baud_Rate)
{
	SCI_performSoftwareReset(SCI_Base);
	SCI_setConfig(SCI_Base, DEVICE_APBCLK_FREQ, Baud_Rate,(SCI_CONFIG_WLEN_8|SCI_CONFIG_STOP_ONE|SCI_CONFIG_PAR_NONE));
	SCI_resetChannels(SCI_Base);
	SCI_clearInterruptStatus(SCI_Base, SCI_INT_TXFF | SCI_INT_RXFF);
	SCI_enableFIFO(SCI_Base);
	SCI_setFIFOInterruptLevel(SCI_Base, SCI_FIFO_TX0, rcv_level_set);
	SCI_enableInterrupt(SCI_Base, SCI_INT_TXFF | SCI_INT_RXFF);
	SCI_enableModule(SCI_Base);
	SCI_performSoftwareReset(SCI_Base);
}

void SCI_TX_ISR(void)
{
	SCI_RxFIFOLevel* rx_level;
	SCI_TxFIFOLevel* tx_level;
	char set_level;
	char *prompt_info  = "now the receive level is:";

	UART_writeCharArray(my_sci_base, prompt_info, strlen(prompt_info));

	if (rcv_level_set < 9)
	{
		UART_writeCharBlockingFIFO(my_sci_base, '0' + rcv_level_set);
	}
	else
	{
		UART_writeCharBlockingFIFO(my_sci_base, '1' + rcv_level_set);
	}
	prompt_info = "\nplease enter some chars: \r\n";
	UART_writeCharArray(my_sci_base, prompt_info, strlen(prompt_info));

	SCI_clearInterruptStatus(my_sci_base, SCI_INT_TXFF);

    SCI_disableInterrupt(my_sci_base, SCI_INT_TXFF);

    rcv_level_set++;
	
    __DSB();
}


void SCI_RX_ISR(void)
{
	char* msg = "\0";
	SCI_TxFIFOLevel* send_level;
	SCI_RxFIFOLevel* rcv_level;
	uint8_t fifo_status;
	uint8_t i = 0;

	interrupt_id = SCI_getInterruptStatus(my_sci_base);
	fifo_status = SCI_getRxFIFOStatus(my_sci_base);
	SCI_enableInterrupt(my_sci_base, SCI_INT_TXFF);

	if (interrupt_id & SCI_INT_RXFF)
	{
		while (SCI_getRxFIFOStatus(my_sci_base) != SCI_FIFO_RX0)
		{
			rcv_data[rcv_cnt++] = SCI_readCharNonBlocking(my_sci_base);
			DELAY_US(100);
		}
	}

	msg = "You sent:\r\n";
	UART_writeCharArray(my_sci_base, msg, strlen(msg));

	for (i = 0; i < rcv_cnt; i++)
	{
	   SCI_writeCharBlockingFIFO(my_sci_base, rcv_data[i]);
	}

	rcv_cnt = 0;

	SCI_setFIFOInterruptLevel(my_sci_base, 0, rcv_level_set);
	SCI_clearInterruptStatus(my_sci_base, SCI_INT_RXFF);
	
    __DSB();
}

