/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define LED_GPIO_PIN    GPIO_PIN_LED2
#define LED_GPIO_CFG    GPIO_CFG_LED2

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */
volatile uint32_t dspTicks = 0;


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */
/*
 * @brief  CPUTimer1 ISR
 */
#if USING_VECTOR_INTERRUPT != 0
__INTERRUPT void TIMER0_IRQHandler(void)
{
    SAVE_IRQ_CSR_CONTEXT();

    CPUTimer_clearOverflowFlag(CPUTIMER0_BASE);
    dspTicks += 1;

    RESTORE_IRQ_CSR_CONTEXT();
}
#else
void TIMER0_IRQHandler(void)
{
	CPUTimer_clearOverflowFlag(CPUTIMER0_BASE);
	dspTicks += 1;
}
#endif

/*
 * @brief  CPUTimer1 initialization
 */
int32_t Timer0_init(uint32_t period)
{
	/* Initialize CPUTimer with interrupt enable */
	CPUTimer_init(CPUTIMER0_BASE, period);

	Interrupt_register(INT_TIMER0, TIMER0_IRQHandler);
	Interrupt_enable(INT_TIMER0);

	return 0;
}

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*
 * @brief  main function.
 */
int main(void)
{
    uint32_t oldTicks;
    uint32_t tickCnt;

    Device_init();

    GPIO_setPinConfig(LED_GPIO_CFG);     //gpio
    GPIO_enableWritePin(LED_GPIO_PIN);

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    log_info("Hello DSP template!\r\n");
    log_info("Core running @ %d MHz.\r\n", DEVICE_SYSCLK_FREQ / 1000000);
    log_info("Code @ 0x%08X, Data @ 0x%08X.\r\n", (uint32_t)main, (uint32_t)&oldTicks);
    log_info("GS32-DSPWare version: %d.%d.%d\r\n", GS32_FW_VERSION_MAJOR, GS32_FW_VERSION_MINOR, GS32_FW_VERSION_REVISION);

    Timer0_init(DEVICE_APBCLK_FREQ/100);    //10ms

    __enable_irq();

    oldTicks = dspTicks;

    while (1) {
        if (dspTicks != oldTicks) {
            oldTicks = dspTicks;
            tickCnt += 1;

            if ((tickCnt % 50) == 0) {
                GPIO_togglePin(LED_GPIO_PIN);
                log_info("ticks: %d\r\n", dspTicks);
            }
        }
    }

    return 0;
}

