/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    dma_ex00_m2m_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "stdio.h"
#include "string.h"
#include "dma_ex00_m2m_board.h"
#include "device.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define DMA_BUF_SIZE 64

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

uint32_t Dma_SrcData[DMA_BUF_SIZE] = {0};
uint32_t Dma_DstData[DMA_BUF_SIZE] = {0};

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

void dma_ex00_m2m(void)
{
//    CacheInfo_Type info;
//    GetDCacheInfo(&info);

    uint32_t errCnt = 0;
    uint32_t i;
    DMA_ConfigParams dmaCfg = {0};

    /* Initialize source test data */
    for(i = 0; i < DMA_BUF_SIZE; i++)
    {
        Dma_SrcData[i] = i + 1;
    }
    memset(Dma_DstData, 0 , DMA_BUF_SIZE);

    /* DMA global enable */
    DMA_initController(DMA_BASE);

    /* Stop DMA channel first - why the DMA channel is still pending after reset? */
    DMA_stopChannel(DMA_BASE);
    dmaCfg.enableInterrupt = 1;
    dmaCfg.srcAddr = (uint32_t)Dma_SrcData;
    dmaCfg.destAddr = (uint32_t)Dma_DstData;
    dmaCfg.blockTS = DMA_BUF_SIZE;
    dmaCfg.ttfc    = DMA_TT_FC_0_M2M_DMAC;
    dmaCfg.srcBtl  = DMA_BTL_4;
    dmaCfg.destBtl = DMA_BTL_4;
    dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.destAddrDirect = DMA_ADDR_INCRE;
    dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_4;
    dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_4;
    DMA_configChannel(DMA_CH1_BASE, &dmaCfg);

    DMA_clearInterrupt(DMA_CH1_BASE, DMA_INT_TFR);
    DMA_unMaskInterrupt(DMA_CH1_BASE, DMA_INT_TFR);
    printf("start DMA \r\n");
    /* DMA channel enable */
    DMA_startChannel(DMA_CH1_BASE);

    while((DMA_getInterruptStatus(DMA_CH1_BASE) & DMA_INT_TFR) == 0);
    //DMA_clearInterrupt(DMA_CH0_BASE,DMA_INT_TFR);
    printf("over DMA \r\n");
    for(i = 0; i < DMA_BUF_SIZE; i++)
    {
        if(Dma_SrcData[i] != Dma_DstData[i])
        {
            errCnt++;

        }
    }

    if(errCnt == 0)
    {
        printf("DMA M2M block transfer test OK.\r\n");
    }
    else
    {
        printf("DMA M2M block transfer test Fail.\r\n");
    }

    printf("test_dma_ex01_m2m end \r\n");
}

#ifdef __cplusplus
}
#endif

