/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"
#include "log.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */
	uint32_t socsMask = (ADC_FORCE_SOC0 |
						 ADC_FORCE_SOC1 |
						 ADC_FORCE_SOC2 |
						 ADC_FORCE_SOC3 |
						 ADC_FORCE_SOC4 |
						 ADC_FORCE_SOC5 |
						 ADC_FORCE_SOC6 |
						 ADC_FORCE_SOC7 |
						 ADC_FORCE_SOC8 |
						 ADC_FORCE_SOC9 |
						 ADC_FORCE_SOC10|
						 ADC_FORCE_SOC11|
						 ADC_FORCE_SOC12|
						 ADC_FORCE_SOC13|
						 ADC_FORCE_SOC14|
						 ADC_FORCE_SOC15);

uint16_t rcv_adc[16][4] = {0};

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */
void adcInit(uint32_t base)
{
	/*
	 * @brief ADC Initialization:
	 * 		  Write ADC configurations and power up the ADC.
	 */
	/* Select ADC Reference mode and Reference voltage */
	ADC_setVREF(base,ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);

	/* Set trim */
	ADC_setINLTrim(base);

	/* Configures the analog-to-digital converter module prescaler. */
	ADC_setPrescaler(base, ADC_CLK_DIV_6_0);

	/* Sets the timing of the end-of-conversion pulse */
	ADC_setInterruptPulseMode(base, ADC_PULSE_END_OF_CONV);

	/* Powers up the ADCA core. */
	ADC_enableConverter(base);

	/* Delay for 1ms to allow ADCA time to power up */
	DEVICE_DELAY_US(5000);

	/*
	 * @brief SOC Configuration:
	 * 		  Setup ADC EPWM channel and trigger settings.
	 */
	/* Disables SOC burst mode. */
	ADC_disableBurstMode(base);

	/* Sets the priority mode of the SOCs. */
	ADC_setSOCPriority(base, ADC_PRI_ALL_ROUND_ROBIN);

	/*
	 * @brief Start of Conversion 0 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 0
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN0
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER0, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN0, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER0, ADC_INT_SOC_TRIGGER_NONE);

	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER1, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN1, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER1, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER2, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN2, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER2, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER3, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER3, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER4, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN4, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER4, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER5, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN5, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER5, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER6, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN6, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER6, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER7, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN7, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER7, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER8, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN8, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER8, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER9, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN9, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER9, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER10, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN10, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER10, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER11, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN11, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER11, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER12, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN12, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER12, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER13, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN13, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER13, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER14, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN1, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER14, ADC_INT_SOC_TRIGGER_NONE);
	/*
	 * @brief Start of Conversion 1 Configuration.
	 *
	 * Configures a SOC in the ADC and its interrupt SOC trigger.
	 * 			SOC number		: 1
	 * 			Trigger			: ADC_TRIGGER_SW_ONLY
	 * 			Channel			: ADC_CH_ADCIN1
	 * 			Sample Window	: 50 SYSCLK cycles
	 * 			Interrupt Trigger: ADC_INT_SOC_TRIGGER_NONE
	 */
	ADC_setupSOC(base, ADC_SOC_NUMBER15, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN1, 50U);
	ADC_setInterruptSOCTrigger(base, ADC_SOC_NUMBER15, ADC_INT_SOC_TRIGGER_NONE);

	/*
	 * @brief ADC Interrupt Initialization:
	 *
	 * ADC Interrupt 1 Configuration
	 * 		Source	: ADC_INT_TRIGGER_EOC1
	 * 		Interrupt Source: enabled
	 * 		Continuous Mode	: disabled
	 */
	ADC_setInterruptSource(base, ADC_INT_NUMBER1, ADC_INT_TRIGGER_EOC15);
	ADC_clearInterruptStatus(base, ADC_INT_NUMBER1);
	ADC_disableContinuousMode(base, ADC_INT_NUMBER1);
	ADC_enableInterrupt(base, ADC_INT_NUMBER1);
}

void DMA_CH_INIT(void)
{
	DMA_ConfigParams dma1Cfg = {0};

	dma1Cfg.blockTS = 16;
	dma1Cfg.enableInterrupt = 0;
	dma1Cfg.dmaSrcReqId = DMAMUX_ReqId_Trig_ADCA_1int;
	dma1Cfg.srcAddr = (uint32_t)ADCARESULT_BASE;
	dma1Cfg.destAddr = (uint32_t)rcv_adc;
	dma1Cfg.reloadDst = false;
	dma1Cfg.reloadSrc = true;
	dma1Cfg.ttfc = DMA_TT_FC_2_P2M_DMAC;
	dma1Cfg.srcBtl = DMA_BTL_16;
	dma1Cfg.destBtl = DMA_BTL_16;
	dma1Cfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_2;
	dma1Cfg.destTrWidthBytes = DMA_TR_WIDTH_BYTE_2;
	dma1Cfg.srcAddrDirect = DMA_ADDR_INCRE;
	dma1Cfg.destAddrDirect = DMA_ADDR_INCRE;
	dma1Cfg.destScatterInterval = 3;
	dma1Cfg.destScatterCount = 1;
	dma1Cfg.enableBlkOfst = true;
	dma1Cfg.blockOffset = 2;

	DMA_configChannel(DMA_CH1_BASE, &dma1Cfg);
}
/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */
/*
 * @brief  main function.
 */
int main(void)
{
	uint16 x,y;
	uint16_t adcResult[16][4] = {0};
    Device_init();

    UartPrint_init(LOG_SCI_BASE, 115200);

    adcInit(ADCA_BASE);

    DMA_initController(DMA_BASE);

    DMA_CH_INIT();

    DMA_startChannel(DMA_CH1_BASE);


    __enable_irq();

    for (y = 0; y < 4; ++y)
    {

    	ADC_forceMultipleSOC(ADCA_BASE, socsMask);

    	while(ADC_getInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1) == false);

    	ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);

    	for (x = 0; x < 16; ++x)
    	{
    		adcResult[x][y] = ADC_readResult(ADCARESULT_BASE, (ADC_SOCNumber)x);
		}

    }

	for (y = 0; y < 16; y++)
	{
		for (x = 0; x < 4; x++)
		{
			if (rcv_adc[y][x] != adcResult[y][x])
			{
				printf("test fail\r\n");
				return 0;
			}
		}
	}

    printf("test ok\r\n");
	return 0;
}

