/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *   @file     clb_ex08_abs2qe.c
 *   @brief
 *   @details

 * See LICENSE for license details.
 */
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "board.h"
#include "pto_abs2qep.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define LED_STA_PIN     GPIO_PIN_LED2

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
//
// Globals used by the position sampling ISR
//
volatile uint32_t ptoDirection;
//
// Globals used for testing the absolute position compared to
// the incremental position measured by the eQEP module
//
volatile uint32_t absolutePositionPrevious = 0;
volatile uint32_t absolutePositionCurrent = 320;
volatile uint32_t absolutePositionNext = 0;
/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

void pto_EPWM1ISR(void)
{
    //
    // Visual marker for viewing waveforms
    // GPIO toggles at the start of the PWM ISR
    //
    // During the PTO:22222
    //  - It will stay low if the direction is reverse
    //  - It will stay high if the direction is forward
    //
    GPIO_togglePin(13);

    absolutePositionCurrent+=500;
    //
    // Start the PTO
    //
    uint32_t incrementalPosition;
    #pragma FORCEINLINE
    pto_abs2qep_runPulseGen(ptoDirection);

    incrementalPosition = EQEP_getPosition(EQEP1_BASE);
    //
    // Test the previous PTO
    //

    absolutePositionPrevious = absolutePositionCurrent;
    //
    // Generate a new absolute position based on the current position
    //
//    absolutePositionNext = pto_generateTestAbsPosition(absolutePositionCurrent);
    absolutePositionNext = absolutePositionCurrent;
    //
    // Process the position and and load the HCL FIFO
    // The first time through, the counters will be
    // loaded.
    //
    ptoDirection = pto_abs2qep_translatePosition(absolutePositionNext);


    //
    // When the ISR is entered again, the next position will
    // be current.
    //
    // Clear INT flag for this timer
    // Acknowledge interrupt group
    //
    absolutePositionPrevious = absolutePositionNext;
    EPWM_clearEventTriggerInterruptFlag(EPWM1_BASE);

//    Interrupt_clearACKGroup(3);
}

int main(void)
{
    uint32_t oldTicks,dir ;
    uint32_t tickCnt;

    Device_init();
    //enable clb Peripherals
    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_CLB);


    __enable_irq();



//	CLB_init();
	  //
	    // Initialization routine for pto_abs2qep operation
	    // Configures the peripherals and enables clocks
	    // Configures GPIO and XBar as needed
	    // Configures the QEP for testing
	    // Configures the PWM for sampling the new position
	    //
	    pto_initAbs2QEP();


	    XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE,XBAR_OUTPUT2, XBAR_OUT_MUX01_CLB1_OUT1 );
	    XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT2, XBAR_MUX01);

	    Interrupt_register(INT_EPWM1, &pto_EPWM1ISR);
	    Interrupt_enable(INT_EPWM1);
    while (1) {


    }

    return 0;
}

