
/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
/**
*   @file    clb_ex09_tz.c
*   @brief
*   @details
* In this example, a COUNTER module is used to create timed events. The use
*/
/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "device.h"
#include "board.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#define EDA_CSIM                  0             //set to 1 when make target for simulation

#if EDA_CSIM != 0
#define LOG_LEVEL                 LOG_ERROR
void _putchar(char character)
{
    //do nothing
}
#else
#define LOG_LEVEL                 LOG_INFO
#endif

#define LED_STA_PIN     GPIO_PIN_LED2
#define GPREG_0_EVENT_DATA_SHIFT  0U
#define GPREG_1_MODE0_EN_SHIFT    1U
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

int main(void)
{
	 uint32_t oldTicks;

		    __disable_irq();

		    Device_init();
		    SysCtl_enablePeripheral(SYSCTL_PERIPH_CLK_CLB);

		    UartPrint_init(LOG_SCI_BASE, 115200);


	    __enable_irq();


       CLB_init();

       XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT1, XBAR_OUT_MUX01_CLB1_OUT2  );
       XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX01);
       XBAR_setOutputMuxConfig(CLBOUTPUTXBAR_BASE, XBAR_OUTPUT2,XBAR_OUT_MUX06_CLB1_OUT7 );
       XBAR_enableOutputMux(CLBOUTPUTXBAR_BASE,XBAR_OUTPUT2,XBAR_MUX06);
       XBAR_setOutputMuxConfig(OUTPUTXBAR_BASE, XBAR_OUTPUT1,XBAR_OUT_MUX15_CLB1_OUT8 );
       XBAR_enableOutputMux(OUTPUTXBAR_BASE,XBAR_OUTPUT1,XBAR_MUX15);



       CLB_enableCLB(myTILE1_BASE);

       CLB_writeSWGateControl(myTILE1_BASE,CLB_SW_GATE_CTRL1, 1);


       CLB_LEVEL_RLS_TZ_CPU1(myTILE1_BASE,1<<6);

      //gp6=1,out6=HIGH,out7=low
       CLB_setGPREG(myTILE1_BASE,0x40);
       CLB_LEVEL_RLS_TZ_CPU2(myTILE1_BASE,1<<7);
       CLB_setGPREG(myTILE1_BASE,0x0);
       while(1)
       {

       }



    return 0;
}

