/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "device.h"

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

#define DEMO_GSRAM_ECC_ERROR       (0)
#define DEMO_DLM_ECC_ERROR         (0)
#define DEMO_ILM_ECC_ERROR         (1)

 void user_default_exception_handler(unsigned long mcause, unsigned long sp)
{
	 /*
	  * ۲nmiflag
	  * register :$mcause $mdcause $mecc_status
	  * */
	volatile  uint16_t nmiflag = SysCtl_getNMIFlagStatus();
    /*
     * ȡGSRAM УϱFlag
     * */
	volatile uint32_t GSRAMParityCheck = SysCtl_getGsRamParityErr();
	while(1);
	return;
}
/*
 * @brief  main function.
 */
int main(void)
{
	__disable_irq();
    Device_init();

    /**
     * @details  ʼϵSRAM/DLM/ILMԼУλbitΪֵ,ǰײʱѾSRAM/DLM/ILMʼSRAMʲΪʼϵʹУ
     * Ϊ֤,low_level_initѾ޸,ȡʼ
     *
     * ÿ鶼µһΣֵ֤
     * */
#if DEMO_GSRAM_ECC_ERROR
    /*
     * жΪ,GSRAMУ
     * */
    volatile uint32_t sum= 0 ;
    for (uint32_t addr = 0x20038000; addr<0x20038000 + (32+16+32)*1024; addr += 4) {
          sum += HWREG(addr);
      }

#elif DEMO_DLM_ECC_ERROR
    /*
     * жΪ,DLMECCУ,
     * */
    volatile uint32_t sum= 0 ;
    for (uint32_t addr = 0x20140000; addr<0x20140000 + (64)*1024; addr += 4) {
          sum += HWREG(addr);
      }
#elif DEMO_ILM_ECC_ERROR
    /*
     * жΪ,ILMECCУ,
     * */
    volatile uint32_t sum= 0 ;
    for (uint32_t addr = 0x20100000; addr<0x20100000 + (256)*1024; addr += 4) {
          sum += HWREG(addr);
      }
#endif
    while (1) {
    }

    return 0;
}

