/*
 * Nested.c
 *
 *  Created on: 2024 Nov 9
 *      Author: hpec8
 */
#include "device.h"
#include "log.h"

void SystemScan1 (void){	log_info("In SystemScan1\r\n");}
void SystemScan2 (void){	log_info("In SystemScan2\r\n");}
void SystemScan3 (void){	log_info("In SystemScan3\r\n");}
void SystemScan4 (void){	log_info("In SystemScan4\r\n");}

void DevicePoll1 (void){	log_info("In DevicePoll1\r\n");}
void DevicePoll2 (void){	log_info("In DevicePoll2\r\n");}
void DevicePoll3 (void){	log_info("In DevicePoll3\r\n");}
void DevicePoll4 (void){	log_info("In DevicePoll4\r\n");}
void DevicePoll5 (void){	log_info("In DevicePoll5\r\n");}
void DevicePoll6 (void){	log_info("In DevicePoll6\r\n");}
void DevicePoll7 (void){	log_info("In DevicePoll7\r\n");}
void DevicePoll8 (void){	log_info("In DevicePoll8\r\n");}


void DeviceUpdate (void*)
{
	log_info("In Function Device Update\r\n");

}

void DeviceInit (void*)
{
	log_info("In Function Device Init\r\n");
}


typedef struct {
    Uint16 RunMode;
    Uint16 DeviceStatus;

    float32 Temperature;
    float32 TargetTemperature;
    float32 Humidity;
    float32 TargetHumidity;
    float32 EnergyConsumption;
    float32 PowerUsage;

    void (*initialize)(void *);
    void (*updateStatus)(void *);

} SmartDeviceConfig;

#define SMARTDEVICE_DEFAULTS {0,0,\
                              0.0, 0.0, 0.0, 0.0, 0.0, 0.0,\
                              DeviceInit,\
                              DeviceUpdate}

typedef struct {
    Uint32 DeviceID;
    Uint32 RoomLocation;
    Uint16 MaintenanceFlag;
    Uint32 GPIO_PowerPin;
    Uint32 GPIO_ControlPin;
    float32 BatteryLevel;
    float32 SignalStrength;
    float32 NetworkLatency;
    float32 PowerAdjustmentRange;
    float32 MinOperatingPower;
    float32 ReferencePower;
    Uint16 ControlMode;
    Uint16 ErrorCount;
    SmartDeviceConfig deviceConfig;
    float32 CurrentDutyCycle;
    float32 AdaptiveFeedback;
} SmartHomeDevice;

typedef struct {
    SmartHomeDevice Devices[8];
    Uint16 TotalDevices;
    Uint16 ActiveDevices;
    Uint16 SystemHealthStatus;
    Uint16 DeviceDiscoveryCount;
    Uint16 NetworkProtocol;
    Uint16 SecurityLevel;
    Uint32 NetworkConfig[3][2];
    Uint32 GatewayPinNumbers[3];
    Uint32 CommunicationPins[3];
    Uint32 SecurityPins[3];
    Uint32 EmergencyControlPins[3];

    void (*SystemScans[4])(void);
    void (*DevicePolling[8])(void);
    float32 CalibrationFactors[8];
    float32 BaselineMetrics[8];
} SmartHomeController;

#define SMARTHOMEDEVICE_DEFAULTS {0, 0, 0, 0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0, 0,\
                                  SMARTDEVICE_DEFAULTS, 0.0, 0.0}

#define SMARTHOMECONTROLLER_DEFAULTS {{SMARTHOMEDEVICE_DEFAULTS,SMARTHOMEDEVICE_DEFAULTS,SMARTHOMEDEVICE_DEFAULTS,SMARTHOMEDEVICE_DEFAULTS,\
                                       SMARTHOMEDEVICE_DEFAULTS,SMARTHOMEDEVICE_DEFAULTS,SMARTHOMEDEVICE_DEFAULTS,SMARTHOMEDEVICE_DEFAULTS},\
                                      0, 0, 0, 0, 0, 0,\
                                      {{0, 0},{0, 0},{0, 0}},\
                                      {0, 0, 0},\
                                      {0, 0, 0},\
                                      {0, 0, 0},\
                                      {0, 0, 0},\
                                      {SystemScan1, SystemScan2, SystemScan3, SystemScan4},\
                                      {DevicePoll1, DevicePoll2, DevicePoll3, DevicePoll4, DevicePoll5, DevicePoll6, DevicePoll7, DevicePoll8},\
                                      {0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}\
                                     }

uint32_t systemOpt = 0;
SmartHomeController homeController = SMARTHOMECONTROLLER_DEFAULTS;

void initializeSystem(void) {
    log_info("Initializing Smart Home System\r\n");
    homeController.Devices[0].deviceConfig.initialize(&systemOpt);
    log_info("System Initialization Reference Value: %d\r\n", homeController.Devices[0].deviceConfig.Temperature);
}











