/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include <time.h>
#include <stdlib.h>

#include "device.h"
#include "log.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define LED_GPIO_PIN    GPIO_PIN_LED1
#define LED_GPIO_CFG    GPIO_CFG_LED1

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */


//#pragma LOCATION( u16_flash, 0x08065FC0 )/* only "#pragma LOCATION" need to add "--gs-pragma-alias" in "properties -> other target flags" */
//#pragma LOCATION_ON( u16_on_flash, 0x08065DB0 )
#pragma LOCATION_ON( u16_on_flash1, 0x08065FE0 )

Uint16 u16_flash;
Uint16 u16_on_flash;
Uint16 u16_on_flash1;


#pragma LOCATION_ON( u32_on_flash	, 0x8070000 );
#pragma LOCATION_ON( u32_on_dlm		, 0x20140860);
#pragma LOCATION_ROM(u32_rom_flash	, 0x8050010	);
#pragma LOCATION_AT( ECap1Regs		, 0x40028000);

//volatile struct ECAP_REGS ECap1Regs;

const uint32 u32_on_flash	= 0x40 ;
	  uint32 u32_on_dlm		= 0x40 ;
const uint32 u32_rom_flash	= 0x40 ;

int __USED  __SYM_LOC_AT (0x8074000)	var_at_int_	;
int __USED  __SYM_LOC_ON (0x8074010)	var_on_int_	;
int __USED  __SYM_LOC_ROM(0x8074020)	var_rom_int_;
//
//int8 __USED  __SYM_LOC_AT(0x1301)  var_at_byte;
//int8 __USED  __SYM_LOC_ON(0x1307)  var_on_byteA;
//int8 __USED  __SYM_LOC_ROM(0xE307) var_rom_byteB;


int main(void)
{
    Device_init();

    GPIO_setPinConfig(LED_GPIO_CFG);     //gpio
    GPIO_enableWritePin(LED_GPIO_PIN);

    UartPrint_init(LOG_SCI_BASE, 115200);

    log_set_level(LOG_DEBUG);

    log_info("Hello #pragma LOCATION test\r\n");
    log_info("&u32_rom_flash = 0x%x\r\n",&u32_rom_flash);
    log_info("u32_rom_flash = %d\r\n",u32_rom_flash);
    log_info("*(uint32_t*)0x8050010 = %d\r\n",*(uint32_t*)0x8050010);

    while (1) {}

    return 0;
}

