/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    Test_CpuCRC.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "GS32F00xx.h"
#include "stdio.h"
#include "crc.h"
#include "interrupt.h"
#include "printf.h"
#include "CRC_ex04_customized_board.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */



/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

uint32_t CRC_data_in_32bit[CPUDATA_SIZE] = {0x00001111,0x11110000,0x00000000,0x11111111};
uint32_t CRC_data_in_24bit[CPUDATA_SIZE] = {0x00000011,0x00000022,0x00000033,0x00000044};
uint32_t CRC_data_in_16bit[CPUDATA_SIZE] = {0x00001111,0x00002222,0x00003333,0x00004444};
uint32_t CRC_data_in_8bit[CPUDATA_SIZE] = {0x00000011,0x00000022,0x00000033,0x00000044};
uint32_t CRC_data_in_7bit = 0x0000005F;
uint32_t goldenValueArray[5] = {0x13BE01DA, 0x06DF14, 0x38FB, 0x06, 0x08};

uint32_t CRC_result[5] = {0,0,0,0,0};


volatile uint32_t watchResult = 0;
uint16_t crcErr = 0;
uint16_t crcRight = 0;
uint16_t intDoneCnt = 0;
uint16_t intFailCnt = 0;
uint16_t intDoneErrCnt = 0;
uint16_t intDoneState[5] = {0,0,0,0,0};

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */


 /**
 * \brief   Test CPUCRC
 * \param   none
 * \retval  None
 */
 void Test_CpuCRC(void)
{
/**********************************************************/
	/* Configuration */
	CRC_ConfigParams crcConfigParams;
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_32BIT;
	crcConfigParams.polyValue = 0x04C11DB8;
	crcConfigParams.dataSize = CPUDATA_SIZE;
	crcConfigParams.goldenValue = 0x13BE01DA;
	crcConfigParams.revin = CRC_REVIN_BYTEREV;
	crcConfigParams.revout = CRC_REVOUT_ON;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);

	for(int i=0;i<CPUDATA_SIZE;i++)
	{
		/*DR INPUT*/
		CRC_writeData(CRC_BASE,CRC_data_in_32bit[i]);
	}

	CRC_result[0] = CRC_getResult(CRC_BASE);

	/* Check if the result is right */
	if(CRC_result[0] == 0x13BE01DA){/*32poly 04C11DB7*/
		crcRight |= 0x01;
	}
	else{
		crcErr |= 0x01;
	}
///**********************************************************/
//	/* Configuration */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_24BIT;
	crcConfigParams.polyValue = 0x00864CF0;
	crcConfigParams.dataSize = CPUDATA_SIZE;
	crcConfigParams.goldenValue = 0x06DF14;
	crcConfigParams.revin = CRC_REVIN_BYTEREV;
	crcConfigParams.revout = CRC_REVOUT_ON;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);
	for(int i=0;i<CPUDATA_SIZE;i++)
	{
		/*DR INPUT*/
		CRC_writeData(CRC_BASE,CRC_data_in_24bit[i]);
	}
	CRC_result[1] = CRC_getResult(CRC_BASE);
	/* Check if the result is right */
	if(CRC_result[1] == 0x06DF14){ /*24poly 864CFB*/
		crcRight |= 0x02;
	}
	else{
		crcErr |= 0x02;
	}
///**********************************************************/
	/* Configuration */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_16BIT;
	crcConfigParams.polyValue = 0x00008006;
	crcConfigParams.dataSize = CPUDATA_SIZE;
	crcConfigParams.goldenValue = 0x38FB;
	crcConfigParams.revin = CRC_REVIN_BYTEREV;
	crcConfigParams.revout = CRC_REVOUT_ON;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);


	for(int i=0;i<CPUDATA_SIZE;i++)
	{
		/*DR INPUT*/
		CRC_writeData(CRC_BASE,CRC_data_in_16bit[i]);
	}


	CRC_result[2] = CRC_getResult(CRC_BASE);
	/* Check if the result is right */
	if(CRC_result[2] == 0x38FB){ /*16poly 8005*/
		crcRight |= 0x04;
	}
	else{
		crcErr |= 0x04;
	}
/**********************************************************/
//	/* Configuration */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_8BIT;
	crcConfigParams.polyValue = 0x00000009;
	crcConfigParams.dataSize = CPUDATA_SIZE;
	crcConfigParams.goldenValue = 0x06;
	crcConfigParams.revin = CRC_REVIN_BYTEREV;
	crcConfigParams.revout = CRC_REVOUT_ON;
	CRC_initConfig(CRC_BASE, crcConfigParams);
	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);


	for(int i=0;i<CPUDATA_SIZE;i++)
	{
		/*DR INPUT*/
		CRC_writeData(CRC_BASE,CRC_data_in_8bit[i]);
	}


	CRC_result[3] = CRC_getResult(CRC_BASE);

	/* Check if the result is right */
	if(CRC_result[3] == 0x06){ /*8poly 07*/
		crcRight |= 0x08;
	}
	else{
		crcRight |= 0x08;
	}
/**********************************************************/
//	/* Configuration */
	crcConfigParams.initData = 0x00000000;
	crcConfigParams.polySize = CRC_POLYSIZE_7BIT;
	crcConfigParams.polyValue = 0x00000003;
	crcConfigParams.dataSize = 1;
	crcConfigParams.goldenValue = 0x08;
	crcConfigParams.revin = CRC_REVIN_BYTEREV;
	crcConfigParams.revout = CRC_REVOUT_ON;
	CRC_initConfig(CRC_BASE, crcConfigParams);

	/* ENABLE  */
	CRC_startCalculation(CRC_BASE);
	/*DR INPUT*/
	CRC_writeData(CRC_BASE,CRC_data_in_7bit);

	CRC_result[4] = CRC_getResult(CRC_BASE);

	/* Check if the result is right */
	if(CRC_result[4] == 0x08){ /*7poly 09*/
		crcRight |= 0x10;
	}
	else{
		crcErr |= 0x10;
	}


	
}


void delay_us(uint32_t delay_us)
{    
  volatile unsigned int num;
  volatile unsigned int t;
 
  
  for (num = 0; num < delay_us; num++)
  {
    t = 11;
    while (t != 0)
    {
      t--;
    }
  }
}


#ifdef __cplusplus
}
#endif

