/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    dma_ex04_CPUTime_board.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include <dma_ex02_adc_1chn.h>
#include "printf.h"
#include "device.h"
#include "cpu.h"



volatile uint16_t testdmabuf[4];
volatile uint16_t result=0;

void adc_init(void)
{


	//adcʼ
	ADC_setVREF(ADCA_BASE,ADC_REFERENCE_INTERNAL,ADC_REFERENCE_3_3V);

	ADC_setINLTrim(ADCA_BASE);
	//÷Ƶ
	ADC_setPrescaler(ADCA_BASE,ADC_CLK_DIV_4_0);
	//жϴʱ
	ADC_setInterruptPulseMode(ADCA_BASE,ADC_PULSE_END_OF_CONV);
	//ʹת
	ADC_enableConverter(ADCA_BASE);

	DEVICE_DELAY_US(5000);
	//ֹͻģʽѯģʽsocsetupSOCбͻģʽ
	ADC_disableBurstMode(ADCA_BASE);
	//ȼ
	ADC_setSOCPriority(ADCA_BASE, ADC_PRI_ALL_ROUND_ROBIN);

	//soc
	ADC_setupSOC(ADCA_BASE, ADC_SOC_NUMBER0, ADC_TRIGGER_SW_ONLY, ADC_CH_ADCIN3, 50U);
	ADC_setInterruptSOCTrigger(ADCC_BASE, ADC_SOC_NUMBER0, ADC_INT_SOC_TRIGGER_NONE);



		//
		// ADC Interrupt 1 Configuration
		// 		Source	: ADC_SOC_NUMBER1
		// 		Interrupt Source: enabled
		// 		Continuous Mode	: enabled
		//
		//
		ADC_setInterruptSource(ADCA_BASE, ADC_INT_NUMBER1, ADC_SOC_NUMBER0);
		ADC_clearInterruptStatus(ADCA_BASE, ADC_INT_NUMBER1);
		ADC_enableContinuousMode(ADCA_BASE, ADC_INT_NUMBER1);
		ADC_enableInterrupt(ADCA_BASE, ADC_INT_NUMBER1);
		EINT;






	//printf("result=\r\n",result);

}


void DMA_init(void)
{
	uint8_t status=0;
	DMA_ConfigParams dmacfg={0};
	DMA_initController(DMA_BASE);
	DMA_stopChannel(DMA_CH1_BASE);
	dmacfg.enableInterrupt = 1;
	dmacfg.destAddr = (uint32_t)(&testdmabuf[0]); /* destination address */
	dmacfg.srcAddr = (uint32_t)(ADCARESULT_BASE); /* source address */
	dmacfg.blockTS = 128; /* block transfer size */
	dmacfg.ttfc = DMA_TT_FC_2_P2M_DMAC;
	dmacfg.srcBtl = DMA_BTL_1;
	dmacfg.destBtl = DMA_BTL_1;
	dmacfg.srcAddrDirect = DMA_ADDR_NO_CHANGE;
	dmacfg.destAddrDirect = DMA_ADDR_NO_CHANGE;
	dmacfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_2;
	dmacfg.destTrWidthBytes = DMA_TR_WIDTH_BYTE_2;

    dmacfg.reloadSrc = true;
    dmacfg.reloadDst = true;
    dmacfg.dmaSrcReqId = DMAMUX_ReqId_Trig_ADCA_1int;

    dmacfg.chPriority = DMA_CH_PRIORITY_0;


    DMA_configChannel(DMA_CH1_BASE,&dmacfg);

	DMA_clearInterrupt(DMA_CH1_BASE,DMA_INT_BLOCK);
	DMA_unMaskInterrupt(DMA_CH1_BASE,DMA_INT_BLOCK);

	DMA_startChannel(DMA_CH1_BASE);
	printf("startchan\r\n");
	status=DMA_getInterruptStatus(DMA_CH1_BASE);
	printf("status=%d\r\n");




}









void dma_adc_1chn(void)
{

	adc_init();
	DMA_init();

	while(1)
	{

		ADC_forceMultipleSOC(ADCC_BASE, ADC_FORCE_SOC0);
		while(ADC_getInterruptStatus(ADCC_BASE, ADC_INT_NUMBER1) == false)
		{
			//printf("get interruptstatus error\r\n");
		}
		//printf("test03_dma_adc_1chn while \r\n");
		ADC_clearInterruptStatus(ADCC_BASE, ADC_INT_NUMBER1);
		result = ADC_readResult(ADCARESULT_BASE, ADC_SOC_NUMBER0);
		if(DMA_getInterruptStatus(DMA_CH1_BASE)==DMA_INT_BLOCK)
		{
			printf("DMA block transfer is over\r\n");
			DMA_clearInterrupt(DMA_CH1_BASE,DMA_INT_BLOCK);
			break;
		}

	}

	DINT;
	//printf("test over \r\n");

}
















#ifdef __cplusplus
}
#endif

